/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.lib.sourceblob;

import com.heroku.sdk.deploy.lib.OutputAdapter;
import com.heroku.sdk.deploy.lib.resolver.JdkVersionResolver;
import com.heroku.sdk.deploy.lib.resolver.ProcfileResolver;
import com.heroku.sdk.deploy.lib.sourceblob.SourceBlobDescriptor;
import com.heroku.sdk.deploy.util.PathUtils;
import com.heroku.sdk.deploy.util.Procfile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class JvmProjectSourceBlobCreator {
    public static SourceBlobDescriptor create(Path projectDirectory, String clientString, List<Path> includedProjectFiles, Supplier<Procfile> customProcfileResolver, Procfile defaultProcfile, Supplier<Optional<String>> customJdkVersionResolver, OutputAdapter outputAdapter) throws IOException, IllegalArgumentException {
        if (!projectDirectory.isAbsolute()) {
            throw new IllegalArgumentException("projectDirectory must be an absolute path!");
        }
        projectDirectory = projectDirectory.normalize();
        SourceBlobDescriptor sourceBlobDescriptor = new SourceBlobDescriptor();
        sourceBlobDescriptor.addSyntheticFile(".heroku-deploy", String.format("client=%s", clientString), true);
        Procfile procfile = ProcfileResolver.resolve(projectDirectory, customProcfileResolver);
        if (procfile.isEmpty()) {
            sourceBlobDescriptor.addSyntheticFile("Procfile", defaultProcfile.asString(), true);
        } else {
            sourceBlobDescriptor.addSyntheticFile("Procfile", procfile.asString(), true);
        }
        JdkVersionResolver.resolve(projectDirectory, customJdkVersionResolver).ifPresent(version -> sourceBlobDescriptor.addSyntheticFile("system.properties", String.format("java.runtime.version=%s", version), true));
        Path jdkOverlayPath = projectDirectory.resolve(".jdk-overlay");
        if (Files.isDirectory(jdkOverlayPath, new LinkOption[0])) {
            for (Path normalizedSubPath : PathUtils.expandDirectory(projectDirectory, jdkOverlayPath)) {
                sourceBlobDescriptor.addLocalPath(normalizedSubPath, projectDirectory.resolve(normalizedSubPath), false);
            }
        }
        for (Path normalized : PathUtils.normalizeAll(projectDirectory, includedProjectFiles)) {
            if (normalized.equals(Paths.get("Procfile", new String[0]))) {
                outputAdapter.logWarn("Procfile was explicitly included! It will take precedence over any other configured process types.");
            }
            if (normalized.equals(Paths.get("system.properties", new String[0]))) {
                outputAdapter.logWarn("system.properties explicitly included! It will take precedence over any other JDK version configuration.");
            }
            for (Path normalizedSubPath : PathUtils.expandDirectory(projectDirectory, normalized)) {
                sourceBlobDescriptor.addLocalPath(normalizedSubPath, projectDirectory.resolve(normalizedSubPath), false);
            }
        }
        return sourceBlobDescriptor;
    }
}

