/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.util;

import com.heroku.sdk.deploy.util.Tuple;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Procfile {
    private final Map<String, String> entries;

    public Procfile(Map<String, String> entries) {
        this.entries = new HashMap<String, String>(entries);
    }

    public void add(String processType, String command) {
        this.entries.put(processType, command);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public Procfile merge(Procfile other) {
        HashMap<String, String> merged = new HashMap<String, String>(this.entries);
        merged.putAll(other.entries);
        return new Procfile(merged);
    }

    public String asString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.entries.forEach((processType, command) -> {
            stringBuilder.append((String)processType);
            stringBuilder.append(": ");
            stringBuilder.append((String)command);
            stringBuilder.append("\n");
        });
        return stringBuilder.toString();
    }

    public static Procfile empty() {
        return new Procfile(Collections.emptyMap());
    }

    public static Procfile singleton(String processType, String command) {
        return new Procfile(Collections.singletonMap(processType, command));
    }

    public static Procfile fromFile(Path path) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return new Procfile(new HashMap<String, String>());
        }
        Map<String, String> entries = Files.readAllLines(path).stream().map(Procfile::parseLine).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Tuple::getA, Tuple::getB));
        return new Procfile(entries);
    }

    private static Optional<Tuple<String, String>> parseLine(String line) {
        if (line.contains(":")) {
            int index = line.indexOf(":");
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim();
            if (key.isEmpty() || value.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new Tuple<String, String>(key.trim(), value.trim()));
        }
        return Optional.empty();
    }
}

