/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;

public class CountingOutputStream
extends OutputStream {
    private OutputStream wrappedOutputStream;
    private Consumer<Long> progressConsumer;
    private long bytesWritten = 0L;

    public CountingOutputStream(OutputStream wrappedOutputStream, Consumer<Long> progressConsumer) {
        this.wrappedOutputStream = wrappedOutputStream;
        this.progressConsumer = progressConsumer;
    }

    @Override
    public void write(int i) throws IOException {
        this.wrappedOutputStream.write(i);
        ++this.bytesWritten;
        this.progressConsumer.accept(this.bytesWritten);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.wrappedOutputStream.write(b);
        this.bytesWritten += (long)b.length;
        this.progressConsumer.accept(this.bytesWritten);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.wrappedOutputStream.write(b, off, len);
        this.bytesWritten += (long)len;
        this.progressConsumer.accept(this.bytesWritten);
    }

    @Override
    public void flush() throws IOException {
        this.wrappedOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrappedOutputStream.close();
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

