/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.heroku.sdk.deploy.api.AppNotFoundException;
import com.heroku.sdk.deploy.api.BuildInfo;
import com.heroku.sdk.deploy.api.HerokuDeployApiException;
import com.heroku.sdk.deploy.api.InsufficientAppPermissionsException;
import com.heroku.sdk.deploy.util.CustomHttpClientBuilder;
import com.heroku.sdk.deploy.util.PropertiesUtils;
import com.heroku.sdk.deploy.util.Util;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.jgit.util.Base64;

public class HerokuDeployApi {
    private Map<String, String> httpHeaders;

    public HerokuDeployApi(String client, String clientVersion, String apiKey) {
        Properties pomProperties = PropertiesUtils.loadPomPropertiesOrEmptyFromClasspath(this.getClass(), "com.heroku.sdk", "heroku-deploy");
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", Base64.encodeBytes((byte[])(":" + apiKey).getBytes()));
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("Accept", "application/vnd.heroku+json; version=3");
        httpHeaders.put("User-Agent", String.format("heroku-deploy/%s (%s/%s) Java/%s (%s)", pomProperties.getProperty("version", "unknown"), client, clientVersion, System.getProperty("java.version"), System.getProperty("java.vendor")));
        this.httpHeaders = httpHeaders;
    }

    public BuildInfo createBuild(String appName, URI sourceBlob, String sourceBlobVersion, List<String> buildpacks) throws IOException, HerokuDeployApiException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        ObjectNode sourceBlobObject = root.putObject("source_blob");
        sourceBlobObject.put("url", sourceBlob.toString());
        sourceBlobObject.put("version", sourceBlobVersion);
        ArrayNode buildpacksArray = root.putArray("buildpacks");
        buildpacks.forEach(buildpackString -> {
            ObjectNode buildpackObjectNode = buildpacksArray.addObject();
            if (buildpackString.startsWith("http")) {
                buildpackObjectNode.put("url", buildpackString);
            } else {
                buildpackObjectNode.put("name", buildpackString);
            }
        });
        StringEntity apiPayloadEntity = new StringEntity(root.toString());
        apiPayloadEntity.setContentType("application/json");
        apiPayloadEntity.setContentEncoding("UTF-8");
        CloseableHttpClient client = CustomHttpClientBuilder.build();
        HttpPost request = new HttpPost("https://api.heroku.com/apps/" + appName + "/builds");
        this.httpHeaders.forEach((arg_0, arg_1) -> ((HttpPost)request).setHeader(arg_0, arg_1));
        request.setEntity((HttpEntity)apiPayloadEntity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        return this.handleBuildInfoResponse(appName, mapper, response);
    }

    public BuildInfo getBuildInfo(String appName, String buildId) throws IOException, HerokuDeployApiException {
        ObjectMapper mapper = new ObjectMapper();
        CloseableHttpClient client = CustomHttpClientBuilder.build();
        HttpGet request = new HttpGet("https://api.heroku.com/apps/" + appName + "/builds/" + buildId);
        this.httpHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequest)request).setHeader(arg_0, arg_1));
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        return this.handleBuildInfoResponse(appName, mapper, response);
    }

    public Stream<String> followBuildOutputStream(URI buildOutputStreamUri) throws IOException {
        CloseableHttpClient client = CustomHttpClientBuilder.build();
        HttpGet request = new HttpGet(buildOutputStreamUri);
        this.httpHeaders.forEach((arg_0, arg_1) -> ((HttpGet)request).setHeader(arg_0, arg_1));
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        HttpEntity responseEntity = response.getEntity();
        return Util.readLinesFromInputStream(responseEntity.getContent());
    }

    private BuildInfo handleBuildInfoResponse(String appName, ObjectMapper mapper, CloseableHttpResponse response) throws IOException, HerokuDeployApiException {
        switch (response.getStatusLine().getStatusCode()) {
            case 404: {
                throw new AppNotFoundException(String.format("App %s could not be found!", appName));
            }
            case 403: {
                throw new InsufficientAppPermissionsException(String.format("Could not access app %s: insufficient permissions", appName));
            }
            case 200: 
            case 201: {
                HttpEntity responseEntity = response.getEntity();
                String responseStringBody = Util.readLinesFromInputStream(responseEntity.getContent()).collect(Collectors.joining());
                return (BuildInfo)mapper.readValue(responseStringBody, BuildInfo.class);
            }
        }
        throw new HerokuDeployApiException(String.format("Unexpected status code: %d!", response.getStatusLine().getStatusCode()));
    }
}

