/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PathUtils {
    public static List<Path> normalizeAll(Path basePath, List<Path> paths) {
        ArrayList<Path> normalizedPaths = new ArrayList<Path>();
        for (Path path : paths) {
            PathUtils.normalize(basePath, path).ifPresent(normalizedPaths::add);
        }
        return normalizedPaths;
    }

    public static Optional<Path> normalize(Path basePath, Path path) {
        Path absoluteBasePath = basePath.toAbsolutePath();
        Path normalizedAbsolutePath = absoluteBasePath.resolve(path).normalize();
        if (normalizedAbsolutePath.startsWith(absoluteBasePath)) {
            return Optional.of(absoluteBasePath.relativize(normalizedAbsolutePath));
        }
        return Optional.empty();
    }

    public static boolean isValidPath(Path basePath, Path path) {
        return PathUtils.normalize(basePath, path).isPresent();
    }

    public static List<Path> expandDirectories(Path basePath, List<Path> paths) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : paths) {
            result.addAll(PathUtils.expandDirectory(basePath, path));
        }
        return result;
    }

    public static List<Path> expandDirectory(Path basePath, Path path) throws IOException {
        return Files.walk(basePath.resolve(path).normalize(), new FileVisitOption[0]).filter(subPath -> !Files.isDirectory(subPath, new LinkOption[0])).map(subPath -> PathUtils.normalize(basePath, subPath)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static String separatorsToUnix(Path path) {
        return path.toString().replace('\\', '/');
    }
}

