/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.maven;

import com.heroku.sdk.maven.MavenApp;
import com.heroku.sdk.maven.executor.ListDependencies;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class HerokuMojo
extends AbstractMojo {
    protected MavenSession mavenSession;
    protected BuildPluginManager pluginManager;
    protected MavenProject mavenProject;
    private File outputPath;
    protected String appName = null;
    protected String jdkVersion = null;
    protected Map<String, String> configVars = null;
    protected String[] mIncludes = new String[0];
    protected boolean includeTarget = true;
    protected String buildFilename = "build.tgz";
    protected boolean logProgess = false;
    protected String[] buildpacks = new String[0];

    protected File getTargetDir() {
        return this.outputPath;
    }

    protected Map<String, String> getConfigVars() {
        return this.configVars;
    }

    protected List<File> getIncludes() {
        ArrayList<File> files = new ArrayList<File>(this.mIncludes.length);
        for (String s : this.mIncludes) {
            if (s.contains("*")) {
                String[] dirs = s.split(File.separator);
                String pattern = dirs[dirs.length - 1];
                File basedir = new File(this.mavenProject.getBasedir(), s.replace(pattern, ""));
                Collection listFiles = FileUtils.listFiles((File)basedir, (IOFileFilter)new WildcardFileFilter(pattern), null);
                files.addAll(listFiles);
                continue;
            }
            files.add(new File(s));
        }
        return files;
    }

    public void setIncludes(String[] includes) {
        this.mIncludes = includes;
    }

    public boolean isIncludeTarget() {
        return this.includeTarget;
    }

    public void setIncludeTarget(boolean includeTarget) {
        this.includeTarget = includeTarget;
    }

    public String getSlugFilename() {
        return this.buildFilename;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ListDependencies.execute(this.mavenProject, this.mavenSession, this.pluginManager);
    }

    void deploy(Map<String, String> processTypes) throws MojoFailureException {
        List<File> includedDirs = this.getIncludes();
        if (this.isIncludeTarget()) {
            includedDirs.add(this.getTargetDir());
        }
        try {
            new MavenApp(this.appName, this.getTargetDir().getParentFile(), this.getTargetDir(), Arrays.asList(this.buildpacks), this.getLog(), this.logProgess).deploy(includedDirs, this.getConfigVars(), this.jdkVersion, processTypes, this.buildFilename);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to deploy application", (Throwable)e);
        }
    }
}

