/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.maven;

import com.heroku.sdk.maven.HerokuMojo;
import com.heroku.sdk.maven.MavenWarApp;
import com.heroku.sdk.maven.executor.CopyWebappRunner;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class HerokuWarMojo
extends HerokuMojo {
    protected File warFile = null;
    protected Map<String, String> processTypes = null;
    protected String webappRunnerVersion = "8.5.38.0";

    protected MavenWarApp prepareWarFile() throws MojoExecutionException, MojoFailureException {
        if (null == this.warFile) {
            if (!"war".equals(this.mavenProject.getPackaging())) {
                throw new MojoExecutionException("Your packaging must be set to 'war' or you must define the '<warFile>' config to use this goal!");
            }
            File[] files = this.getTargetDir().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".war");
                }
            });
            if (files.length == 0) {
                throw new MojoFailureException("Could not find WAR file! Must specify file path in plugin configuration.");
            }
            this.warFile = files[0];
        }
        if (this.processTypes != null && !this.processTypes.isEmpty()) {
            this.getLog().warn((CharSequence)"The <processTypes> value will be ignored when deploying a WAR file. Use `heroku:deploy` goal for custom processes.");
        }
        CopyWebappRunner.execute(this.mavenProject, this.mavenSession, this.pluginManager, this.webappRunnerVersion);
        File webappRunnerJar = new File(this.getTargetDir(), "dependency/webapp-runner.jar");
        return new MavenWarApp(this.appName, this.warFile, webappRunnerJar, this.getTargetDir().getParentFile(), this.getTargetDir(), this.getLog(), this.logProgess, this.buildpacks);
    }
}

