/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.maven.mojo;

import com.heroku.sdk.deploy.lib.OutputAdapter;
import com.heroku.sdk.deploy.lib.running.RunWebApp;
import com.heroku.sdk.maven.MavenLogOutputAdapter;
import com.heroku.sdk.maven.mojo.AbstractHerokuMojo;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run-war", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunWarMojo
extends AbstractHerokuMojo {
    public void execute() throws MojoExecutionException {
        MavenLogOutputAdapter outputAdapter = new MavenLogOutputAdapter(this.getLog(), this.logProgress);
        Path projectDirectory = this.mavenProject.getBasedir().toPath();
        List<String> javaOptions = this.splitOptions(this.configVars.getOrDefault("JAVA_OPTS", ""));
        List<String> webappRunnerOptions = this.splitOptions(this.configVars.getOrDefault("WEBAPP_RUNNER_OPTS", ""));
        Path warFilePath = null;
        try {
            warFilePath = this.findWarFilePath(projectDirectory).orElseThrow(() -> new MojoExecutionException("Could not find WAR file to run!"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not find WAR file to run!", (Exception)e);
        }
        try {
            RunWebApp.run((Path)warFilePath, javaOptions, webappRunnerOptions, (String)this.webappRunnerVersion, (OutputAdapter)outputAdapter);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Exception while running webapp-runner!", e);
        }
    }

    private List<String> splitOptions(String optionString) {
        return Arrays.stream(optionString.split(" ")).filter(string -> !string.trim().isEmpty()).collect(Collectors.toList());
    }
}

