/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.maven.mojo;

import com.heroku.sdk.deploy.lib.OutputAdapter;
import com.heroku.sdk.deploy.lib.deploymemt.Deployer;
import com.heroku.sdk.deploy.lib.deploymemt.DeploymentDescriptor;
import com.heroku.sdk.deploy.lib.resolver.ApiKeyResolver;
import com.heroku.sdk.deploy.lib.resolver.AppNameResolver;
import com.heroku.sdk.deploy.lib.resolver.WebappRunnerResolver;
import com.heroku.sdk.deploy.lib.sourceblob.JvmProjectSourceBlobCreator;
import com.heroku.sdk.deploy.lib.sourceblob.SourceBlobDescriptor;
import com.heroku.sdk.deploy.lib.sourceblob.SourceBlobPackager;
import com.heroku.sdk.deploy.util.FileDownloader;
import com.heroku.sdk.deploy.util.PathUtils;
import com.heroku.sdk.deploy.util.Procfile;
import com.heroku.sdk.deploy.util.PropertiesUtils;
import com.heroku.sdk.maven.MavenLogOutputAdapter;
import com.heroku.sdk.maven.MojoExecutor;
import com.heroku.sdk.maven.mojo.AbstractHerokuMojo;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractHerokuDeployMojo
extends AbstractHerokuMojo {
    protected final void deploy(Mode mode) throws MojoExecutionException, MojoFailureException {
        try {
            MavenLogOutputAdapter outputAdapter = new MavenLogOutputAdapter(this.getLog(), this.logProgress);
            Path projectDirectory = this.mavenProject.getBasedir().toPath();
            Path dependencyList = MojoExecutor.createDependencyListFile(this.mavenProject, this.mavenSession, this.pluginManager);
            ArrayList<Path> includedPaths = new ArrayList<Path>();
            for (String includePattern : this.includes) {
                includedPaths.addAll(this.resolveIncludePattern(includePattern));
            }
            includedPaths.add(Paths.get("pom.xml", new String[0]));
            if (this.includeTarget) {
                includedPaths.add(Paths.get("target", new String[0]));
            }
            Optional<Path> warFilePath = this.resolveWarFilePath(mode, projectDirectory);
            Supplier<Procfile> customProcfileResolver = () -> new Procfile(this.processTypes);
            if (mode == Mode.WAR) {
                if (!this.processTypes.isEmpty()) {
                    outputAdapter.logWarn("The processTypes property will be ignored when deploying a WAR file. Use `heroku:deploy` goal for custom processes.");
                }
                customProcfileResolver = () -> Procfile.singleton((String)"web", (String)("java $JAVA_OPTS -jar webapp-runner.jar $WEBAPP_RUNNER_OPTS --port $PORT " + warFilePath.map(PathUtils::separatorsToUnix).get()));
            }
            SourceBlobDescriptor sourceBlobDescriptor = JvmProjectSourceBlobCreator.create((Path)projectDirectory, (String)"heroku-maven-plugin", includedPaths, customProcfileResolver, (Procfile)Procfile.empty(), () -> Optional.ofNullable(this.jdkVersion), (OutputAdapter)outputAdapter);
            sourceBlobDescriptor.addLocalPath("target/mvn-dependency-list.log", dependencyList, true);
            if (mode == Mode.WAR) {
                Path webappRunnerPath = FileDownloader.download((URI)WebappRunnerResolver.getUrlForVersion((String)this.webappRunnerVersion));
                sourceBlobDescriptor.addLocalPath("webapp-runner.jar", webappRunnerPath, false);
            }
            Path sourceBlob = SourceBlobPackager.pack((SourceBlobDescriptor)sourceBlobDescriptor, (OutputAdapter)outputAdapter);
            String appName = (String)AppNameResolver.resolve((Path)projectDirectory, () -> Optional.ofNullable(this.appName)).orElseThrow(() -> new MojoExecutionException("Could not determine app name, please configure it explicitly!"));
            DeploymentDescriptor deploymentDescriptor = new DeploymentDescriptor(appName, this.buildpacks, this.configVars, sourceBlob, this.mavenProject.getVersion());
            String apiKey = (String)ApiKeyResolver.resolve((Path)projectDirectory).orElseThrow(() -> new MojoExecutionException("Could not resolve API key."));
            Properties pomProperties = PropertiesUtils.loadPomPropertiesOrEmptyFromClasspath(AbstractHerokuDeployMojo.class, (String)"com.heroku.sdk", (String)"heroku-deploy-standalone");
            Deployer.deploy((String)apiKey, (String)"heroku-maven-plugin", (String)pomProperties.getProperty("version", "unknown"), (DeploymentDescriptor)deploymentDescriptor, (OutputAdapter)outputAdapter);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Unexpected error!", e);
        }
    }

    private List<Path> resolveIncludePattern(String includePattern) {
        if (includePattern.contains("*")) {
            String[] dirs = includePattern.split(File.separator);
            String pattern = dirs[dirs.length - 1];
            File basedir = new File(this.mavenProject.getBasedir(), includePattern.replace(pattern, ""));
            return FileUtils.listFiles((File)basedir, (IOFileFilter)new WildcardFileFilter(pattern), null).stream().map(File::toPath).collect(Collectors.toList());
        }
        return Collections.singletonList(this.mavenProject.getBasedir().toPath().resolve(includePattern));
    }

    private Optional<Path> resolveWarFilePath(Mode mode, Path projectDirectory) throws MojoExecutionException, IOException {
        if (mode == Mode.WAR) {
            return super.findWarFilePath(projectDirectory);
        }
        return Optional.empty();
    }

    protected static enum Mode {
        GENERIC,
        WAR;

    }
}

