/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.maven.mojo;

import com.heroku.sdk.deploy.util.PathUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractHerokuMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter(name="appName", property="heroku.appName")
    protected String appName = null;
    @Parameter(name="jdkVersion", property="heroku.jdkVersion")
    protected String jdkVersion = null;
    @Parameter(name="configVars")
    protected Map<String, String> configVars = Collections.emptyMap();
    @Parameter(name="includes")
    protected List<String> includes = new ArrayList<String>();
    @Parameter(name="includeTarget", defaultValue="true")
    protected boolean includeTarget = true;
    @Parameter(name="logProgress", defaultValue="false")
    protected boolean logProgress = false;
    @Parameter(name="buildpacks")
    protected List<String> buildpacks = new ArrayList<String>();
    @Parameter(name="processTypes")
    protected Map<String, String> processTypes = Collections.emptyMap();
    @Parameter(name="warFile")
    protected String warFile = null;
    @Parameter(name="webappRunnerVersion")
    protected String webappRunnerVersion = "9.0.30.0";

    protected Optional<Path> findWarFilePath(Path projectDirectory) throws MojoExecutionException, IOException {
        if (this.warFile == null) {
            if (!this.mavenProject.getPackaging().equals("war")) {
                throw new MojoExecutionException("Your packaging must be set to 'war' or you must define the '<warFile>' config to use this goal!");
            }
            return Files.find(Paths.get(this.mavenProject.getBuild().getDirectory(), new String[0]), Integer.MAX_VALUE, (path, attributes) -> path.toString().endsWith(".war"), new FileVisitOption[0]).findFirst().flatMap(path -> PathUtils.normalize((Path)projectDirectory, (Path)path));
        }
        return PathUtils.normalize((Path)projectDirectory, (Path)Paths.get(this.warFile, new String[0]));
    }
}

