/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.api.RFuture;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisNodeNotFoundException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.SubscribeListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.AsyncSemaphore;
import org.redisson.pubsub.CountDownLatchPubSub;
import org.redisson.pubsub.LockPubSub;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.SemaphorePubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishSubscribeService {
    private static final Logger log = LoggerFactory.getLogger(PublishSubscribeService.class);
    private final ConnectionManager connectionManager;
    private final MasterSlaveServersConfig config;
    private final AsyncSemaphore[] locks = new AsyncSemaphore[50];
    private final AsyncSemaphore freePubSubLock = new AsyncSemaphore(1);
    private final ConcurrentMap<ChannelName, PubSubConnectionEntry> name2PubSubConnection = new ConcurrentHashMap<ChannelName, PubSubConnectionEntry>();
    private final Queue<PubSubConnectionEntry> freePubSubConnections = new ConcurrentLinkedQueue<PubSubConnectionEntry>();
    private final SemaphorePubSub semaphorePubSub = new SemaphorePubSub(this);
    private final CountDownLatchPubSub countDownLatchPubSub = new CountDownLatchPubSub(this);
    private final LockPubSub lockPubSub = new LockPubSub(this);

    public PublishSubscribeService(ConnectionManager connectionManager, MasterSlaveServersConfig config) {
        this.connectionManager = connectionManager;
        this.config = config;
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new AsyncSemaphore(1);
        }
    }

    public LockPubSub getLockPubSub() {
        return this.lockPubSub;
    }

    public CountDownLatchPubSub getCountDownLatchPubSub() {
        return this.countDownLatchPubSub;
    }

    public SemaphorePubSub getSemaphorePubSub() {
        return this.semaphorePubSub;
    }

    public PubSubConnectionEntry getPubSubEntry(ChannelName channelName) {
        return (PubSubConnectionEntry)this.name2PubSubConnection.get(channelName);
    }

    public RFuture<PubSubConnectionEntry> psubscribe(ChannelName channelName, Codec codec, RedisPubSubListener<?> ... listeners) {
        return this.subscribe(PubSubType.PSUBSCRIBE, codec, channelName, new RedissonPromise<PubSubConnectionEntry>(), listeners);
    }

    public RFuture<PubSubConnectionEntry> psubscribe(String channelName, Codec codec, AsyncSemaphore semaphore, RedisPubSubListener<?> ... listeners) {
        RedissonPromise<PubSubConnectionEntry> promise = new RedissonPromise<PubSubConnectionEntry>();
        this.subscribe(codec, new ChannelName(channelName), promise, PubSubType.PSUBSCRIBE, semaphore, listeners);
        return promise;
    }

    public RFuture<PubSubConnectionEntry> subscribe(Codec codec, ChannelName channelName, RedisPubSubListener<?> ... listeners) {
        return this.subscribe(PubSubType.SUBSCRIBE, codec, channelName, new RedissonPromise<PubSubConnectionEntry>(), listeners);
    }

    private RFuture<PubSubConnectionEntry> subscribe(final PubSubType type, final Codec codec, final ChannelName channelName, final RPromise<PubSubConnectionEntry> promise, final RedisPubSubListener<?> ... listeners) {
        final AsyncSemaphore lock = this.getSemaphore(channelName);
        lock.acquire(new Runnable(){

            @Override
            public void run() {
                if (promise.isDone()) {
                    lock.release();
                    return;
                }
                RedissonPromise result = new RedissonPromise();
                promise.onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                    }
                });
                result.onComplete((res, e) -> {
                    if (e != null) {
                        promise.tryFailure((Throwable)e);
                        return;
                    }
                    promise.trySuccess(res);
                });
                PublishSubscribeService.this.subscribe(codec, channelName, result, type, lock, listeners);
            }
        });
        return promise;
    }

    public RFuture<PubSubConnectionEntry> subscribe(Codec codec, String channelName, AsyncSemaphore semaphore, RedisPubSubListener<?> ... listeners) {
        RedissonPromise<PubSubConnectionEntry> promise = new RedissonPromise<PubSubConnectionEntry>();
        this.subscribe(codec, new ChannelName(channelName), promise, PubSubType.SUBSCRIBE, semaphore, listeners);
        return promise;
    }

    public AsyncSemaphore getSemaphore(ChannelName channelName) {
        return this.locks[Math.abs(channelName.hashCode() % this.locks.length)];
    }

    private void subscribe(final Codec codec, final ChannelName channelName, final RPromise<PubSubConnectionEntry> promise, final PubSubType type, final AsyncSemaphore lock, final RedisPubSubListener<?> ... listeners) {
        PubSubConnectionEntry connEntry = (PubSubConnectionEntry)this.name2PubSubConnection.get(channelName);
        if (connEntry != null) {
            this.addListeners(channelName, promise, type, lock, connEntry, listeners);
            return;
        }
        this.freePubSubLock.acquire(new Runnable(){

            @Override
            public void run() {
                if (promise.isDone()) {
                    lock.release();
                    PublishSubscribeService.this.freePubSubLock.release();
                    return;
                }
                PubSubConnectionEntry freeEntry = (PubSubConnectionEntry)PublishSubscribeService.this.freePubSubConnections.peek();
                if (freeEntry == null) {
                    PublishSubscribeService.this.connect(codec, channelName, promise, type, lock, listeners);
                    return;
                }
                int remainFreeAmount = freeEntry.tryAcquire();
                if (remainFreeAmount == -1) {
                    throw new IllegalStateException();
                }
                PubSubConnectionEntry oldEntry = PublishSubscribeService.this.name2PubSubConnection.putIfAbsent(channelName, freeEntry);
                if (oldEntry != null) {
                    freeEntry.release();
                    PublishSubscribeService.this.freePubSubLock.release();
                    PublishSubscribeService.this.addListeners(channelName, promise, type, lock, oldEntry, listeners);
                    return;
                }
                if (remainFreeAmount == 0) {
                    PublishSubscribeService.this.freePubSubConnections.poll();
                }
                PublishSubscribeService.this.freePubSubLock.release();
                final RFuture subscribeFuture = PublishSubscribeService.this.addListeners(channelName, promise, type, lock, freeEntry, listeners);
                ChannelFuture future = PubSubType.PSUBSCRIBE == type ? freeEntry.psubscribe(codec, channelName) : freeEntry.subscribe(codec, channelName);
                future.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            if (!promise.isDone()) {
                                subscribeFuture.cancel(false);
                            }
                            return;
                        }
                        PublishSubscribeService.this.connectionManager.newTimeout(new TimerTask(){

                            @Override
                            public void run(Timeout timeout) throws Exception {
                                subscribeFuture.cancel(false);
                            }
                        }, PublishSubscribeService.this.config.getTimeout(), TimeUnit.MILLISECONDS);
                    }
                });
            }
        });
    }

    private RFuture<Void> addListeners(ChannelName channelName, RPromise<PubSubConnectionEntry> promise, PubSubType type, AsyncSemaphore lock, PubSubConnectionEntry connEntry, RedisPubSubListener<?> ... listeners) {
        for (RedisPubSubListener<?> listener : listeners) {
            connEntry.addListener(channelName, listener);
        }
        SubscribeListener list = connEntry.getSubscribeFuture(channelName, type);
        RFuture<Void> subscribeFuture = list.getSuccessFuture();
        subscribeFuture.onComplete((res, e) -> {
            if (!promise.trySuccess(connEntry)) {
                for (RedisPubSubListener listener : listeners) {
                    connEntry.removeListener(channelName, listener);
                }
                if (!connEntry.hasListeners(channelName)) {
                    this.unsubscribe(channelName, lock);
                } else {
                    lock.release();
                }
            } else {
                lock.release();
            }
        });
        return subscribeFuture;
    }

    private void releaseSubscribeConnection(int slot, PubSubConnectionEntry pubSubEntry) {
        MasterSlaveEntry entry = this.connectionManager.getEntry(slot);
        if (entry == null) {
            log.error("Node for slot: " + slot + " can't be found");
        } else {
            entry.returnPubSubConnection(pubSubEntry);
        }
    }

    private RFuture<RedisPubSubConnection> nextPubSubConnection(int slot) {
        MasterSlaveEntry entry = this.connectionManager.getEntry(slot);
        if (entry == null) {
            RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node for slot: " + slot + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command");
            return RedissonPromise.newFailedFuture(ex);
        }
        return entry.nextPubSubConnection();
    }

    private void connect(Codec codec, ChannelName channelName, final RPromise<PubSubConnectionEntry> promise, PubSubType type, AsyncSemaphore lock, RedisPubSubListener<?> ... listeners) {
        int slot = this.connectionManager.calcSlot(channelName.getName());
        RFuture<RedisPubSubConnection> connFuture = this.nextPubSubConnection(slot);
        promise.onComplete((res, e) -> {
            if (e != null) {
                ((RPromise)connFuture).tryFailure((Throwable)e);
            }
        });
        connFuture.onComplete((conn, e) -> {
            if (e != null) {
                this.freePubSubLock.release();
                lock.release();
                promise.tryFailure((Throwable)e);
                return;
            }
            PubSubConnectionEntry entry = new PubSubConnectionEntry((RedisPubSubConnection)conn, this.config.getSubscriptionsPerConnection());
            int remainFreeAmount = entry.tryAcquire();
            PubSubConnectionEntry oldEntry = this.name2PubSubConnection.putIfAbsent(channelName, entry);
            if (oldEntry != null) {
                this.releaseSubscribeConnection(slot, entry);
                this.freePubSubLock.release();
                this.addListeners(channelName, promise, type, lock, oldEntry, listeners);
                return;
            }
            if (remainFreeAmount > 0) {
                this.freePubSubConnections.add(entry);
            }
            this.freePubSubLock.release();
            final RFuture<Void> subscribeFuture = this.addListeners(channelName, promise, type, lock, entry, listeners);
            ChannelFuture future = PubSubType.PSUBSCRIBE == type ? entry.psubscribe(codec, channelName) : entry.subscribe(codec, channelName);
            future.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        if (!promise.isDone()) {
                            subscribeFuture.cancel(false);
                        }
                        return;
                    }
                    PublishSubscribeService.this.connectionManager.newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            subscribeFuture.cancel(false);
                        }
                    }, PublishSubscribeService.this.config.getTimeout(), TimeUnit.MILLISECONDS);
                }
            });
        });
    }

    public RFuture<Void> unsubscribe(final ChannelName channelName, final AsyncSemaphore lock) {
        final PubSubConnectionEntry entry = (PubSubConnectionEntry)this.name2PubSubConnection.remove(channelName);
        if (entry == null || this.connectionManager.isShuttingDown()) {
            lock.release();
            return RedissonPromise.newSucceededFuture(null);
        }
        final AtomicBoolean executed = new AtomicBoolean();
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        ChannelFuture future = entry.unsubscribe(channelName, new BaseRedisPubSubListener(){

            @Override
            public boolean onStatus(PubSubType type, CharSequence channel) {
                if (type == PubSubType.UNSUBSCRIBE && channel.equals(channelName)) {
                    executed.set(true);
                    if (entry.release() == 1) {
                        PublishSubscribeService.this.freePubSubConnections.add(entry);
                    }
                    lock.release();
                    result.trySuccess(null);
                    return true;
                }
                return false;
            }
        });
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                PublishSubscribeService.this.connectionManager.newTimeout(new TimerTask(){

                    @Override
                    public void run(Timeout timeout) throws Exception {
                        if (executed.get()) {
                            return;
                        }
                        entry.getConnection().onMessage(new PubSubStatusMessage(PubSubType.UNSUBSCRIBE, channelName));
                    }
                }, PublishSubscribeService.this.config.getTimeout(), TimeUnit.MILLISECONDS);
            }
        });
        return result;
    }

    public RFuture<Codec> unsubscribe(final ChannelName channelName, final PubSubType topicType) {
        if (this.connectionManager.isShuttingDown()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        final RedissonPromise<Codec> result = new RedissonPromise<Codec>();
        final AsyncSemaphore lock = this.getSemaphore(channelName);
        lock.acquire(new Runnable(){

            @Override
            public void run() {
                final PubSubConnectionEntry entry = (PubSubConnectionEntry)PublishSubscribeService.this.name2PubSubConnection.remove(channelName);
                if (entry == null) {
                    lock.release();
                    result.trySuccess(null);
                    return;
                }
                PublishSubscribeService.this.freePubSubLock.acquire(new Runnable(){

                    @Override
                    public void run() {
                        PublishSubscribeService.this.freePubSubConnections.remove(entry);
                        PublishSubscribeService.this.freePubSubLock.release();
                        final Codec entryCodec = topicType == PubSubType.PUNSUBSCRIBE ? entry.getConnection().getPatternChannels().get(channelName) : entry.getConnection().getChannels().get(channelName);
                        final AtomicBoolean executed = new AtomicBoolean();
                        BaseRedisPubSubListener listener = new BaseRedisPubSubListener(){

                            @Override
                            public boolean onStatus(PubSubType type, CharSequence channel) {
                                if (type == topicType && channel.equals(channelName)) {
                                    executed.set(true);
                                    lock.release();
                                    result.trySuccess(entryCodec);
                                    return true;
                                }
                                return false;
                            }
                        };
                        ChannelFuture future = topicType == PubSubType.PUNSUBSCRIBE ? entry.punsubscribe(channelName, listener) : entry.unsubscribe(channelName, listener);
                        future.addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    return;
                                }
                                PublishSubscribeService.this.connectionManager.newTimeout(new TimerTask(){

                                    @Override
                                    public void run(Timeout timeout) throws Exception {
                                        if (executed.get()) {
                                            return;
                                        }
                                        entry.getConnection().onMessage(new PubSubStatusMessage(topicType, channelName));
                                    }
                                }, PublishSubscribeService.this.config.getTimeout(), TimeUnit.MILLISECONDS);
                            }
                        });
                    }
                });
            }
        });
        return result;
    }

    public void punsubscribe(final ChannelName channelName, final AsyncSemaphore lock) {
        final PubSubConnectionEntry entry = (PubSubConnectionEntry)this.name2PubSubConnection.remove(channelName);
        if (entry == null || this.connectionManager.isShuttingDown()) {
            lock.release();
            return;
        }
        entry.punsubscribe(channelName, new BaseRedisPubSubListener(){

            @Override
            public boolean onStatus(PubSubType type, CharSequence channel) {
                if (type == PubSubType.PUNSUBSCRIBE && channel.equals(channelName)) {
                    if (entry.release() == 1) {
                        PublishSubscribeService.this.freePubSubConnections.add(entry);
                    }
                    lock.release();
                    return true;
                }
                return false;
            }
        });
    }

    public void reattachPubSub(RedisPubSubConnection redisPubSubConnection) {
        Collection<RedisPubSubListener<?>> listeners;
        PubSubConnectionEntry pubSubEntry;
        for (final PubSubConnectionEntry entry : this.freePubSubConnections) {
            if (!entry.getConnection().equals(redisPubSubConnection)) continue;
            this.freePubSubLock.acquire(new Runnable(){

                @Override
                public void run() {
                    PublishSubscribeService.this.freePubSubConnections.remove(entry);
                    PublishSubscribeService.this.freePubSubLock.release();
                }
            });
            break;
        }
        for (ChannelName channelName : redisPubSubConnection.getChannels().keySet()) {
            pubSubEntry = this.getPubSubEntry(channelName);
            listeners = pubSubEntry.getListeners(channelName);
            this.reattachPubSubListeners(channelName, listeners, PubSubType.UNSUBSCRIBE);
        }
        for (ChannelName channelName : redisPubSubConnection.getPatternChannels().keySet()) {
            pubSubEntry = this.getPubSubEntry(channelName);
            listeners = pubSubEntry.getListeners(channelName);
            this.reattachPubSubListeners(channelName, listeners, PubSubType.PUNSUBSCRIBE);
        }
    }

    private void reattachPubSubListeners(ChannelName channelName, Collection<RedisPubSubListener<?>> listeners, PubSubType topicType) {
        RFuture<Codec> subscribeCodecFuture = this.unsubscribe(channelName, topicType);
        if (listeners.isEmpty()) {
            return;
        }
        subscribeCodecFuture.onComplete((subscribeCodec, e) -> {
            if (subscribeCodec == null) {
                return;
            }
            if (topicType == PubSubType.PUNSUBSCRIBE) {
                this.psubscribe(channelName, listeners, (Codec)subscribeCodec);
            } else {
                this.subscribe(channelName, listeners, (Codec)subscribeCodec);
            }
        });
    }

    private void subscribe(ChannelName channelName, Collection<RedisPubSubListener<?>> listeners, Codec subscribeCodec) {
        RFuture<PubSubConnectionEntry> subscribeFuture = this.subscribe(subscribeCodec, channelName, listeners.toArray(new RedisPubSubListener[listeners.size()]));
        subscribeFuture.onComplete((res, e) -> {
            if (e != null) {
                this.subscribe(channelName, listeners, subscribeCodec);
                return;
            }
            log.info("listeners of '{}' channel to '{}' have been resubscribed", (Object)channelName, (Object)res.getConnection().getRedisClient());
        });
    }

    private void psubscribe(ChannelName channelName, Collection<RedisPubSubListener<?>> listeners, Codec subscribeCodec) {
        RFuture<PubSubConnectionEntry> subscribeFuture = this.psubscribe(channelName, subscribeCodec, listeners.toArray(new RedisPubSubListener[listeners.size()]));
        subscribeFuture.onComplete((res, e) -> {
            if (e != null) {
                this.psubscribe(channelName, listeners, subscribeCodec);
                return;
            }
            log.info("listeners of '{}' channel-pattern to '{}' have been resubscribed", (Object)channelName, (Object)res.getConnection().getRedisClient());
        });
    }

    public String toString() {
        return "PublishSubscribeService [name2PubSubConnection=" + this.name2PubSubConnection + ", freePubSubConnections=" + this.freePubSubConnections + "]";
    }
}

