/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.remote;

import io.netty.util.concurrent.ScheduledFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.redisson.RedissonBlockingQueue;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.remote.BaseRemoteService;
import org.redisson.remote.RRemoteServiceResponse;
import org.redisson.remote.RemoteServiceAck;
import org.redisson.remote.RemoteServiceTimeoutException;
import org.redisson.remote.RequestId;
import org.redisson.remote.ResponseEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRemoteProxy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final CommandAsyncExecutor commandExecutor;
    private final String name;
    final String responseQueueName;
    private final ConcurrentMap<String, ResponseEntry> responses;
    final Codec codec;
    final String executorId;
    final BaseRemoteService remoteService;
    private final Map<Class<?>, String> requestQueueNameCache = new ConcurrentHashMap();

    BaseRemoteProxy(CommandAsyncExecutor commandExecutor, String name, String responseQueueName, ConcurrentMap<String, ResponseEntry> responses, Codec codec, String executorId, BaseRemoteService remoteService) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.responseQueueName = responseQueueName;
        this.responses = responses;
        this.codec = codec;
        this.executorId = executorId;
        this.remoteService = remoteService;
    }

    public String getRequestQueueName(Class<?> remoteInterface) {
        String str = this.requestQueueNameCache.get(remoteInterface);
        if (str == null) {
            str = "{" + this.name + ":" + remoteInterface.getName() + "}";
            this.requestQueueNameCache.put(remoteInterface, str);
        }
        return str;
    }

    protected RFuture<RemoteServiceAck> tryPollAckAgainAsync(RemoteInvocationOptions optionsCopy, String ackName, RequestId requestId) {
        RedissonPromise<RemoteServiceAck> promise = new RedissonPromise<RemoteServiceAck>();
        RFuture ackClientsFuture = this.commandExecutor.evalWriteAsync(ackName, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 0;end;redis.call('del', KEYS[1]);return 1;", Arrays.asList(ackName), optionsCopy.getAckTimeoutInMillis());
        ackClientsFuture.onComplete((res, e) -> {
            if (e != null) {
                promise.tryFailure((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                RPromise ackFuture = this.pollResponse(this.commandExecutor.getConnectionManager().getConfig().getTimeout(), requestId, true);
                ackFuture.onComplete((r, ex) -> {
                    if (ex != null) {
                        promise.tryFailure((Throwable)ex);
                        return;
                    }
                    promise.trySuccess((RemoteServiceAck)r);
                });
            } else {
                promise.trySuccess(null);
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends RRemoteServiceResponse> RPromise<T> pollResponse(final long timeout, final RequestId requestId, boolean insertFirst) {
        ResponseEntry entry;
        final RedissonPromise responseFuture = new RedissonPromise();
        ConcurrentMap<String, ResponseEntry> concurrentMap = this.responses;
        synchronized (concurrentMap) {
            ResponseEntry oldEntry;
            entry = (ResponseEntry)this.responses.get(this.responseQueueName);
            if (entry == null && (oldEntry = this.responses.putIfAbsent(this.responseQueueName, entry = new ResponseEntry())) != null) {
                entry = oldEntry;
            }
            responseFuture.onComplete((res, ex) -> {
                if (responseFuture.isCancelled()) {
                    ConcurrentMap<String, ResponseEntry> concurrentMap = this.responses;
                    synchronized (concurrentMap) {
                        ResponseEntry e = (ResponseEntry)this.responses.get(this.responseQueueName);
                        List<ResponseEntry.Result> list = e.getResponses().get(requestId);
                        if (list == null) {
                            return;
                        }
                        Iterator<ResponseEntry.Result> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ResponseEntry.Result result = iterator.next();
                            if (result.getPromise() != responseFuture) continue;
                            result.getScheduledFuture().cancel(true);
                            iterator.remove();
                        }
                        if (list.isEmpty()) {
                            e.getResponses().remove(requestId);
                        }
                        if (e.getResponses().isEmpty()) {
                            this.responses.remove(this.responseQueueName, e);
                        }
                    }
                }
            });
            ScheduledFuture<?> future = this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ConcurrentMap concurrentMap = BaseRemoteProxy.this.responses;
                    synchronized (concurrentMap) {
                        ResponseEntry entry = (ResponseEntry)BaseRemoteProxy.this.responses.get(BaseRemoteProxy.this.responseQueueName);
                        if (entry == null) {
                            return;
                        }
                        RemoteServiceTimeoutException ex = new RemoteServiceTimeoutException("No response after " + timeout + "ms");
                        if (responseFuture.tryFailure(ex)) {
                            List<ResponseEntry.Result> list = entry.getResponses().get(requestId);
                            list.remove(0);
                            if (list.isEmpty()) {
                                entry.getResponses().remove(requestId);
                            }
                            if (entry.getResponses().isEmpty()) {
                                BaseRemoteProxy.this.responses.remove(BaseRemoteProxy.this.responseQueueName, entry);
                            }
                        }
                    }
                }
            }, timeout, TimeUnit.MILLISECONDS);
            Map<RequestId, List<ResponseEntry.Result>> entryResponses = entry.getResponses();
            List<ResponseEntry.Result> list = entryResponses.get(requestId);
            if (list == null) {
                list = new ArrayList<ResponseEntry.Result>(3);
                entryResponses.put(requestId, list);
            }
            ResponseEntry.Result res2 = new ResponseEntry.Result(responseFuture, future);
            if (insertFirst) {
                list.add(0, res2);
            } else {
                list.add(res2);
            }
        }
        this.pollResponse(entry);
        return responseFuture;
    }

    private <V> RBlockingQueue<V> getBlockingQueue(String name, Codec codec) {
        return new RedissonBlockingQueue(codec, this.commandExecutor, name, null);
    }

    private void pollResponse(ResponseEntry ent) {
        if (!ent.getStarted().compareAndSet(false, true)) {
            return;
        }
        RBlockingQueue queue = this.getBlockingQueue(this.responseQueueName, this.codec);
        RFuture<RRemoteServiceResponse> future = queue.takeAsync();
        future.onComplete(this.createResponseListener());
    }

    private BiConsumer<RRemoteServiceResponse, Throwable> createResponseListener() {
        return (response, e) -> {
            RPromise<RRemoteServiceResponse> promise;
            if (e != null) {
                this.log.error("Can't get response from " + this.responseQueueName, (Throwable)e);
                return;
            }
            ConcurrentMap<String, ResponseEntry> concurrentMap = this.responses;
            synchronized (concurrentMap) {
                ResponseEntry entry = (ResponseEntry)this.responses.get(this.responseQueueName);
                if (entry == null) {
                    return;
                }
                RequestId key = new RequestId(response.getId());
                List<ResponseEntry.Result> list = entry.getResponses().get(key);
                if (list == null) {
                    RBlockingQueue responseQueue = this.getBlockingQueue(this.responseQueueName, this.codec);
                    responseQueue.takeAsync().onComplete(this.createResponseListener());
                    return;
                }
                ResponseEntry.Result res = list.remove(0);
                if (list.isEmpty()) {
                    entry.getResponses().remove(key);
                }
                promise = res.getPromise();
                res.getScheduledFuture().cancel(true);
                if (entry.getResponses().isEmpty()) {
                    this.responses.remove(this.responseQueueName, entry);
                } else {
                    RBlockingQueue responseQueue = this.getBlockingQueue(this.responseQueueName, this.codec);
                    responseQueue.takeAsync().onComplete(this.createResponseListener());
                }
            }
            if (promise != null) {
                promise.trySuccess((RRemoteServiceResponse)response);
            }
        };
    }
}

