/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;

public class RedisURI {
    private final boolean ssl;
    private final String host;
    private final int port;

    public RedisURI(String uri) {
        if (!uri.startsWith("redis://") && !uri.startsWith("rediss://")) {
            throw new IllegalArgumentException("Redis url should start with redis:// or rediss:// (for SSL connection)");
        }
        String urlHost = uri.replaceFirst("redis://", "http://").replaceFirst("rediss://", "http://");
        String ipV6Host = uri.substring(uri.indexOf("://") + 3, uri.lastIndexOf(":"));
        if (ipV6Host.contains("@")) {
            ipV6Host = ipV6Host.split("@")[1];
        }
        if (ipV6Host.contains(":")) {
            urlHost = urlHost.replace(ipV6Host, "[" + ipV6Host + "]");
        }
        try {
            URL url = new URL(urlHost);
            this.host = url.getHost();
            this.port = url.getPort();
            this.ssl = uri.startsWith("rediss://");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getScheme() {
        if (this.ssl) {
            return "rediss";
        }
        return "redis";
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private static String trimIpv6Brackets(String host) {
        if (host.startsWith("[") && host.endsWith("]")) {
            return host.substring(1, host.length() - 1);
        }
        return host;
    }

    public static boolean compare(InetSocketAddress entryAddr, RedisURI addr) {
        return (entryAddr.getHostName() != null && entryAddr.getHostName().equals(RedisURI.trimIpv6Brackets(addr.getHost())) || entryAddr.getAddress().getHostAddress().equals(RedisURI.trimIpv6Brackets(addr.getHost()))) && entryAddr.getPort() == addr.getPort();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.ssl ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RedisURI other = (RedisURI)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.ssl == other.ssl;
    }

    public String toString() {
        return this.getScheme() + "://" + this.host + ":" + this.port;
    }
}

