/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.server.HandshakeRequest;
import org.apache.tomcat.util.collections.CaseInsensitiveKeyMap;
import org.apache.tomcat.util.res.StringManager;

public class WsHandshakeRequest
implements HandshakeRequest {
    private static final StringManager sm = StringManager.getManager(WsHandshakeRequest.class);
    private final URI requestUri;
    private final Map<String, List<String>> parameterMap;
    private final String queryString;
    private final Principal userPrincipal;
    private final Map<String, List<String>> headers;
    private final Object httpSession;
    private volatile HttpServletRequest request;

    public WsHandshakeRequest(HttpServletRequest request, Map<String, String> pathParams) {
        this.request = request;
        this.queryString = request.getQueryString();
        this.userPrincipal = request.getUserPrincipal();
        this.httpSession = request.getSession(false);
        this.requestUri = WsHandshakeRequest.buildRequestUri(request);
        Map<String, String[]> originalParameters = request.getParameterMap();
        HashMap<String, List<Object>> newParameters = new HashMap<String, List<Object>>(originalParameters.size());
        for (Map.Entry<String, String[]> entry : originalParameters.entrySet()) {
            newParameters.put(entry.getKey(), Collections.unmodifiableList(Arrays.asList((Object[])entry.getValue())));
        }
        for (Map.Entry<String, Object> entry : pathParams.entrySet()) {
            newParameters.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        this.parameterMap = Collections.unmodifiableMap(newParameters);
        CaseInsensitiveKeyMap<List<String>> newHeaders = new CaseInsensitiveKeyMap<List<String>>();
        Enumeration<String> enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String headerName = enumeration.nextElement();
            newHeaders.put(headerName, Collections.unmodifiableList(Collections.list(request.getHeaders(headerName))));
        }
        this.headers = Collections.unmodifiableMap(newHeaders);
    }

    @Override
    public URI getRequestURI() {
        return this.requestUri;
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this.request == null) {
            throw new IllegalStateException();
        }
        return this.request.isUserInRole(role);
    }

    @Override
    public Object getHttpSession() {
        return this.httpSession;
    }

    void finished() {
        this.request = null;
    }

    private static URI buildRequestUri(HttpServletRequest req) {
        StringBuilder uri = new StringBuilder();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        if (port < 0) {
            port = 80;
        }
        if ("http".equals(scheme)) {
            uri.append("ws");
        } else if ("https".equals(scheme)) {
            uri.append("wss");
        } else if ("wss".equals(scheme) || "ws".equals(scheme)) {
            uri.append(scheme);
        } else {
            throw new IllegalArgumentException(sm.getString("wsHandshakeRequest.unknownScheme", scheme));
        }
        uri.append("://");
        uri.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("ws") && port != 80 || scheme.equals("wss") && port != 443 || scheme.equals("https") && port != 443) {
            uri.append(':');
            uri.append(port);
        }
        uri.append(req.getRequestURI());
        if (req.getQueryString() != null) {
            uri.append('?');
            uri.append(req.getQueryString());
        }
        try {
            return new URI(uri.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(sm.getString("wsHandshakeRequest.invalidUri", uri.toString()), e);
        }
    }
}

