/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.redisson.tomcat.RedissonSession;

public class UsageValve
extends ValveBase {
    private static final String ALREADY_FILTERED_NOTE = UsageValve.class.getName() + ".ALREADY_FILTERED_NOTE";
    private final AtomicInteger usage = new AtomicInteger(1);

    public UsageValve() {
        super(true);
    }

    public void incUsage() {
        this.usage.incrementAndGet();
    }

    public int decUsage() {
        return this.usage.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.getNext() == null) {
            return;
        }
        if (request.getNote(ALREADY_FILTERED_NOTE) == null) {
            RedissonSession s;
            HttpSession session;
            request.setNote(ALREADY_FILTERED_NOTE, Boolean.TRUE);
            try {
                if (request.getContext() != null && (session = request.getSession(false)) != null && (s = (RedissonSession)request.getContext().getManager().findSession(session.getId())) != null) {
                    s.startUsage();
                }
                this.getNext().invoke(request, response);
            }
            finally {
                request.removeNote(ALREADY_FILTERED_NOTE);
                if (request.getContext() != null && (session = request.getSession(false)) != null && (s = (RedissonSession)request.getContext().getManager().findSession(session.getId())) != null) {
                    s.endUsage();
                }
            }
        } else {
            this.getNext().invoke(request, response);
        }
    }
}

