/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class LXClassLoader
extends URLClassLoader {
    static final String PACKAGE_DESCRIPTOR_FILE_NAME = "lx.package";
    private final LX lx;
    private final List<Class<?>> classes = new ArrayList();
    private final List<File> jarFiles;

    private static List<File> defaultJarFiles(LX lx) {
        ArrayList<File> jarFiles = new ArrayList<File>();
        LXClassLoader.collectJarFiles(jarFiles, lx.getMediaFolder(LX.Media.PACKAGES, false));
        return jarFiles;
    }

    private static void collectJarFiles(List<File> jarFiles, File folder) {
        try {
            if (folder.exists() && folder.isDirectory()) {
                for (File file : folder.listFiles()) {
                    if (file.isHidden()) continue;
                    if (file.isDirectory()) {
                        LXClassLoader.collectJarFiles(jarFiles, file);
                        continue;
                    }
                    if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                    jarFiles.add(file);
                }
            }
        }
        catch (Exception x) {
            LX.error(x, "Unhandled exception loading custom content dir: " + folder);
        }
    }

    private static URL[] fileListToURLArray(List<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LX.error(e, "Bad URL in file list: " + file);
            }
        }
        return urls.toArray(new URL[0]);
    }

    protected LXClassLoader(LX lx) {
        this(lx, LXClassLoader.defaultJarFiles(lx));
    }

    protected LXClassLoader(LX lx, List<File> jarFiles) {
        super(LXClassLoader.fileListToURLArray(jarFiles), lx.getClass().getClassLoader());
        this.lx = lx;
        this.jarFiles = jarFiles;
    }

    protected void load() {
        for (File jarFile : this.jarFiles) {
            this.loadJarFile(jarFile);
        }
    }

    protected void dispose() {
        for (Class<?> clz : this.classes) {
            this.lx.registry.removeClass(clz);
        }
        this.classes.clear();
    }

    private void loadJarFile(File file) {
        LX.log("Loading package content from: " + file);
        Package pack = new Package(file);
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String fileName = entry.getName();
                if (fileName.equals(PACKAGE_DESCRIPTOR_FILE_NAME)) {
                    try {
                        JsonObject obj = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(jarFile.getInputStream(entry)), JsonObject.class);
                        if (obj.has("name")) {
                            pack.name = obj.get("name").getAsString();
                        }
                        if (!obj.has("author")) continue;
                        pack.author = obj.get("author").getAsString();
                    }
                    catch (Throwable x) {
                        LX.error(x, "Exception reading lx.package contents for: " + jarFile);
                    }
                    continue;
                }
                if (!fileName.endsWith(".class")) continue;
                this.loadClassEntry(pack, jarFile, LXClassLoader.className(fileName).replaceAll("/", "\\."));
            }
        }
        catch (IOException iox) {
            LX.error(iox, "IOException unpacking JAR file " + file + " - " + iox.getLocalizedMessage());
            pack.setError(iox);
        }
        catch (Error | Exception e) {
            LX.error(e, "Unhandled exception loading JAR file " + file + " - " + e.getLocalizedMessage());
            pack.setError(e);
        }
        this.lx.registry.addPackage(pack);
    }

    private static String className(String fileName) {
        return fileName.substring(0, fileName.length() - ".class".length());
    }

    private void loadClassEntry(Package pack, JarFile jarFile, String className) {
        try {
            Class<?> clz = this.loadClass(className, false);
            clz.getSimpleName();
            int modifiers = clz.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers)) {
                ++pack.numClasses;
                this.classes.add(clz);
                this.lx.registry.addClass(clz);
            }
        }
        catch (ClassNotFoundException cnfx) {
            LX.error(cnfx, "Class not actually found, expected in JAR file: " + className + " " + jarFile.getName());
        }
        catch (Exception x) {
            LX.error(x, "Unhandled exception in class loading: " + className);
        }
    }

    public static class Package {
        final File jarFile;
        private String name;
        private String author = "Unknown Author";
        private Throwable error = null;
        private int numClasses = 0;

        private Package(File jarFile) {
            this.jarFile = jarFile;
            this.name = jarFile.getName();
            if (this.name.endsWith(".jar")) {
                this.name = this.name.substring(0, this.name.length() - ".jar".length());
            }
        }

        public String getFileName() {
            return this.jarFile.getName();
        }

        public String getName() {
            return this.name;
        }

        public String getAuthor() {
            return this.author;
        }

        private void setError(Throwable error) {
            this.error = error;
        }

        public int getNumClasses() {
            return this.numClasses;
        }

        public boolean hasError() {
            return this.error != null;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

