/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponentName;
import heronarts.lx.LXPath;
import heronarts.lx.LXPresetComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.DiscreteColorParameter;
import heronarts.lx.modulation.LXModulationContainer;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscArgument;
import heronarts.lx.osc.OscInt;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.StringParameter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class LXComponent
implements LXPath,
LXParameterListener,
LXSerializable {
    protected LX lx;
    private LXComponent parent;
    private String path;
    private final LinkedHashMap<String, LXComponent> mutableChildren = new LinkedHashMap();
    public final Map<String, LXComponent> children = Collections.unmodifiableMap(this.mutableChildren);
    private final LinkedHashMap<String, List<? extends LXComponent>> childArrays = new LinkedHashMap();
    private int id;
    private String description = null;
    public final StringParameter label = new StringParameter("Label").setDescription("The name of this component");
    public final DiscreteColorParameter modulationColor = (DiscreteColorParameter)new DiscreteColorParameter("Modulation Color").setDescription("The color used to indicate this modulation source");
    public final BooleanParameter modulationControlsExpanded = new BooleanParameter("Expanded", true).setDescription("Whether the modulation controls are expanded");
    public final BooleanParameter modulationsExpanded = new BooleanParameter("Show Modulations", true).setDescription("Whether the modulations are visible");
    public final StringParameter presetFile = new StringParameter("Preset", null).setDescription("Name of last preset file that has been loaded/saved");
    private static final String INTERNAL_PREFIX = "internal/";
    private static final int ID_UNASSIGNED = -1;
    static final int ID_ENGINE = 1;
    private static final String PATH_OSC_QUERY = "osc-query";
    private boolean disposed = false;
    protected final LXParameter.Collection parameters = new LXParameter.Collection();
    protected final LXParameter.Collection internalParameters = new LXParameter.Collection();
    protected final LXParameter.Collection legacyParameters = new LXParameter.Collection();
    protected final LXParameter.Collection legacyInternalParameters = new LXParameter.Collection();
    private final LXParameterListener oscListener = p -> {
        if (this.lx != null && this.lx.engine != null && this.lx.engine.osc != null) {
            this.lx.engine.osc.sendParameter(p);
        }
    };
    public static final String KEY_ID = "id";
    public static final String KEY_CLASS = "class";
    public static final String KEY_RESET = "_reset_";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_INTERNAL = "internal";
    public static final String KEY_CHILDREN = "children";
    public static final String KEY_COMPONENT_ID = "componentId";
    public static final String KEY_PARAMETER_PATH = "parameterPath";
    public static final String KEY_PATH = "path";

    public static String getComponentName(Class<? extends LXComponent> component, String suffix) {
        LXComponentName annotation = component.getAnnotation(LXComponentName.class);
        if (annotation != null) {
            return annotation.value();
        }
        String simple = component.getSimpleName();
        if (simple.endsWith(suffix)) {
            simple = simple.substring(0, simple.length() - suffix.length());
        }
        return simple;
    }

    public static String getComponentName(Class<? extends LXComponent> cls) {
        LXComponentName annotation = cls.getAnnotation(LXComponentName.class);
        if (annotation != null) {
            return annotation.value();
        }
        String suffix = "";
        Class<? extends LXComponent> generic = cls;
        while (generic != null) {
            if (generic.getSimpleName().startsWith("LX")) {
                suffix = generic.getSimpleName().substring(2);
                break;
            }
            generic = generic.getSuperclass().asSubclass(LXComponent.class);
        }
        return LXComponent.getComponentName(cls, suffix);
    }

    public static String getComponentName(LXComponent component, String suffix) {
        return LXComponent.getComponentName(component.getClass(), suffix);
    }

    protected LXComponent() {
        this(null, -1);
    }

    protected LXComponent(LX lx) {
        this(lx, -1);
    }

    protected LXComponent(LX lx, String label) {
        this(lx, -1, label);
    }

    protected LXComponent(LX lx, int id) {
        this(lx, id, null);
    }

    protected LXComponent(LX lx, int id, String label) {
        this.lx = lx;
        this.id = id;
        if (id != -1 && lx == null) {
            throw new IllegalArgumentException("Cannot specify id on component with no LX instance");
        }
        if (lx != null) {
            lx.componentRegistry.register(this);
        }
        this.label.setValue(label != null ? label : LXComponent.getComponentName(this.getClass()));
        this.addParameter("label", this.label);
        this.addInternalParameter("modulationColor", this.modulationColor);
        this.addInternalParameter("modulationControlsExpanded", this.modulationControlsExpanded);
        this.addInternalParameter("modulationsExpanded", this.modulationsExpanded);
        this.addInternalParameter("presetFile", this.presetFile);
    }

    public LX getLX() {
        return this.lx;
    }

    public static String getCategory(Class<? extends LXComponent> clazz) {
        LXCategory annotation = clazz.getAnnotation(LXCategory.class);
        return annotation != null ? annotation.value() : "Other";
    }

    private void _checkPath(String path, String type) {
        if (this.parameters.containsKey(path)) {
            throw new IllegalStateException("Cannot add " + type + " at path " + path + ", parameter already exists");
        }
        if (this.mutableChildren.containsKey(path)) {
            throw new IllegalStateException("Cannot add " + type + " at path " + path + ", child already exists");
        }
        if (this.childArrays.containsKey(path)) {
            throw new IllegalStateException("Cannot add " + type + " at path " + path + ", array already exists");
        }
    }

    protected LXComponent addArray(String path, List<? extends LXComponent> childArray) {
        if (childArray == null) {
            throw new IllegalStateException("Cannot add null LXComponent.addArray()");
        }
        this._checkPath(path, "array");
        this.childArrays.put(path, childArray);
        return this;
    }

    protected LXComponent addChild(String path, LXComponent child) {
        if (child == null) {
            throw new IllegalStateException("Cannot add null LXComponent.addChild()");
        }
        this._checkPath(path, "child");
        child.setParent(this, path);
        this.mutableChildren.put(path, child);
        return this;
    }

    public LXComponent getChild(String path) {
        return this.mutableChildren.get(path);
    }

    protected final LXComponent setParent(LXComponent parent) {
        return this.setParent(parent, null);
    }

    private final LXComponent setParent(LXComponent parent, String path) {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot LXComponent.setParent() when parent already set: " + this + " " + this.parent + " " + parent);
        }
        if (parent == null) {
            throw new IllegalArgumentException("Cannot LXComponent.setParent(null): " + this);
        }
        if (parent.lx == null) {
            throw new IllegalStateException("Cannot LXComponent.setParent() with unregistered parent: " + this + " " + parent);
        }
        if (parent == this) {
            throw new IllegalStateException("LXComponent cannot be its own parent: " + parent);
        }
        this.parent = parent;
        this.path = path;
        if (this.lx == null) {
            this.lx = parent.lx;
            this.lx.componentRegistry.register(this);
        }
        return this;
    }

    @Override
    public final LXComponent getParent() {
        return this.parent;
    }

    public final int getId() {
        return this.id;
    }

    public String getOscPath() {
        return this.path;
    }

    public boolean isValidOscParameter(LXParameter parameter) {
        return this.parameters.containsKey(parameter.getPath());
    }

    public final boolean contains(LXPath that) {
        while (that != null) {
            if (that == this) {
                return true;
            }
            that = that.getParent();
        }
        return false;
    }

    public String getOscLabel() {
        return this.getLabel().trim().replaceAll("[\\s#*,/\\\\?\\[\\]{}]+", "-");
    }

    public String getOscAddress() {
        return this.getCanonicalPath();
    }

    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        if (path.equals(PATH_OSC_QUERY)) {
            this.oscQuery();
            return true;
        }
        LXComponent child = this.getChild(path);
        if (child != null) {
            return child.handleOscMessage(message, parts, index + 1);
        }
        List<? extends LXComponent> array = this.childArrays.get(path);
        if (array != null) {
            int arrayIndex;
            String arrayId = parts[index + 1];
            if (arrayId.matches("\\d+") && (arrayIndex = Integer.parseInt(arrayId) - 1) >= 0 && arrayIndex < array.size()) {
                return array.get(arrayIndex).handleOscMessage(message, parts, index + 2);
            }
            LXOscEngine.error("Invalid array index in OSC message: " + parts[index + 1] + " (" + message + ")");
            return false;
        }
        LXParameter parameter = this.getParameter(path);
        if (parameter == null) {
            LXOscEngine.error("Component " + this + " did not find anything at OSC path: " + path + " (" + message + ")");
            return false;
        }
        return this.handleOscParameter(message, parameter, parts, index);
    }

    private boolean handleOscParameter(OscMessage message, LXParameter parameter, String[] parts, int index) {
        if (parameter instanceof BooleanParameter) {
            ((BooleanParameter)parameter).setValue(message.getBoolean());
        } else if (parameter instanceof StringParameter) {
            ((StringParameter)parameter).setValue(message.getString());
        } else if (parameter instanceof AggregateParameter) {
            if (parts.length >= index + 1) {
                LXParameter subparameter = ((AggregateParameter)parameter).subparameters.get(parts[index + 1]);
                if (subparameter != null) {
                    return this.handleOscParameter(message, subparameter, parts, index + 1);
                }
                LXOscEngine.error("Component " + this + " did not find anything at OSC path: " + this.path + " (" + message + ")");
                return false;
            }
            ((ColorParameter)parameter).setColor(message.getInt());
        } else if (parameter instanceof DiscreteParameter) {
            OscArgument arg = message.get();
            if (arg instanceof OscInt || ((DiscreteParameter)parameter).getOscMode() == LXNormalizedParameter.OscMode.ABSOLUTE) {
                parameter.setValue(arg.toInt());
            } else {
                ((DiscreteParameter)parameter).setNormalized(arg.toFloat());
            }
        } else if (parameter instanceof LXNormalizedParameter) {
            LXNormalizedParameter normalizedParameter = (LXNormalizedParameter)parameter;
            if (normalizedParameter.getOscMode() == LXNormalizedParameter.OscMode.ABSOLUTE) {
                normalizedParameter.setValue(message.getFloat());
            } else {
                normalizedParameter.setNormalized(message.getFloat());
            }
        } else {
            parameter.setValue(message.getFloat());
        }
        return true;
    }

    private void oscQuery() {
        if (this instanceof LXOscComponent) {
            for (LXParameter p : this.parameters.values()) {
                this.lx.engine.osc.sendParameter(p);
            }
            Collection<LXComponent> children = this.children.values();
            for (LXComponent lXComponent : children) {
                lXComponent.oscQuery();
            }
            for (List list : this.childArrays.values()) {
                for (LXComponent component : list) {
                    if (component == null || children.contains(component)) continue;
                    component.oscQuery();
                }
            }
        }
    }

    public JsonObject toOscQuery() {
        JsonObject obj = new JsonObject();
        obj.addProperty("FULL_PATH", this.getCanonicalPath());
        String description = this.getDescription();
        if (description == null) {
            description = this.getClass().getName();
        }
        obj.addProperty("DESCRIPTION", description);
        JsonObject contents = new JsonObject();
        for (Map.Entry entry : this.parameters.entrySet()) {
            JsonObject parameterOscQuery;
            LXParameter parameter = (LXParameter)entry.getValue();
            if (this.label == parameter && !(this instanceof Renamable) || (parameterOscQuery = this.toOscQuery(parameter, null)) == null) continue;
            contents.add((String)entry.getKey(), (JsonElement)parameterOscQuery);
        }
        for (Map.Entry<Object, Object> entry : this.mutableChildren.entrySet()) {
            LXComponent child = (LXComponent)entry.getValue();
            if (!(child instanceof LXOscComponent)) continue;
            contents.add((String)entry.getKey(), (JsonElement)child.toOscQuery());
        }
        for (Map.Entry<Object, Object> entry : this.childArrays.entrySet()) {
            JsonObject arrObj = new JsonObject();
            arrObj.addProperty("FULL_PATH", this.getCanonicalPath() + "/" + (String)entry.getKey());
            arrObj.addProperty("DESCRIPTION", "Container element");
            JsonObject arrContents = new JsonObject();
            List childArr = (List)entry.getValue();
            for (int i = 0; i < childArr.size(); ++i) {
                LXComponent child = (LXComponent)childArr.get(i);
                if (!(child instanceof LXOscComponent)) continue;
                arrContents.add("" + (i + 1), (JsonElement)child.toOscQuery());
            }
            arrObj.add("CONTENTS", (JsonElement)arrContents);
            contents.add((String)entry.getKey(), (JsonElement)arrObj);
        }
        obj.add("CONTENTS", (JsonElement)contents);
        return obj;
    }

    public JsonObject toOscQuery(LXParameter parameter) {
        return this.toOscQuery(parameter, parameter.getParentParameter());
    }

    public JsonObject toOscQuery(LXParameter parameter, LXParameter parent) {
        if (!(this instanceof LXOscComponent)) {
            return null;
        }
        if (parameter.getParentParameter() != parent) {
            return null;
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("FULL_PATH", parameter.getCanonicalPath());
        obj.addProperty("DESCRIPTION", parameter.getDescription());
        JsonObject range = null;
        if (parameter instanceof AggregateParameter) {
            AggregateParameter aggregate = (AggregateParameter)parameter;
            JsonObject contents = new JsonObject();
            for (Map.Entry<String, LXListenableParameter> parameterEntry : aggregate.subparameters.entrySet()) {
                JsonObject subparameterOscQuery = this.toOscQuery(parameterEntry.getValue(), aggregate);
                if (subparameterOscQuery == null) continue;
                contents.add(parameterEntry.getKey(), (JsonElement)subparameterOscQuery);
            }
            obj.add("CONTENTS", (JsonElement)contents);
        } else if (parameter instanceof BooleanParameter) {
            boolean isOn = ((BooleanParameter)parameter).isOn();
            obj.addProperty("VALUE", Boolean.valueOf(isOn));
            obj.addProperty("TYPE", isOn ? "T" : "F");
        } else if (parameter instanceof StringParameter) {
            obj.addProperty("VALUE", ((StringParameter)parameter).getString());
            obj.addProperty("TYPE", "s");
        } else if (parameter instanceof ColorParameter) {
            obj.addProperty("VALUE", (Number)((ColorParameter)parameter).getBaseColor());
            obj.addProperty("TYPE", "r");
        } else if (parameter instanceof DiscreteParameter) {
            obj.addProperty("VALUE", (Number)((DiscreteParameter)parameter).getBaseValuei());
            obj.addProperty("TYPE", "i");
            range = new JsonObject();
            range.addProperty("MIN", (Number)((DiscreteParameter)parameter).getMinValue());
            range.addProperty("MAX", (Number)((DiscreteParameter)parameter).getMaxValue());
        } else if (parameter instanceof BoundedParameter) {
            BoundedParameter boundedParameter = (BoundedParameter)parameter;
            obj.addProperty("TYPE", "f");
            range = new JsonObject();
            if (boundedParameter.getOscMode() == LXNormalizedParameter.OscMode.ABSOLUTE) {
                range.addProperty("MIN", (Number)Float.valueOf((float)boundedParameter.range.min));
                range.addProperty("MAX", (Number)Float.valueOf((float)boundedParameter.range.max));
                obj.addProperty("VALUE", (Number)Float.valueOf(boundedParameter.getBaseValuef()));
            } else {
                range.addProperty("MIN", (Number)Float.valueOf(0.0f));
                range.addProperty("MAX", (Number)Float.valueOf(1.0f));
                obj.addProperty("VALUE", (Number)Float.valueOf(boundedParameter.getBaseNormalizedf()));
            }
        } else if (parameter instanceof LXNormalizedParameter) {
            obj.addProperty("VALUE", (Number)Float.valueOf(((LXNormalizedParameter)parameter).getNormalizedf()));
            obj.addProperty("TYPE", "f");
            range = new JsonObject();
            range.addProperty("MIN", (Number)Float.valueOf(0.0f));
            range.addProperty("MAX", (Number)Float.valueOf(1.0f));
        } else {
            obj.addProperty("VALUE", (Number)Float.valueOf(parameter.getValuef()));
            obj.addProperty("TYPE", "f");
        }
        if (range != null) {
            JsonArray rangeArr = new JsonArray();
            rangeArr.add(range);
            obj.add("RANGE", (JsonElement)rangeArr);
        }
        return obj;
    }

    final LXPath path(String[] parts, int index) {
        if (index < 0 || index >= parts.length) {
            throw new IllegalArgumentException("Illegal index to path method: " + index + " parts.length=" + parts.length);
        }
        String key = parts[index];
        LXParameter parameter = (LXParameter)this.parameters.get(key);
        if (parameter != null) {
            if (parameter instanceof AggregateParameter && index < parts.length - 1) {
                String subparam = parts[index] + "/" + parts[index + 1];
                return (LXPath)this.parameters.get(subparam);
            }
            return parameter;
        }
        LXComponent child = this.mutableChildren.get(key);
        if (child != null) {
            if (index == parts.length - 1) {
                return child;
            }
            return child.path(parts, index + 1);
        }
        List<? extends LXComponent> array = this.childArrays.get(key);
        if (array != null && ++index < parts.length) {
            try {
                int arrIndex = Integer.parseInt(parts[index]) - 1;
                if (arrIndex >= 0 && arrIndex < array.size()) {
                    child = array.get(arrIndex);
                    if (index == parts.length - 1) {
                        return child;
                    }
                    return child != null ? child.path(parts, index + 1) : null;
                }
            }
            catch (NumberFormatException nfx) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getLabel() {
        return this.label.getString();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected LXComponent setDescription(String description) {
        this.description = description;
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[#" + this.id + "][" + this.getCanonicalPath() + "]";
    }

    public String toString(LXComponent root) {
        return this.getClass().getSimpleName() + "[#" + this.id + "][" + this.getCanonicalPath(root) + "]";
    }

    public void dispose() {
        if (this.lx == null) {
            throw new IllegalStateException("LXComponent cannot dispose(), never had lx reference set: " + this);
        }
        if (this.disposed) {
            throw new IllegalStateException("Cannot dispose LXComponent twice: " + this);
        }
        this.disposed = true;
        if (this != this.lx.engine && this instanceof LXModulationContainer) {
            ((LXModulationContainer)((Object)this)).getModulationEngine().dispose();
        }
        for (LXComponent parent = this.getParent(); parent != null && parent != this.lx.engine; parent = parent.getParent()) {
            if (!(parent instanceof LXModulationContainer)) continue;
            ((LXModulationContainer)((Object)parent)).getModulationEngine().removeModulations(this);
        }
        this.lx.engine.midi.removeMappings(this);
        this.lx.engine.modulation.removeModulations(this);
        this.lx.engine.snapshots.removeSnapshotViews(this);
        for (LXParameter parameter : new ArrayList(this.parameters.values())) {
            this.removeParameter(parameter);
        }
        this.parameters.clear();
        this.parent = null;
        this.lx.componentRegistry.dispose(this);
    }

    @Deprecated
    protected final LXComponent addParameter(LXParameter parameter) {
        return this.addParameter(parameter.getLabel(), parameter);
    }

    protected final LXComponent addParameters(LXParameter.Collection parameters) {
        for (Map.Entry entry : parameters.entrySet()) {
            this.addParameter((String)entry.getKey(), (LXParameter)entry.getValue());
        }
        return this;
    }

    protected final LXComponent addInternalParameter(String path, LXParameter parameter) {
        if (this.internalParameters.containsKey(path)) {
            throw new IllegalStateException("Cannot add duplicate internal parameter at: " + path + ", component: " + this);
        }
        parameter.setComponent(this, INTERNAL_PREFIX + path);
        this.internalParameters.put(path, parameter);
        return this;
    }

    protected LXComponent addParameter(String path, LXParameter parameter) {
        this._checkPath(path, "parameter");
        if (this.parameters.containsValue(parameter)) {
            throw new IllegalStateException("Cannot add parameter twice: " + path + " / " + parameter);
        }
        LXComponent component = parameter.getParent();
        if (component != null) {
            throw new IllegalStateException("Parameter " + path + " / " + parameter + " already owned by " + component);
        }
        parameter.setComponent(this, path);
        this.parameters.put(path, parameter);
        if (parameter instanceof LXListenableParameter) {
            ((LXListenableParameter)parameter).addListener(this);
            if (this instanceof LXOscComponent) {
                ((LXListenableParameter)parameter).addListener(this.oscListener);
            }
        }
        if (parameter instanceof AggregateParameter) {
            for (Map.Entry<String, LXListenableParameter> entry : ((AggregateParameter)parameter).subparameters.entrySet()) {
                this.addParameter(path + "/" + entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    protected LXComponent addLegacyParameter(String legacyPath, LXParameter parameter) {
        if (this.legacyParameters.containsKey(legacyPath)) {
            throw new IllegalStateException("Cannot register duplicate parameter to legacy path: " + legacyPath);
        }
        this.legacyParameters.put(legacyPath, parameter);
        return this;
    }

    protected LXComponent addLegacyInternalParameter(String legacyPath, LXParameter parameter) {
        if (this.legacyInternalParameters.containsKey(legacyPath)) {
            throw new IllegalStateException("Cannot register duplicate parameter to internal legacy path: " + legacyPath);
        }
        this.legacyInternalParameters.put(legacyPath, parameter);
        return this;
    }

    protected LXComponent removeParameter(String path) {
        return this.removeParameter(path, false);
    }

    protected LXComponent removeParameter(String path, boolean removeModulations) {
        LXParameter parameter = (LXParameter)this.parameters.get(path);
        if (parameter == null) {
            throw new IllegalStateException("Cannot remove parameter at non-existent path: " + path + " " + this);
        }
        return this.removeParameter(parameter, removeModulations);
    }

    protected LXComponent removeParameter(LXParameter parameter) {
        return this.removeParameter(parameter, false);
    }

    protected LXComponent removeParameter(LXParameter parameter, boolean disposeModulations) {
        if (parameter.getParent() != this) {
            throw new IllegalStateException("Cannot remove parameter not owned by component");
        }
        if (parameter instanceof LXListenableParameter) {
            ((LXListenableParameter)parameter).removeListener(this);
            if (this instanceof LXOscComponent) {
                ((LXListenableParameter)parameter).removeListener(this.oscListener);
            }
        }
        if (disposeModulations) {
            for (LXComponent parent = this.getParent(); parent != null && parent != this.lx.engine; parent = parent.getParent()) {
                if (!(parent instanceof LXModulationContainer)) continue;
                ((LXModulationContainer)((Object)parent)).getModulationEngine().removeParameterModulations(parameter);
            }
            this.lx.engine.midi.removeParameterMappings(parameter);
            this.lx.engine.modulation.removeParameterModulations(parameter);
            this.lx.engine.snapshots.removeSnapshotParameterViews(parameter);
        }
        this.parameters.remove(parameter.getPath());
        parameter.dispose();
        return this;
    }

    public final Collection<LXParameter> getParameters() {
        return Collections.unmodifiableCollection(this.parameters.values());
    }

    public final boolean hasParameter(String path) {
        return this.parameters.containsKey(path);
    }

    public final LXParameter getParameter(String path) {
        if (path.startsWith(INTERNAL_PREFIX)) {
            return (LXParameter)this.internalParameters.get(path.substring(INTERNAL_PREFIX.length()));
        }
        return (LXParameter)this.parameters.get(path);
    }

    @Override
    public void onParameterChanged(LXParameter parameter) {
    }

    protected LXComponent copyParameters(LXComponent that) {
        if (!that.getClass().isInstance(this)) {
            throw new IllegalArgumentException("Cannot copy parameters from non-assignable class: " + that.getClass() + " -> " + this.getClass());
        }
        for (Map.Entry entry : that.parameters.entrySet()) {
            LXParameter thisParameter = this.getParameter((String)entry.getKey());
            LXParameter thatParameter = (LXParameter)entry.getValue();
            if (thisParameter instanceof StringParameter) {
                ((StringParameter)thisParameter).setValue(((StringParameter)thatParameter).getString());
                continue;
            }
            if (thisParameter instanceof AggregateParameter) continue;
            thisParameter.setValue(thatParameter.getBaseValue());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreset(File file) {
        if (!(this instanceof LXPresetComponent)) {
            throw new IllegalStateException("Cannot load a preset for non-LXPresetComponent: " + this.getClass().getName());
        }
        try (FileReader fr = new FileReader(file);){
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
            this.lx.componentRegistry.projectLoading = true;
            this.lx.componentRegistry.setIdCounter(this.lx.getMaxId(obj, this.lx.componentRegistry.getIdCounter()) + 1);
            this.load(this.lx, obj);
            this.lx.componentRegistry.projectLoading = false;
            this.presetFile.setValue(file.getName());
            LX.log("Preset loaded successfully from " + file.toString());
        }
        catch (IOException iox) {
            LX.error("Could not load preset file: " + iox.getLocalizedMessage());
            this.lx.pushError(iox, "Could not load preset file: " + iox.getLocalizedMessage());
        }
        catch (Exception x) {
            LX.error(x, "Exception in loadPreset: " + x.getLocalizedMessage());
            this.lx.pushError(x, "Exception in loadPreset: " + x.getLocalizedMessage());
        }
        finally {
            this.lx.componentRegistry.projectLoading = false;
        }
    }

    public void savePreset(File file) {
        if (!(this instanceof LXPresetComponent)) {
            throw new IllegalStateException("Cannot save a preset for non-LXPresetComponent: " + this.getClass().getName());
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("version", "1.0.0");
        obj.addProperty("timestamp", (Number)System.currentTimeMillis());
        this.save(this.lx, obj);
        ((LXPresetComponent)((Object)this)).postProcessPreset(this.lx, obj);
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));){
            writer.setIndent("  ");
            new GsonBuilder().create().toJson((JsonElement)obj, writer);
            this.presetFile.setValue(file.getName());
            LX.log("Preset saved successfully to " + file.toString());
        }
        catch (IOException iox) {
            LX.error(iox, "Could not write preset to output file: " + file.toString());
        }
    }

    protected static void loadParameters(LXComponent component, JsonObject obj, Map<String, LXParameter> parameters) {
        for (String path : parameters.keySet()) {
            LXParameter parameter = parameters.get(path);
            if (parameter == component.label && !(component instanceof Renamable) || parameter instanceof AggregateParameter) continue;
            LXSerializable.Utils.loadParameter(parameter, obj, path);
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        obj.addProperty(KEY_ID, (Number)this.id);
        obj.addProperty(KEY_CLASS, this.getClass().getName());
        obj.add(KEY_INTERNAL, (JsonElement)LXSerializable.Utils.saveParameters(this.internalParameters));
        obj.add(KEY_PARAMETERS, (JsonElement)LXSerializable.Utils.saveParameters(this.parameters));
        obj.add(KEY_CHILDREN, (JsonElement)LXSerializable.Utils.toObject(lx, this.mutableChildren));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        JsonObject parametersObj;
        if (obj.has(KEY_ID)) {
            lx.componentRegistry.registerId(this, obj.get(KEY_ID).getAsInt());
            this.lx = lx;
        }
        if (obj.has(KEY_INTERNAL)) {
            parametersObj = obj.getAsJsonObject(KEY_INTERNAL);
            LXComponent.loadParameters(this, parametersObj, this.legacyInternalParameters);
            LXComponent.loadParameters(this, parametersObj, this.internalParameters);
        }
        if (obj.has(KEY_PARAMETERS)) {
            parametersObj = obj.getAsJsonObject(KEY_PARAMETERS);
            LXComponent.loadParameters(this, parametersObj, this.legacyParameters);
            LXComponent.loadParameters(this, parametersObj, this.parameters);
        }
        JsonObject children = obj.has(KEY_CHILDREN) ? obj.getAsJsonObject(KEY_CHILDREN) : new JsonObject();
        for (String path : this.mutableChildren.keySet()) {
            LXComponent child = this.mutableChildren.get(path);
            if (children.has(path)) {
                child.load(lx, children.getAsJsonObject(path));
                continue;
            }
            LXSerializable.Utils.resetObject(lx, child);
        }
    }

    static class Registry {
        private int idCounter = 2;
        boolean projectLoading = false;
        boolean modelImporting = false;
        boolean scheduleLoading = false;
        private final Map<Integer, LXComponent> components = new HashMap<Integer, LXComponent>();
        private final Map<Integer, LXComponent> projectIdMap = new HashMap<Integer, LXComponent>();

        Registry() {
        }

        LXComponent getComponent(int componentId) {
            return this.components.get(componentId);
        }

        LXComponent getProjectComponent(int projectId) {
            LXComponent component = this.projectIdMap.get(projectId);
            if (component == null) {
                component = this.components.get(projectId);
            }
            return component;
        }

        void resetProject() {
            this.projectIdMap.clear();
        }

        int getIdCounter() {
            return this.idCounter;
        }

        void setIdCounter(int idCounter) {
            this.idCounter = idCounter;
        }

        private void register(LXComponent component) {
            if (component.id == -1) {
                component.id = this.idCounter++;
            } else if (component.id <= 0) {
                throw new IllegalStateException("Component has illegal non-positive ID: " + component.id + " " + component);
            }
            if (this.components.containsKey(component.id)) {
                throw new IllegalStateException("Component id " + component.id + " already registered: " + component + " to " + this.components.get(component.id));
            }
            this.components.put(component.id, component);
        }

        private void registerId(LXComponent component, int id) {
            if (id <= 0) {
                throw new IllegalArgumentException("Cannot registerId to non-positive value: " + id + " " + component);
            }
            if (component.id == id) {
                return;
            }
            if (this.components.containsKey(id)) {
                if (this.projectLoading) {
                    this.projectIdMap.put(id, component);
                } else if (!this.modelImporting && !this.scheduleLoading) {
                    throw new IllegalStateException("ID collision outside of project/schedule load or model import: " + component + " trying to clobber " + this.components.get(id));
                }
            } else {
                if (component.id > 0) {
                    this.components.remove(component.id);
                }
                component.id = id;
                this.components.put(id, component);
                if (id >= this.idCounter) {
                    this.idCounter = id + 1;
                }
            }
        }

        private void dispose(LXComponent component) {
            this.components.remove(component.id);
        }
    }

    public static interface Renamable {
    }

    public static interface Placeholder {
        public String getPlaceholderTypeName();

        public String getPlaceholderClassName();

        public LX.InstantiationException getInstantiationException();
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Hidden {
        public String value() default "";
    }
}

