/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import heronarts.lx.LX;
import heronarts.lx.LXBuffer;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.LXLayer;
import heronarts.lx.LXLoopTask;
import heronarts.lx.LXModelComponent;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class LXLayeredComponent
extends LXModelComponent
implements LXLoopTask {
    private LXBuffer buffer = null;
    protected int[] colors = null;
    private final List<LXLayer> mutableLayers = new ArrayList<LXLayer>();
    public final List<LXLayer> layers = Collections.unmodifiableList(this.mutableLayers);
    protected final LXPalette palette;
    private LXLayer loopingLayer = null;

    protected LXLayeredComponent(LX lx) {
        this(lx, null, (LXBuffer)null);
    }

    protected LXLayeredComponent(LX lx, String label) {
        this(lx, label, (LXBuffer)null);
    }

    protected LXLayeredComponent(LX lx, LXDeviceComponent component) {
        this(lx, null, component.getBuffer());
    }

    protected LXLayeredComponent(LX lx, LXBuffer buffer) {
        this(lx, null, buffer);
    }

    protected LXLayeredComponent(LX lx, String label, LXBuffer buffer) {
        super(lx, label);
        this.palette = lx.engine.palette;
        if (buffer != null) {
            this.buffer = buffer;
            this.colors = buffer.getArray();
        }
        this.addArray("layer", this.layers);
    }

    protected LXBuffer getBuffer() {
        return this.buffer;
    }

    public int[] getColors() {
        return this.getBuffer().getArray();
    }

    protected LXLayeredComponent setBuffer(LXDeviceComponent component) {
        return this.setBuffer(component.getBuffer());
    }

    public LXLayeredComponent setBuffer(LXBuffer buffer) {
        this.buffer = buffer;
        this.colors = buffer.getArray();
        return this;
    }

    @Override
    public void loop(double deltaMs) {
        long loopStart = System.nanoTime();
        this.colors = this.buffer.getArray();
        super.loop(deltaMs);
        this.onLoop(deltaMs);
        try {
            Iterator<LXLayer> iterator = this.mutableLayers.iterator();
            while (iterator.hasNext()) {
                LXLayer layer;
                this.loopingLayer = layer = iterator.next();
                layer.setBuffer(this.buffer);
                layer.setModel(this.model);
                layer.loop(deltaMs);
            }
            this.loopingLayer = null;
        }
        catch (Throwable x) {
            this.loopingLayer = null;
            throw x;
        }
        this.afterLayers(deltaMs);
        this.profiler.loopNanos = System.nanoTime() - loopStart;
    }

    protected void onLoop(double deltaMs) {
    }

    protected void afterLayers(double deltaMs) {
    }

    private void checkForReentrancy(LXLayer target, String operation) {
        if (this.loopingLayer != null) {
            throw new IllegalStateException("LXLayeredComponent may not modify layers while looping, component: " + this.toString() + " looping: " + this.loopingLayer.toString(this) + " " + operation + ": " + (target != null ? target.toString() : "null"));
        }
    }

    private void _reindexLayers() {
        int i = 0;
        for (LXLayer layer : this.layers) {
            layer.setIndex(i++);
        }
    }

    protected final LXLayer addLayer(LXLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("Cannot add null layer");
        }
        this.checkForReentrancy(layer, "add");
        if (this.mutableLayers.contains(layer)) {
            throw new IllegalStateException("Cannot add layer twice: " + this + " " + layer);
        }
        layer.setParent(this);
        this.mutableLayers.add(layer);
        this._reindexLayers();
        return layer;
    }

    protected final LXLayer removeLayer(LXLayer layer) {
        this.checkForReentrancy(layer, "remove");
        this.mutableLayers.remove(layer);
        this._reindexLayers();
        layer.dispose();
        return layer;
    }

    public final List<LXLayer> getLayers() {
        return this.layers;
    }

    @Override
    public void dispose() {
        this.checkForReentrancy(null, "dispose");
        for (LXLayer layer : this.mutableLayers) {
            layer.dispose();
        }
        this.mutableLayers.clear();
        super.dispose();
    }

    protected int getColor(int i) {
        return this.colors[i];
    }

    protected int getColor(LXPoint p) {
        return this.colors[p.index];
    }

    protected final LXLayeredComponent setColor(int i, int c) {
        this.colors[i] = c;
        return this;
    }

    protected final LXLayeredComponent setColor(LXPoint p, int c) {
        this.colors[p.index] = c;
        return this;
    }

    protected final LXLayeredComponent blendColor(int i, int c, LXColor.Blend blendMode) {
        this.colors[i] = LXColor.blend(this.colors[i], c, blendMode);
        return this;
    }

    protected final LXLayeredComponent blendColor(LXModel model, int c, LXColor.Blend blendMode) {
        for (LXPoint p : model.points) {
            this.colors[p.index] = LXColor.blend(this.colors[p.index], c, blendMode);
        }
        return this;
    }

    protected final LXLayeredComponent addColor(int i, int c) {
        this.colors[i] = LXColor.add(this.colors[i], c);
        return this;
    }

    protected final LXLayeredComponent addColor(LXModel model, int c) {
        for (LXPoint p : model.points) {
            this.colors[p.index] = LXColor.add(this.colors[p.index], c);
        }
        return this;
    }

    protected final LXLayeredComponent subtractColor(int i, int c) {
        this.colors[i] = LXColor.subtract(this.colors[i], c);
        return this;
    }

    protected final LXLayeredComponent setColors(int c) {
        for (LXPoint p : this.model.points) {
            this.colors[p.index] = c;
        }
        return this;
    }

    protected final LXLayeredComponent setColor(LXModel model, int c) {
        for (LXPoint p : model.points) {
            this.colors[p.index] = c;
        }
        return this;
    }

    protected final LXLayeredComponent clearColors() {
        return this.setColors(0);
    }
}

