/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXEngine;
import heronarts.lx.parameter.LXParameter;

public interface LXPath {
    public static final String ROOT = "lx";
    public static final String ROOT_PREFIX = "/lx/";
    public static final String ROOT_SLASH = "lx/";

    public String getPath();

    public String getLabel();

    public String getDescription();

    public LXComponent getParent();

    default public boolean isDescendant(LXComponent root) {
        for (LXComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != root) continue;
            return true;
        }
        return false;
    }

    default public String getCanonicalPath(LXComponent root) {
        String pathStr = "/" + this.getPath();
        for (LXComponent parent = this.getParent(); parent != null && parent != root; parent = parent.getParent()) {
            pathStr = "/" + parent.getPath() + pathStr;
        }
        return pathStr;
    }

    default public String getCanonicalPath() {
        return this.getCanonicalPath(null);
    }

    default public String getCanonicalLabel() {
        return this.getCanonicalLabel(null);
    }

    default public String getCanonicalLabel(LXComponent root) {
        String label = this.getLabel();
        for (LXComponent parent = this.getParent(); parent != null && parent != root && !(parent instanceof LXEngine); parent = parent.getParent()) {
            label = parent.getLabel() + " \u2022 " + label;
        }
        return label;
    }

    public static LXPath get(LX lx, String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.equals(ROOT)) {
            return lx.engine;
        }
        if (path.startsWith(ROOT_SLASH)) {
            path = path.substring(3);
            String[] parts = path.split("/");
            return lx.engine.path(parts, 0);
        }
        return null;
    }

    public static LXComponent getComponent(LX lx, String path) {
        LXPath component = LXPath.get(lx, path);
        if (component instanceof LXComponent) {
            return (LXComponent)component;
        }
        return null;
    }

    public static LXParameter getParameter(LX lx, String path) {
        LXPath parameter = LXPath.get(lx, path);
        if (parameter instanceof LXParameter) {
            return (LXParameter)parameter;
        }
        return null;
    }

    public static LXPath get(LXComponent root, String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return root.path(path.split("/"), 0);
    }

    public static LXComponent getComponent(LXComponent root, String path) {
        LXPath component = LXPath.get(root, path);
        if (component instanceof LXComponent) {
            return (LXComponent)component;
        }
        return null;
    }

    public static LXParameter getParameter(LXComponent root, String path) {
        LXPath parameter = LXPath.get(root, path);
        if (parameter instanceof LXParameter) {
            return (LXParameter)parameter;
        }
        return null;
    }
}

