/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import heronarts.lx.LX;
import heronarts.lx.LXClassLoader;
import heronarts.lx.LXPlugin;
import heronarts.lx.LXSerializable;
import heronarts.lx.audio.BandGate;
import heronarts.lx.audio.SoundObject;
import heronarts.lx.blend.AddBlend;
import heronarts.lx.blend.BurnBlend;
import heronarts.lx.blend.DarkestBlend;
import heronarts.lx.blend.DifferenceBlend;
import heronarts.lx.blend.DissolveBlend;
import heronarts.lx.blend.DodgeBlend;
import heronarts.lx.blend.HighlightBlend;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.blend.LightestBlend;
import heronarts.lx.blend.MultiplyBlend;
import heronarts.lx.blend.NormalBlend;
import heronarts.lx.blend.SpotlightBlend;
import heronarts.lx.blend.SubtractBlend;
import heronarts.lx.dmx.DmxColorModulator;
import heronarts.lx.dmx.DmxModulator;
import heronarts.lx.dmx.DmxPattern;
import heronarts.lx.effect.BlurEffect;
import heronarts.lx.effect.DynamicsEffect;
import heronarts.lx.effect.HueSaturationEffect;
import heronarts.lx.effect.InvertEffect;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.effect.SparkleEffect;
import heronarts.lx.effect.StrobeEffect;
import heronarts.lx.effect.audio.SoundObjectEffect;
import heronarts.lx.effect.color.ColorMaskEffect;
import heronarts.lx.effect.color.ColorizeEffect;
import heronarts.lx.effect.midi.GateEffect;
import heronarts.lx.modulator.BooleanLogic;
import heronarts.lx.modulator.ComparatorModulator;
import heronarts.lx.modulator.Damper;
import heronarts.lx.modulator.Interval;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.MacroKnobs;
import heronarts.lx.modulator.MacroSwitches;
import heronarts.lx.modulator.MacroTriggers;
import heronarts.lx.modulator.MidiNoteTrigger;
import heronarts.lx.modulator.MultiModeEnvelope;
import heronarts.lx.modulator.MultiStageEnvelope;
import heronarts.lx.modulator.MultiTrig;
import heronarts.lx.modulator.NoiseModulator;
import heronarts.lx.modulator.OperatorModulator;
import heronarts.lx.modulator.Randomizer;
import heronarts.lx.modulator.Scaler;
import heronarts.lx.modulator.Smoother;
import heronarts.lx.modulator.Spring;
import heronarts.lx.modulator.StepSequencer;
import heronarts.lx.modulator.Timer;
import heronarts.lx.modulator.VariableLFO;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.pattern.audio.SoundObjectPattern;
import heronarts.lx.pattern.color.GradientPattern;
import heronarts.lx.pattern.color.SolidPattern;
import heronarts.lx.pattern.form.PlanesPattern;
import heronarts.lx.pattern.strip.ChasePattern;
import heronarts.lx.pattern.test.TestPattern;
import heronarts.lx.pattern.texture.NoisePattern;
import heronarts.lx.pattern.texture.SparklePattern;
import heronarts.lx.structure.ArcFixture;
import heronarts.lx.structure.GridFixture;
import heronarts.lx.structure.LXFixture;
import heronarts.lx.structure.PointFixture;
import heronarts.lx.structure.SpiralFixture;
import heronarts.lx.structure.StripFixture;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class LXRegistry
implements LXSerializable {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private static final List<Class<? extends LXPattern>> DEFAULT_PATTERNS = new ArrayList<Class<? extends LXPattern>>();
    private static final List<Class<? extends LXEffect>> DEFAULT_EFFECTS;
    private static final List<Class<? extends LXModulator>> DEFAULT_MODULATORS;
    private static final List<Class<? extends LXBlend>> DEFAULT_CHANNEL_BLENDS;
    private static final List<Class<? extends LXBlend>> DEFAULT_TRANSITION_BLENDS;
    private static final List<Class<? extends LXBlend>> DEFAULT_CROSSFADER_BLENDS;
    private static final List<Class<? extends LXFixture>> DEFAULT_FIXTURES;
    private final List<Class<? extends LXPattern>> mutablePatterns = new ArrayList<Class<? extends LXPattern>>(DEFAULT_PATTERNS);
    public final List<Class<? extends LXPattern>> patterns = Collections.unmodifiableList(this.mutablePatterns);
    private final List<Class<? extends LXEffect>> mutableEffects = new ArrayList<Class<? extends LXEffect>>(DEFAULT_EFFECTS);
    public final List<Class<? extends LXEffect>> effects = Collections.unmodifiableList(this.mutableEffects);
    private final List<Class<? extends LXModulator>> mutableModulators = new ArrayList<Class<? extends LXModulator>>(DEFAULT_MODULATORS);
    public final List<Class<? extends LXModulator>> modulators = Collections.unmodifiableList(this.mutableModulators);
    private final List<Class<? extends LXBlend>> mutableChannelBlends = new ArrayList<Class<? extends LXBlend>>(DEFAULT_CHANNEL_BLENDS);
    public final List<Class<? extends LXBlend>> channelBlends = Collections.unmodifiableList(this.mutableChannelBlends);
    private final List<Class<? extends LXBlend>> mutableTransitionBlends = new ArrayList<Class<? extends LXBlend>>(DEFAULT_TRANSITION_BLENDS);
    public final List<Class<? extends LXBlend>> transitionBlends = Collections.unmodifiableList(this.mutableTransitionBlends);
    private final List<Class<? extends LXBlend>> mutableCrossfaderBlends = new ArrayList<Class<? extends LXBlend>>(DEFAULT_CROSSFADER_BLENDS);
    public final List<Class<? extends LXBlend>> crossfaderBlends = Collections.unmodifiableList(this.mutableCrossfaderBlends);
    private final List<Class<? extends LXFixture>> mutableFixtures = new ArrayList<Class<? extends LXFixture>>(DEFAULT_FIXTURES);
    public final List<Class<? extends LXFixture>> fixtures = Collections.unmodifiableList(this.mutableFixtures);
    private final List<JsonFixture> mutableJsonFixtures = new ArrayList<JsonFixture>();
    public final List<JsonFixture> jsonFixtures = Collections.unmodifiableList(this.mutableJsonFixtures);
    private final List<JsonFixture.Error> mutableJsonFixtureErrors = new ArrayList<JsonFixture.Error>();
    public final List<JsonFixture.Error> jsonFixtureErrors = Collections.unmodifiableList(this.mutableJsonFixtureErrors);
    private final List<LXClassLoader.Package> mutablePackages = new ArrayList<LXClassLoader.Package>();
    public final List<LXClassLoader.Package> packages = Collections.unmodifiableList(this.mutablePackages);
    private final List<Plugin> mutablePlugins = new ArrayList<Plugin>();
    public final List<Plugin> plugins = Collections.unmodifiableList(this.mutablePlugins);
    public final LX lx;
    protected LXClassLoader classLoader;
    private boolean contentReloading = false;
    private JsonArray pluginState = new JsonArray();
    private static final String KEY_PLUGINS = "plugins";

    public LXRegistry addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXRegistry.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add same LXRegistry.Listener twice: " + listener);
        }
        this.listeners.add(listener);
        return this;
    }

    public LXRegistry removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Trying to remove non-registered LXRegistry.Listener: " + listener);
        }
        this.listeners.remove(listener);
        return this;
    }

    public LXRegistry(LX lx) {
        this.lx = lx;
        this.classLoader = new LXClassLoader(lx);
    }

    protected void initialize() {
        this.contentReloading = true;
        this.classLoader.load();
        this.loadClasspathPlugins();
        this.addJsonFixtures(this.lx.getMediaFolder(LX.Media.FIXTURES, false));
        this.contentReloading = false;
    }

    private void loadClasspathPlugins() {
        for (String className : this.lx.flags.classpathPlugins) {
            try {
                Class<?> clz = Class.forName(className);
                if (LXPlugin.class.isAssignableFrom(clz)) {
                    this.addPlugin(clz.asSubclass(LXPlugin.class));
                    continue;
                }
                LX.error("Classpath plugin is not an LXPlugin subclass: " + className);
            }
            catch (ClassNotFoundException cnfx) {
                LX.error(cnfx, "Classpath plugin class does not exist: " + className);
            }
        }
    }

    public void checkRegistration() {
        if (!this.contentReloading && this.lx.engine.hasStarted) {
            throw new IllegalStateException("May not register components outside of initialize() callback");
        }
    }

    public void reloadContent() {
        LX.log("Reloading custom content folders");
        this.classLoader.dispose();
        this.mutablePackages.clear();
        this.mutablePlugins.clear();
        this.contentReloading = true;
        this.classLoader = new LXClassLoader(this.lx);
        this.classLoader.load();
        this.loadClasspathPlugins();
        this.mutableJsonFixtures.clear();
        this.mutableJsonFixtureErrors.clear();
        this.addJsonFixtures(this.lx.getMediaFolder(LX.Media.FIXTURES, false));
        this.contentReloading = false;
        for (Listener listener : this.listeners) {
            listener.contentChanged(this.lx);
        }
        this.lx.pushStatusMessage("Package content reloaded.");
    }

    void addPackage(LXClassLoader.Package pack) {
        this.mutablePackages.add(pack);
    }

    public boolean installPackage(File file) {
        return this.installPackage(file, false);
    }

    public boolean installPackage(File file, boolean overwrite) {
        if (!file.exists() || file.isDirectory()) {
            this.lx.pushError(null, "Package file does not exist or is a directory: " + file);
            return false;
        }
        File destinationFile = this.lx.getMediaFile(LX.Media.PACKAGES, file.getName(), true);
        if (destinationFile.exists() && !overwrite) {
            this.lx.pushError(null, "Package file already exists: " + destinationFile.getName());
            return false;
        }
        try {
            Files.copy(file.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.installPackageMedia(destinationFile);
            this.reloadContent();
        }
        catch (Throwable x) {
            this.lx.pushError(x, "Error installing package file " + file.getName() + ": " + x.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private void installPackageMedia(File file) {
        try (JarFile jarFile = new JarFile(file);){
            JarEntry packageEntry = jarFile.getJarEntry("lx.package");
            if (packageEntry == null) {
                this.lx.pushError("Package is missing lx.package entry, cannot install media: " + jarFile.getName());
                return;
            }
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(jarFile.getInputStream(packageEntry)), JsonObject.class);
            String packageDir = obj.get("mediaDir").getAsString();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String fileName = entry.getName();
                if (fileName.startsWith("fixtures/") && fileName.endsWith(".lxf")) {
                    this.copyPackageMedia(packageDir, LX.Media.FIXTURES, jarFile, entry);
                    continue;
                }
                if (fileName.startsWith("models/") && fileName.endsWith(".lxm")) {
                    this.copyPackageMedia(packageDir, LX.Media.MODELS, jarFile, entry);
                    continue;
                }
                if (!fileName.startsWith("projects/") || !fileName.endsWith(".lxp")) continue;
                this.copyPackageMedia(packageDir, LX.Media.PROJECTS, jarFile, entry);
            }
        }
        catch (Throwable throwable) {
            LX.error(throwable, "Error loading JAR file " + file + " - " + throwable.getLocalizedMessage());
        }
    }

    private void copyPackageMedia(String packageDirName, LX.Media media, JarFile jarFile, JarEntry entry) throws IOException {
        String entryName = entry.getName();
        entryName = entryName.substring(entryName.indexOf(47) + 1);
        File packageDir = this.lx.getMediaFile(media, packageDirName, true);
        int lastSlash = entryName.lastIndexOf(47);
        if (lastSlash >= 0) {
            String subdir = entryName.substring(0, lastSlash);
            packageDir = new File(packageDir, subdir.replaceAll("/", File.separator));
            entryName = entryName.substring(lastSlash + 1);
        }
        packageDir.mkdirs();
        Files.copy(jarFile.getInputStream(entry), new File(packageDir, entryName).toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void uninstallPackage(LXClassLoader.Package pack) {
        File destinationFile = this.lx.getMediaFile(LX.Media.DELETED, pack.jarFile.getName(), true);
        try {
            if (destinationFile.exists()) {
                String suffix = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss").format(Calendar.getInstance().getTime());
                destinationFile = this.lx.getMediaFile(LX.Media.DELETED, pack.jarFile.getName() + "-" + suffix, true);
            }
            Files.move(pack.jarFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.reloadContent();
        }
        catch (IOException iox) {
            this.lx.pushError(iox, "Could not remove package file " + pack.jarFile.getName());
        }
    }

    protected void addClass(Class<?> clz) {
        if (LXPattern.class.isAssignableFrom(clz)) {
            this.addPattern(clz.asSubclass(LXPattern.class));
        }
        if (LXEffect.class.isAssignableFrom(clz)) {
            this.addEffect(clz.asSubclass(LXEffect.class));
        }
        if (LXModulator.class.isAssignableFrom(clz)) {
            this.addModulator(clz.asSubclass(LXModulator.class));
        }
        if (LXFixture.class.isAssignableFrom(clz)) {
            this.addFixture(clz.asSubclass(LXFixture.class));
        }
        if (LXPlugin.class.isAssignableFrom(clz)) {
            this.addPlugin(clz.asSubclass(LXPlugin.class));
        }
    }

    protected void removeClass(Class<?> clz) {
        if (LXPattern.class.isAssignableFrom(clz)) {
            this.removePattern(clz.asSubclass(LXPattern.class));
        }
        if (LXEffect.class.isAssignableFrom(clz)) {
            this.removeEffect(clz.asSubclass(LXEffect.class));
        }
        if (LXModulator.class.isAssignableFrom(clz)) {
            this.removeModulator(clz.asSubclass(LXModulator.class));
        }
        if (LXFixture.class.isAssignableFrom(clz)) {
            this.removeFixture(clz.asSubclass(LXFixture.class));
        }
    }

    public LXRegistry addPattern(Class<? extends LXPattern> pattern) {
        Objects.requireNonNull(pattern, "May not add null LXRegistry.addPattern");
        this.checkRegistration();
        if (this.mutablePatterns.contains(pattern)) {
            throw new IllegalStateException("Attemping to register pattern twice: " + pattern);
        }
        this.mutablePatterns.add(pattern);
        return this;
    }

    public LXRegistry addPatterns(Class<? extends LXPattern>[] patterns) {
        this.checkRegistration();
        for (Class<? extends LXPattern> pattern : patterns) {
            this.addPattern(pattern);
        }
        return this;
    }

    public LXRegistry removePattern(Class<? extends LXPattern> pattern) {
        if (!this.mutablePatterns.contains(pattern)) {
            throw new IllegalStateException("Attemping to unregister pattern that does not exist: " + pattern);
        }
        this.mutablePatterns.remove(pattern);
        return this;
    }

    public LXRegistry removePatterns(List<Class<? extends LXPattern>> patterns) {
        for (Class<? extends LXPattern> pattern : patterns) {
            if (!this.mutablePatterns.contains(pattern)) {
                throw new IllegalStateException("Attemping to unregister pattern that does not exist: " + pattern);
            }
            this.mutablePatterns.remove(pattern);
        }
        return this;
    }

    public LXRegistry addEffect(Class<? extends LXEffect> effect) {
        Objects.requireNonNull(effect, "May not add null LXRegistry.addEffect");
        this.checkRegistration();
        if (this.mutableEffects.contains(effect)) {
            throw new IllegalStateException("Attemping to register effect twice: " + effect);
        }
        this.mutableEffects.add(effect);
        return this;
    }

    public LXRegistry addEffects(Class<? extends LXEffect>[] effects) {
        this.checkRegistration();
        for (Class<? extends LXEffect> effect : effects) {
            this.addEffect(effect);
        }
        return this;
    }

    public LXRegistry removeEffect(Class<? extends LXEffect> effect) {
        if (!this.mutableEffects.contains(effect)) {
            throw new IllegalStateException("Attemping to unregister effect that does not exist: " + effect);
        }
        this.mutableEffects.remove(effect);
        return this;
    }

    public LXRegistry removeEffects(List<Class<? extends LXEffect>> effects) {
        for (Class<? extends LXEffect> effect : effects) {
            if (!this.mutableEffects.contains(effect)) {
                throw new IllegalStateException("Attemping to unregister effect that does not exist: " + effect);
            }
            this.mutableEffects.remove(effect);
        }
        return this;
    }

    public LXRegistry addModulator(Class<? extends LXModulator> modulator) {
        Objects.requireNonNull(modulator, "May not add null LXRegistry.addModulator");
        this.checkRegistration();
        if (this.mutableModulators.contains(modulator)) {
            throw new IllegalStateException("Attemping to register modulator twice: " + modulator);
        }
        this.mutableModulators.add(modulator);
        return this;
    }

    @Deprecated
    public LXRegistry addModulataors(Class<? extends LXModulator>[] modulators) {
        return this.addModulators(modulators);
    }

    public LXRegistry addModulators(Class<? extends LXModulator>[] modulators) {
        this.checkRegistration();
        for (Class<? extends LXModulator> modulator : modulators) {
            this.addModulator(modulator);
        }
        return this;
    }

    public LXRegistry removeModulator(Class<? extends LXModulator> modulator) {
        if (!this.mutableModulators.contains(modulator)) {
            throw new IllegalStateException("Attemping to unregister modulator that does not exist: " + modulator);
        }
        this.mutableModulators.remove(modulator);
        return this;
    }

    public LXRegistry removeModulators(List<Class<? extends LXModulator>> modulators) {
        for (Class<? extends LXModulator> modulator : modulators) {
            if (!this.mutableModulators.contains(modulator)) {
                throw new IllegalStateException("Attemping to unregister modulator that does not exist: " + modulator);
            }
            this.mutableModulators.remove(modulator);
        }
        return this;
    }

    public LXRegistry addFixture(Class<? extends LXFixture> fixture) {
        Objects.requireNonNull(fixture, "May not add null LXRegistry.addFixture");
        this.checkRegistration();
        if (this.mutableFixtures.contains(fixture)) {
            throw new IllegalStateException("Cannot double-register fixture: " + fixture);
        }
        this.mutableFixtures.add(fixture);
        return this;
    }

    public LXRegistry addFixtures(List<Class<? extends LXFixture>> fixtures) {
        this.checkRegistration();
        for (Class<? extends LXFixture> fixture : fixtures) {
            this.addFixture(fixture);
        }
        return this;
    }

    public LXRegistry removeFixture(Class<? extends LXFixture> fixture) {
        if (!this.mutableFixtures.contains(fixture)) {
            throw new IllegalStateException("Attemping to unregister fixture that does not exist: " + fixture);
        }
        this.mutableFixtures.remove(fixture);
        return this;
    }

    public LXRegistry removeFixtures(List<Class<? extends LXFixture>> fixtures) {
        for (Class<? extends LXFixture> fixture : fixtures) {
            if (!this.mutableFixtures.contains(fixture)) {
                throw new IllegalStateException("Attemping to unregister fixture that does not exist: " + fixture);
            }
            this.mutableFixtures.remove(fixture);
        }
        return this;
    }

    private LXRegistry addJsonFixture(File fixture, String prefix) {
        Objects.requireNonNull(fixture, "May not add null LXRegistry.addJsonFixture");
        this.checkRegistration();
        this.mutableJsonFixtures.add(new JsonFixture(fixture, prefix));
        return this;
    }

    private void addJsonFixtures(File fixtureDir) {
        this.addJsonFixtures(fixtureDir, "");
    }

    private void addJsonFixtures(File fixtureDir, String prefix) {
        if (fixtureDir.exists() && fixtureDir.isDirectory()) {
            for (File fixture : fixtureDir.listFiles()) {
                if (fixture.isDirectory()) {
                    this.addJsonFixtures(fixture, prefix + fixture.getName() + "/");
                    continue;
                }
                if (!fixture.getName().endsWith(".lxf")) continue;
                this.addJsonFixture(fixture, prefix);
            }
        }
    }

    public LXRegistry addBlend(Class<? extends LXBlend> blend) {
        Objects.requireNonNull(blend, "May not add null LXRegistry.addBlend");
        this.checkRegistration();
        this.addChannelBlend(blend);
        this.addTransitionBlend(blend);
        this.addCrossfaderBlend(blend);
        return this;
    }

    public LXRegistry addBlends(Class<LXBlend>[] blends) {
        this.checkRegistration();
        this.addChannelBlends(blends);
        this.addTransitionBlends(blends);
        this.addCrossfaderBlends(blends);
        return this;
    }

    public LXRegistry addChannelBlend(Class<? extends LXBlend> blend) {
        Objects.requireNonNull(blend, "May not add null LXRegistry.addChannelBlend");
        this.checkRegistration();
        if (this.mutableChannelBlends.contains(blend)) {
            throw new IllegalStateException("Attemping to register channel blend twice: " + blend);
        }
        this.mutableChannelBlends.add(blend);
        for (Listener listener : this.listeners) {
            listener.channelBlendsChanged(this.lx);
        }
        return this;
    }

    public LXRegistry addChannelBlends(Class<LXBlend>[] blends) {
        this.checkRegistration();
        for (Class<LXBlend> blend : blends) {
            if (this.mutableChannelBlends.contains(blend)) {
                throw new IllegalStateException("Attemping to register channel blend twice: " + blend);
            }
            this.mutableChannelBlends.add(blend);
        }
        for (Listener listener : this.listeners) {
            listener.channelBlendsChanged(this.lx);
        }
        return this;
    }

    public LXRegistry addTransitionBlend(Class<? extends LXBlend> blend) {
        Objects.requireNonNull(blend, "May not add null LXRegistry.addTransitionBlend");
        this.checkRegistration();
        if (this.mutableTransitionBlends.contains(blend)) {
            throw new IllegalStateException("Attemping to register transition blend twice: " + blend);
        }
        this.mutableTransitionBlends.add(blend);
        for (Listener listener : this.listeners) {
            listener.transitionBlendsChanged(this.lx);
        }
        return this;
    }

    public LXRegistry addTransitionBlends(Class<LXBlend>[] blends) {
        this.checkRegistration();
        for (Class<LXBlend> blend : blends) {
            if (this.mutableTransitionBlends.contains(blend)) {
                throw new IllegalStateException("Attemping to register transition blend twice: " + blend);
            }
            this.mutableTransitionBlends.add(blend);
        }
        for (Listener listener : this.listeners) {
            listener.transitionBlendsChanged(this.lx);
        }
        return this;
    }

    public LXRegistry addCrossfaderBlend(Class<? extends LXBlend> blend) {
        Objects.requireNonNull(blend, "May not add null LXRegistry.addCrossfaderBlend");
        this.checkRegistration();
        if (this.mutableCrossfaderBlends.contains(blend)) {
            throw new IllegalStateException("Attemping to register crossfader blend twice: " + blend);
        }
        this.mutableCrossfaderBlends.add(blend);
        for (Listener listener : this.listeners) {
            listener.crossfaderBlendsChanged(this.lx);
        }
        return this;
    }

    public LXRegistry addCrossfaderBlends(Class<LXBlend>[] blends) {
        this.checkRegistration();
        for (Class<LXBlend> blend : blends) {
            if (this.mutableCrossfaderBlends.contains(blend)) {
                throw new IllegalStateException("Attemping to register crossfader blend twice: " + blend);
            }
            this.mutableCrossfaderBlends.add(blend);
        }
        for (Listener listener : this.listeners) {
            listener.crossfaderBlendsChanged(this.lx);
        }
        return this;
    }

    protected void addPlugin(Class<? extends LXPlugin> plugin) {
        Objects.requireNonNull(plugin, "May not add null LXRegistry.addPlugin");
        this.mutablePlugins.add(new Plugin(plugin));
    }

    protected void initializePlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.initialize(this.lx);
        }
    }

    protected void disposePlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.dispose();
        }
    }

    private Plugin findPlugin(String clazz) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.clazz.getName().equals(clazz)) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public void save(LX lx, JsonObject object) {
        this.pluginState = LXSerializable.Utils.toArray(lx, this.plugins);
        object.add(KEY_PLUGINS, (JsonElement)this.pluginState);
    }

    @Override
    public void load(LX lx, JsonObject object) {
        if (object.has(KEY_PLUGINS)) {
            this.pluginState = object.get(KEY_PLUGINS).getAsJsonArray().deepCopy();
            for (JsonElement pluginElement : this.pluginState) {
                JsonObject pluginObj = pluginElement.getAsJsonObject();
                Plugin plugin = this.findPlugin(pluginObj.get("class").getAsString());
                if (plugin == null) continue;
                plugin.load(lx, pluginObj);
            }
        } else {
            this.pluginState = new JsonArray();
        }
    }

    static {
        DEFAULT_PATTERNS.add(DmxPattern.class);
        DEFAULT_PATTERNS.add(SoundObjectPattern.class);
        DEFAULT_PATTERNS.add(GradientPattern.class);
        DEFAULT_PATTERNS.add(SolidPattern.class);
        DEFAULT_PATTERNS.add(PlanesPattern.class);
        DEFAULT_PATTERNS.add(ChasePattern.class);
        DEFAULT_PATTERNS.add(NoisePattern.class);
        DEFAULT_PATTERNS.add(SparklePattern.class);
        DEFAULT_PATTERNS.add(TestPattern.class);
        DEFAULT_EFFECTS = new ArrayList<Class<? extends LXEffect>>();
        DEFAULT_EFFECTS.add(SoundObjectEffect.class);
        DEFAULT_EFFECTS.add(BlurEffect.class);
        DEFAULT_EFFECTS.add(ColorizeEffect.class);
        DEFAULT_EFFECTS.add(ColorMaskEffect.class);
        DEFAULT_EFFECTS.add(DynamicsEffect.class);
        DEFAULT_EFFECTS.add(InvertEffect.class);
        DEFAULT_EFFECTS.add(HueSaturationEffect.class);
        DEFAULT_EFFECTS.add(SparkleEffect.class);
        DEFAULT_EFFECTS.add(StrobeEffect.class);
        DEFAULT_EFFECTS.add(GateEffect.class);
        DEFAULT_MODULATORS = new ArrayList<Class<? extends LXModulator>>();
        DEFAULT_MODULATORS.add(BandGate.class);
        DEFAULT_MODULATORS.add(SoundObject.class);
        DEFAULT_MODULATORS.add(DmxModulator.class);
        DEFAULT_MODULATORS.add(DmxColorModulator.class);
        DEFAULT_MODULATORS.add(BooleanLogic.class);
        DEFAULT_MODULATORS.add(ComparatorModulator.class);
        DEFAULT_MODULATORS.add(Damper.class);
        DEFAULT_MODULATORS.add(Interval.class);
        DEFAULT_MODULATORS.add(MacroKnobs.class);
        DEFAULT_MODULATORS.add(MacroSwitches.class);
        DEFAULT_MODULATORS.add(MacroTriggers.class);
        DEFAULT_MODULATORS.add(MidiNoteTrigger.class);
        DEFAULT_MODULATORS.add(MultiStageEnvelope.class);
        DEFAULT_MODULATORS.add(MultiModeEnvelope.class);
        DEFAULT_MODULATORS.add(MultiTrig.class);
        DEFAULT_MODULATORS.add(NoiseModulator.class);
        DEFAULT_MODULATORS.add(OperatorModulator.class);
        DEFAULT_MODULATORS.add(Randomizer.class);
        DEFAULT_MODULATORS.add(Scaler.class);
        DEFAULT_MODULATORS.add(Smoother.class);
        DEFAULT_MODULATORS.add(Spring.class);
        DEFAULT_MODULATORS.add(StepSequencer.class);
        DEFAULT_MODULATORS.add(Timer.class);
        DEFAULT_MODULATORS.add(VariableLFO.class);
        DEFAULT_CHANNEL_BLENDS = new ArrayList<Class<? extends LXBlend>>();
        DEFAULT_CHANNEL_BLENDS.add(AddBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(MultiplyBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(SubtractBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(DifferenceBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(NormalBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(DodgeBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(BurnBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(HighlightBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(SpotlightBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(LightestBlend.class);
        DEFAULT_CHANNEL_BLENDS.add(DarkestBlend.class);
        DEFAULT_TRANSITION_BLENDS = new ArrayList<Class<? extends LXBlend>>();
        DEFAULT_TRANSITION_BLENDS.add(DissolveBlend.class);
        DEFAULT_TRANSITION_BLENDS.add(AddBlend.class);
        DEFAULT_TRANSITION_BLENDS.add(MultiplyBlend.class);
        DEFAULT_TRANSITION_BLENDS.add(LightestBlend.class);
        DEFAULT_TRANSITION_BLENDS.add(DarkestBlend.class);
        DEFAULT_TRANSITION_BLENDS.add(DifferenceBlend.class);
        DEFAULT_CROSSFADER_BLENDS = new ArrayList<Class<? extends LXBlend>>();
        DEFAULT_CROSSFADER_BLENDS.add(DissolveBlend.class);
        DEFAULT_CROSSFADER_BLENDS.add(AddBlend.class);
        DEFAULT_CROSSFADER_BLENDS.add(MultiplyBlend.class);
        DEFAULT_CROSSFADER_BLENDS.add(LightestBlend.class);
        DEFAULT_CROSSFADER_BLENDS.add(DarkestBlend.class);
        DEFAULT_CROSSFADER_BLENDS.add(DifferenceBlend.class);
        DEFAULT_FIXTURES = new ArrayList<Class<? extends LXFixture>>();
        DEFAULT_FIXTURES.add(ArcFixture.class);
        DEFAULT_FIXTURES.add(GridFixture.class);
        DEFAULT_FIXTURES.add(PointFixture.class);
        DEFAULT_FIXTURES.add(SpiralFixture.class);
        DEFAULT_FIXTURES.add(StripFixture.class);
    }

    public class Plugin
    implements LXSerializable {
        public final Class<? extends LXPlugin> clazz;
        public LXPlugin instance = null;
        private boolean hasError = false;
        private boolean isEnabled = false;
        private Exception exception = null;
        private final boolean cliEnabled;
        private static final String KEY_CLASS = "class";
        private static final String KEY_ENABLED = "enabled";

        private Plugin(Class<? extends LXPlugin> clazz) {
            this.clazz = clazz;
            this.cliEnabled = this.isPluginCliEnabled(clazz);
            this.isEnabled = this.restorePluginEnabled(clazz);
        }

        private boolean isPluginCliEnabled(Class<? extends LXPlugin> clazz) {
            return LXRegistry.this.lx.flags.enabledPlugins.contains(clazz.getName()) || LXRegistry.this.lx.flags.classpathPlugins.contains(clazz.getName());
        }

        private boolean restorePluginEnabled(Class<? extends LXPlugin> clazz) {
            if (this.cliEnabled) {
                return true;
            }
            try {
                for (JsonElement elem : LXRegistry.this.pluginState) {
                    JsonObject plugin = elem.getAsJsonObject();
                    if (!plugin.get(KEY_CLASS).getAsString().equals(clazz.getName())) continue;
                    return plugin.get(KEY_ENABLED).getAsBoolean();
                }
            }
            catch (Exception x) {
                LX.error(x, "Error parsing saved plugin state: " + LXRegistry.this.pluginState);
            }
            return false;
        }

        public LXPlugin getInstance() {
            return this.instance;
        }

        public boolean hasInstance() {
            return this.instance != null;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public Plugin setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            for (Listener listener : LXRegistry.this.listeners) {
                listener.pluginChanged(LXRegistry.this.lx, this);
            }
            return this;
        }

        private void initialize(LX lx) {
            if (!lx.permissions.canRunPlugins()) {
                return;
            }
            if (!this.isEnabled) {
                return;
            }
            try {
                try {
                    this.instance = this.clazz.getConstructor(LX.class).newInstance(lx);
                }
                catch (NoSuchMethodException nsmx) {
                    this.instance = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                this.instance.initialize(lx);
            }
            catch (Exception x) {
                LX.error(x, "Unhandled exception in plugin initialize: " + this.clazz.getName());
                lx.pushError(x, "Error on initialization of plugin " + this.clazz.getSimpleName() + "\n" + x.getLocalizedMessage());
                this.setException(x);
            }
        }

        public Plugin setException(Exception x) {
            this.hasError = true;
            this.exception = x;
            for (Listener listener : LXRegistry.this.listeners) {
                listener.pluginChanged(LXRegistry.this.lx, this);
            }
            return this;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean hasError() {
            return this.hasError;
        }

        @Override
        public void save(LX lx, JsonObject object) {
            object.addProperty(KEY_CLASS, this.clazz.getName());
            object.addProperty(KEY_ENABLED, Boolean.valueOf(this.isEnabled));
        }

        @Override
        public void load(LX lx, JsonObject object) {
            if (!this.cliEnabled && object.has(KEY_ENABLED)) {
                this.isEnabled = object.get(KEY_ENABLED).getAsBoolean();
            }
        }

        public void dispose() {
            if (this.instance != null) {
                try {
                    this.instance.dispose();
                }
                catch (Exception x) {
                    LX.error(x, "Unhandled exception in plugin dispose: " + this.clazz.getName());
                    LXRegistry.this.lx.pushError(x, "Error on plugin dispose " + this.clazz.getSimpleName() + "\n" + x.getLocalizedMessage());
                    this.setException(x);
                }
            }
        }
    }

    public static interface Listener {
        default public void contentChanged(LX lx) {
        }

        default public void channelBlendsChanged(LX lx) {
        }

        default public void transitionBlendsChanged(LX lx) {
        }

        default public void crossfaderBlendsChanged(LX lx) {
        }

        default public void pluginChanged(LX lx, Plugin plugin) {
        }
    }

    public class JsonFixture {
        public final String type;
        public final boolean isVisible;
        private static final String KEY_IS_VISIBLE = "isVisible";

        private JsonFixture(File file, String prefix) {
            String fileName = prefix + file.getName();
            boolean isVisible = false;
            try (FileReader fr = new FileReader(file);){
                JsonObject obj = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
                if (obj == null) {
                    LX.error("JSON fixture file is empty: " + file.getAbsolutePath());
                    LXRegistry.this.mutableJsonFixtureErrors.add(new Error(prefix, file, "Syntax error", new Exception("File is empty")));
                } else {
                    isVisible = !obj.has(KEY_IS_VISIBLE) || obj.get(KEY_IS_VISIBLE).getAsBoolean();
                }
            }
            catch (JsonSyntaxException jsx) {
                LX.error(jsx, "JSON fixture file has invalid syntax: " + file.getAbsolutePath());
                LXRegistry.this.mutableJsonFixtureErrors.add(new Error(prefix, file, "Syntax error", (Exception)((Object)jsx)));
            }
            catch (JsonParseException jpx) {
                LX.error(jpx, "JSON fixture file is not valid JSON: " + file.getAbsolutePath());
                LXRegistry.this.mutableJsonFixtureErrors.add(new Error(prefix, file, "Parse error", (Exception)((Object)jpx)));
            }
            catch (FileNotFoundException fnfx) {
                LX.error(fnfx, "JSON fixture file does not exist: " + file.getAbsolutePath());
            }
            catch (Exception x) {
                LX.error(x, "Error reading JSON fixture file: " + file.getAbsolutePath());
                LXRegistry.this.mutableJsonFixtureErrors.add(new Error(prefix, file, "I/O error", x));
            }
            this.type = fileName.substring(0, fileName.length() - ".lxf".length());
            this.isVisible = isVisible;
        }

        public class Error {
            public final String path;
            public final String type;
            public final Exception exception;

            Error(String prefix, File file, String type, Exception exception) {
                this.path = prefix + file.getName();
                this.type = type;
                this.exception = exception;
            }
        }
    }
}

