/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import heronarts.lx.LX;
import heronarts.lx.LXModulatorComponent;
import heronarts.lx.LXRunnableComponent;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.modulator.LinearEnvelope;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Tempo
extends LXModulatorComponent
implements LXOscComponent,
LXTriggerSource {
    public static final double DEFAULT_MIN_BPM = 20.0;
    public static final double DEFAULT_MAX_BPM = 240.0;
    private static final double MAX_SLEW_CORRECTION = 3.9;
    private double minOscBpm = 20.0;
    private double maxOscBpm = 240.0;
    private static final double MS_PER_MINUTE = 60000.0;
    private static final double DEFAULT_BPM = 120.0;
    private static final int MAX_BEATS_PER_BAR = 16;
    public final EnumParameter<ClockSource> clockSource = ((EnumParameter)new EnumParameter<ClockSource>("Clock", ClockSource.INTERNAL).setMappable(false)).setDescription("Source of the tempo clock");
    public final DiscreteParameter beatsPerBar = new DiscreteParameter("Time Signature", 4, 1, 17).setDescription("Beats per bar");
    public final BoundedParameter bpm = (BoundedParameter)new BoundedParameter("BPM", 120.0, this.minOscBpm, this.maxOscBpm).setOscMode(LXNormalizedParameter.OscMode.ABSOLUTE).setDescription("Beats per minute of the master tempo");
    public final TriggerParameter trigger = new TriggerParameter("Trigger", () -> this.lx.engine.osc.sendMessage(this.getOscAddress() + "/" + PATH_BEAT, 1 + this.beatCountWithinBar())).setDescription("Listeable trigger which is set on each beat");
    public final BooleanParameter enabled = new BooleanParameter("Enabled").setDescription("Whether tempo trigger modulation is enabled");
    public final BooleanParameter tap = new BooleanParameter("Tap").setDescription("When pressed repeatedlly, tempo is learned from the timing between taps").setMode(BooleanParameter.Mode.MOMENTARY);
    public final BooleanParameter nudgeUp = new BooleanParameter("Nudge+").setDescription("Temporarily increases tempo while engaged");
    public final BooleanParameter nudgeDown = new BooleanParameter("Nudge-").setDescription("Temporarily decreases tempo while engaged");
    private final LinearEnvelope nudge = new LinearEnvelope(1.0, 1.0, 5000.0);
    public final MutableParameter period = (MutableParameter)new MutableParameter(500.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Reports the duration between beats (ms)");
    private final List<Listener> listeners = new ArrayList<Listener>();
    private boolean resetOnNextBeat = false;
    private boolean didTrigger = false;
    private long triggerNanoTime = -1L;
    private boolean running = true;
    private boolean oscParIsPlaying = true;
    private final Cursor target = new Cursor();
    private final Cursor smooth = new Cursor();
    private final Cursor slew = new Cursor();
    private long firstTapNanos = 0L;
    private long lastTapNanos = 0L;
    private int tapCount = 0;
    private boolean inBpmPeriodUpdate = false;
    private int oscBeatCount = -1;
    private static final String PATH_BEAT = "beat";
    private static final String PATH_BEAT_WITHIN_BAR = "beat-within-bar";
    private static final String PATH_SET_BPM = "setBPM";
    private static final String PATH_OSC_PAR = "osc-par";
    private static final String PATH_OSC_PAR_BPM = "BPM";
    private static final String PATH_OSC_PAR_BEAT_POS = "BeatPOS";
    private static final String PATH_OSC_PAR_IS_PLAYING = "isPlaying";

    public Tempo(LX lx) {
        super(lx);
        this.addParameter("clockSource", this.clockSource);
        this.addParameter("period", this.period);
        this.addParameter("bpm", this.bpm);
        this.addParameter("tap", this.tap);
        this.addParameter("nudgeUp", this.nudgeUp);
        this.addParameter("nudgeDown", this.nudgeDown);
        this.addParameter("beatsPerBar", this.beatsPerBar);
        this.addParameter("trigger", this.trigger);
        this.addParameter("enabled", this.enabled);
        this.addModulator("nudge", this.nudge);
        this.addLegacyParameter("beatsPerMeasure", this.beatsPerBar);
    }

    public Tempo setOscBpmRange(double min, double max) {
        if (min <= 0.0 || min >= max) {
            throw new IllegalArgumentException("Tried to set invalid bpm range!");
        }
        this.minOscBpm = min;
        this.maxOscBpm = max;
        return this;
    }

    public boolean isValidOscBpm(double bpm) {
        return bpm >= this.minOscBpm && bpm <= this.maxOscBpm;
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        if (parts[index].equals(PATH_SET_BPM)) {
            if (message.size() > 0) {
                float newBpm = message.getFloat();
                if (this.isValidOscBpm(newBpm)) {
                    this.bpm.setValue(newBpm);
                }
                return true;
            }
        } else {
            if (parts[index].equals(PATH_BEAT)) {
                if (this.clockSource.getObject() == ClockSource.OSC) {
                    if (message.size() > 0) {
                        this.trigger(message.getInt() - 1, message);
                    } else if (this.oscBeatCount < 0) {
                        this.oscBeatCount = 0;
                        this.trigger(0, message);
                    } else {
                        this.trigger(++this.oscBeatCount, message);
                    }
                }
                return true;
            }
            if (parts[index].equals(PATH_BEAT_WITHIN_BAR)) {
                if (this.clockSource.getObject() == ClockSource.OSC) {
                    if (message.size() > 0) {
                        this.triggerBeatWithinBar(message.getInt(), message);
                    } else {
                        LXOscEngine.error("beat-within-bar message missing argument: " + message.toString());
                    }
                }
                return true;
            }
            if (parts[index].equals(PATH_OSC_PAR)) {
                this.handleOscParMessage(message, parts, index + 1);
                return true;
            }
        }
        return super.handleOscMessage(message, parts, index);
    }

    private void handleOscParMessage(OscMessage message, String[] parts, int index) {
        if (index >= parts.length) {
            LXOscEngine.error("osc-par message address is too short: " + message.toString());
            return;
        }
        if (message.size() < 1) {
            LXOscEngine.error("osc-par message missing argument: " + message.toString());
            return;
        }
        if (PATH_OSC_PAR_BPM.equals(parts[index])) {
            this.bpm.setValue(message.getFloat());
        } else if (PATH_OSC_PAR_BEAT_POS.equals(parts[index])) {
            this.trigger(message.getInt(), message);
        } else if (PATH_OSC_PAR_IS_PLAYING.equals(parts[index])) {
            this.running = this.oscParIsPlaying = message.getBoolean();
        }
    }

    @Override
    public String getLabel() {
        return "Tempo";
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.period) {
            if (!this.inBpmPeriodUpdate) {
                this.inBpmPeriodUpdate = true;
                this.bpm.setValue(60000.0 / this.period.getValue());
                this.inBpmPeriodUpdate = false;
            }
        } else if (p == this.bpm) {
            if (!this.inBpmPeriodUpdate) {
                this.inBpmPeriodUpdate = true;
                this.period.setValue(60000.0 / this.bpm.getValue());
                this.inBpmPeriodUpdate = false;
            }
        } else if (p == this.tap) {
            if (this.tap.isOn()) {
                this.tap();
            }
        } else if (p == this.nudgeUp) {
            this.updateNudge(this.nudgeUp, this.nudgeDown, 0.9);
        } else if (p == this.nudgeDown) {
            this.updateNudge(this.nudgeDown, this.nudgeUp, 1.1);
        } else if (p == this.clockSource) {
            this.oscParIsPlaying = true;
            if (this.clockSource.getEnum().isExternal()) {
                this.resetOnNextBeat = false;
                this.oscBeatCount = -1;
                this.running = false;
                this.target.reset();
                this.smooth.reset();
            } else {
                this.running = true;
                if (this.target.basis >= 1.0) {
                    this.target.basis = (this.smooth.basis = 0.0);
                }
            }
        }
    }

    private void updateNudge(BooleanParameter changed, BooleanParameter other, double target) {
        if (changed.isOn()) {
            if (!other.isOn()) {
                ((LXRunnableComponent)this.nudge.setRange(1.0, target).reset()).start();
            }
        } else if (other.isOn()) {
            ((LXRunnableComponent)this.nudge.setRange(1.0, target).reset()).start();
        } else {
            this.nudge.stop();
            this.nudge.setValue(1.0);
        }
    }

    public Tempo addListener(Listener listener) {
        Objects.requireNonNull("May not add null Tempo.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate Tempo.Listener: " + listener);
        }
        this.listeners.add(listener);
        return this;
    }

    public Tempo removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-existent Tempo.Listener: " + listener);
        }
        this.listeners.remove(listener);
        return this;
    }

    public boolean beat() {
        return this.smooth.isBeat;
    }

    public int barCount() {
        return this.smooth.beatCount / this.beatsPerBar.getValuei();
    }

    public int beatCount() {
        return this.smooth.beatCount;
    }

    public int beatCountWithinBar() {
        return this.smooth.beatCountWithinBar();
    }

    public double getCompositeBasis() {
        return this.smooth.getCompositeBasis();
    }

    public int getCycleCount(Division division) {
        double beatMultiple = (double)this.smooth.beatCount * division.multiplier;
        double basisMultiple = this.smooth.basis * division.multiplier;
        return (int)beatMultiple + (int)basisMultiple + (int)(beatMultiple % 1.0 + basisMultiple % 1.0);
    }

    public double getBasis(Division division) {
        double beatMultiple = (double)this.smooth.beatCount * division.multiplier;
        double basisMultiple = this.smooth.basis * division.multiplier;
        return (beatMultiple % 1.0 + basisMultiple % 1.0) % 1.0;
    }

    @Deprecated
    public boolean measure() {
        return this.bar();
    }

    public boolean bar() {
        return this.beat() && 0 == this.beatCountWithinBar();
    }

    public double basis() {
        return this.smooth.basis;
    }

    public float basisf() {
        return (float)this.smooth.basis;
    }

    @Deprecated
    public double ramp() {
        return this.basis();
    }

    @Deprecated
    public float rampf() {
        return (float)this.ramp();
    }

    public double bpm() {
        return this.bpm.getValue();
    }

    public float bpmf() {
        return (float)this.bpm();
    }

    public Tempo setBpm(double bpm) {
        this.bpm.setValue(bpm);
        return this;
    }

    public Tempo adjustBpm(double amount) {
        this.bpm.setValue(this.bpm.getValue() + amount);
        return this;
    }

    public Tempo setPeriod(double beatMillis) {
        this.period.setValue(beatMillis);
        return this;
    }

    public Tempo resetOnNextBeat() {
        if (this.clockSource.getEnum() == ClockSource.INTERNAL) {
            this.resetOnNextBeat = true;
        }
        return this;
    }

    public void trigger() {
        this.trigger(true);
    }

    public void triggerBeatWithinBar(int beatWithinBar, OscMessage message) {
        this.triggerBeatWithinBar(beatWithinBar, message.nanoTime);
    }

    public void triggerBeatWithinBar(int beatWithinBar, long nanoTime) {
        int currentBeat = this.target.beatCountWithinBar();
        int nextBeat = beatWithinBar - 1;
        int currentBar = this.target.barCount();
        if (nextBeat < currentBeat) {
            this.trigger((currentBar + 1) * this.beatsPerBar.getValuei() + nextBeat, nanoTime);
        } else {
            this.trigger(this.target.beatCount + (nextBeat - currentBeat), nanoTime);
        }
    }

    public void triggerBarAndBeat(int bar, int beat) {
        this.triggerBarAndBeat(bar, beat, System.nanoTime());
    }

    public void triggerBarAndBeat(int bar, int beat, OscMessage message) {
        this.triggerBarAndBeat(bar, beat, message.nanoTime);
    }

    public void triggerBarAndBeat(int bar, int beat, long nanoTime) {
        if (bar < 1 || beat < 1) {
            throw new IllegalArgumentException("Bar and beat must be 1 or greater: " + bar + "." + beat);
        }
        this.trigger((bar - 1) * this.beatsPerBar.getValuei() + beat - 1, nanoTime);
    }

    public void trigger(boolean resetBeat) {
        this.trigger(resetBeat ? 0 : this.target.beatCount + 1);
    }

    public void trigger(int beat) {
        this.trigger(beat, System.nanoTime());
    }

    public void trigger(int beat, OscMessage message) {
        this.trigger(beat, message.nanoTime);
    }

    public void trigger(int beat, long nanoTime) {
        this.target.beatCount = beat;
        this.triggerNanoTime = nanoTime;
        this.didTrigger = true;
    }

    public void tap() {
        this.tap(System.nanoTime());
    }

    public void tap(long nanoTime) {
        if (nanoTime - this.lastTapNanos > 2000000000L) {
            this.firstTapNanos = nanoTime;
            this.tapCount = 0;
        }
        this.lastTapNanos = nanoTime;
        ++this.tapCount;
        if (this.tapCount > 3) {
            double beatPeriodMs = (double)(this.lastTapNanos - this.firstTapNanos) / 1000000.0 / ((double)this.tapCount - 1.0);
            this.setBpm(60000.0 / beatPeriodMs);
        }
        this.trigger(this.tapCount - 1);
    }

    public void stop() {
        this.running = false;
    }

    @Override
    public void loop(double deltaMs) {
        boolean oscIsPaused;
        super.loop(deltaMs);
        double progress = deltaMs / (this.period.getValue() * this.nudge.getValue());
        boolean bl = oscIsPaused = this.clockSource.getEnum() == ClockSource.OSC && !this.oscParIsPlaying;
        if (this.didTrigger) {
            this.didTrigger = false;
            double triggerBasis = this.lx.engine.nowNanoTime <= this.triggerNanoTime ? 0.0 : (double)(this.lx.engine.nowNanoTime - this.triggerNanoTime) / 1000000.0 / this.period.getValue();
            this.target.basis = triggerBasis < 1.0 ? triggerBasis : 0.0;
            this.target.isBeat = true;
            this.running = true;
        } else if (this.running && !oscIsPaused) {
            this.target.advance(progress);
        } else {
            this.target.isBeat = false;
        }
        if (oscIsPaused) {
            this.running = false;
        }
        if (this.target.isBeat && this.resetOnNextBeat) {
            this.resetOnNextBeat = false;
            this.target.beatCount = 0;
        }
        this.slew.set(this.smooth);
        this.slew.isBeat = false;
        if (this.running) {
            this.slew.advance(progress);
        }
        double slewError = this.slew.getCompositeDistance(this.target);
        double correctionLerp = LXUtils.min(1.0, slewError);
        if (slewError >= 3.9) {
            this.smooth.set(this.target);
        } else if (this.slew.isEqualTo(this.target)) {
            this.smooth.set(this.slew);
        } else if (this.slew.isBehind(this.target)) {
            double accel = LXUtils.lerp(0.1, 2.0, correctionLerp);
            this.slew.advance(LXUtils.min(slewError, progress * accel), false);
            this.smooth.set(this.slew);
        } else {
            this.smooth.isBeat = false;
            if (this.running) {
                double decel = LXUtils.lerp(0.9, 0.25, correctionLerp);
                this.smooth.advance(progress * decel);
            }
        }
        if (this.smooth.isBeat) {
            int beatsPerBar = this.beatsPerBar.getValuei();
            int beatIndex = this.smooth.beatCount % beatsPerBar;
            int barIndex = this.smooth.beatCount / beatsPerBar;
            if (beatIndex == 0) {
                for (Listener listener : this.listeners) {
                    listener.onBar(this, barIndex);
                }
            }
            for (Listener listener : this.listeners) {
                listener.onBeat(this, beatIndex);
            }
            if (this.enabled.isOn()) {
                this.trigger.trigger();
            }
        }
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.trigger;
    }

    public static enum ClockSource {
        INTERNAL,
        MIDI,
        OSC;


        public boolean isExternal() {
            return this != INTERNAL;
        }

        public String toString() {
            switch (this) {
                case MIDI: {
                    return "MIDI";
                }
                case OSC: {
                    return "OSC";
                }
            }
            return "Int";
        }
    }

    private class Cursor {
        private boolean isBeat = false;
        private int beatCount = 0;
        private double basis = 0.0;

        private Cursor() {
        }

        private void advance(double progress) {
            this.advance(progress, true);
        }

        private void advance(double progress, boolean clearBeat) {
            boolean isBeat = false;
            this.basis += progress;
            if (this.basis >= 1.0) {
                this.beatCount += (int)this.basis;
                this.basis %= 1.0;
                isBeat = true;
            }
            if (clearBeat || isBeat) {
                this.isBeat = isBeat;
            }
        }

        private void reset() {
            this.basis = 0.0;
            this.beatCount = 0;
            this.isBeat = false;
        }

        private void set(Cursor that) {
            this.basis = that.basis;
            this.beatCount = that.beatCount;
            this.isBeat = that.isBeat;
        }

        private int barCount() {
            return this.beatCount / Tempo.this.beatsPerBar.getValuei();
        }

        private int beatCountWithinBar() {
            return this.beatCount % Tempo.this.beatsPerBar.getValuei();
        }

        private double getCompositeBasis() {
            return (double)this.beatCount + this.basis;
        }

        private boolean isEqualTo(Cursor that) {
            return this.beatCount == that.beatCount && this.basis == that.basis;
        }

        private boolean isBehind(Cursor that) {
            return this.beatCount < that.beatCount || this.beatCount == that.beatCount && this.basis < that.basis;
        }

        private double getCompositeDistance(Cursor that) {
            return Math.abs(this.getCompositeBasis() - that.getCompositeBasis());
        }
    }

    public static enum Division {
        SIXTEENTH(4.0, "1/16"),
        EIGHTH_TRIPLET(3.0, "1/8T"),
        EIGHTH(2.0, "1/8"),
        EIGHTH_DOT(1.5, "3/16"),
        QUARTER_TRIPLET(1.3333333333333333, "1/4T"),
        QUARTER(1.0, "1/4"),
        HALF_TRIPLET(0.75, "1/2T"),
        QUARTER_DOT(0.6666666666666666, "3/8"),
        HALF(0.5, "1/2"),
        HALF_DOT(0.3333333333333333, "3/4"),
        WHOLE(0.25, "1"),
        WHOLE_DOT(0.16666666666666666, "3/2"),
        DOUBLE(0.125, "2"),
        FOUR(0.0625, "4"),
        EIGHT(0.03125, "8"),
        SIXTEEN(0.015625, "16");

        public final double multiplier;
        public final String label;

        private Division(double multiplier, String label) {
            this.multiplier = multiplier;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static interface Listener {
        default public void onBeat(Tempo tempo, int beat) {
        }

        default public void onBar(Tempo tempo, int bar) {
            this.onMeasure(tempo);
        }

        @Deprecated
        default public void onMeasure(Tempo tempo) {
        }
    }
}

