/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.audio.DecibelMeter;
import heronarts.lx.audio.FourierTransform;
import heronarts.lx.audio.GraphicMeter;
import heronarts.lx.audio.LXMeterImpl;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.NormalizedParameter;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Audio")
@LXModulator.Global(value="Beat Detect")
@LXModulator.Device(value="Beat Detect")
public class BandGate
extends LXModulator
implements LXNormalizedParameter,
LXTriggerSource,
LXOscComponent {
    public final BoundedParameter gain = new BoundedParameter("Gain", 0.0, -48.0, 48.0).setDescription("Sets the gain of the meter in dB").setUnits(LXParameter.Units.DECIBELS);
    public final BoundedParameter range = new BoundedParameter("Range", 36.0, 6.0, 96.0).setDescription("Sets the range of the meter in dB").setUnits(LXParameter.Units.DECIBELS);
    public final BoundedParameter attack = new BoundedParameter("Attack", 10.0, 0.0, 100.0).setDescription("Sets the attack time of the meter response").setUnits(LXParameter.Units.MILLISECONDS_RAW);
    public final BoundedParameter release = new BoundedParameter("Release", 100.0, 0.0, 1000.0).setDescription("Sets the release time of the meter response").setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS_RAW);
    public final BoundedParameter slope = new BoundedParameter("Slope", 4.5, -3.0, 12.0).setDescription("Sets the slope of the meter in dB per octave").setUnits(LXParameter.Units.DECIBELS);
    public final BoundedParameter threshold = new BoundedParameter("Threshold", 0.8).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the level at which the band is triggered");
    public final BoundedParameter floor = new BoundedParameter("Floor", 0.75).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the level the signal must drop below before being triggered again");
    public final BoundedParameter decay = new BoundedParameter("Decay", 400.0, 0.0, 1600.0).setDescription("Sets the decay time of the trigger signal").setUnits(LXParameter.Units.MILLISECONDS_RAW);
    public final BoundedParameter minFreq;
    public final BoundedParameter maxFreq;
    public final GraphicMeter meter;
    public final BooleanParameter gate = new BooleanParameter("Gate").setDescription("Engages when the beat is first detected").setMode(BooleanParameter.Mode.MOMENTARY);
    public final BooleanParameter teachTempo = new BooleanParameter("Tap", false).setDescription("When enabled, each triggering of the band taps the global tempo");
    private int tapCount = 0;
    public final NormalizedParameter average = new NormalizedParameter("Average").setDescription("Computed average level of the audio within the frequency range");
    private float averageRaw = 0.0f;
    private double envelope = 0.0;
    private double averageOctave = 1.0;
    private boolean waitingForFloor = false;
    private final LXMeterImpl impl;

    public BandGate(LX lx) {
        this("Beat", lx);
    }

    public BandGate(String label, LX lx) {
        this(label, lx.engine.audio.meter);
    }

    public BandGate(String label, GraphicMeter meter) {
        super(label);
        this.impl = new LXMeterImpl(meter.numBands, meter.fft.getBandOctaveRatio());
        this.meter = meter;
        int nyquist = meter.fft.getSampleRate() / 2;
        this.minFreq = new BoundedParameter("Min Freq", 60.0, 0.0, nyquist).setDescription("Minimum frequency the gate responds to").setExponent(4.0).setUnits(LXParameter.Units.HERTZ);
        this.maxFreq = new BoundedParameter("Max Freq", 120.0, 0.0, nyquist).setDescription("Maximum frequency the gate responds to").setExponent(4.0).setUnits(LXParameter.Units.HERTZ);
        this.addParameter("gain", this.gain);
        this.addParameter("range", this.range);
        this.addParameter("attack", this.attack);
        this.addParameter("release", this.release);
        this.addParameter("slope", this.slope);
        this.addParameter("threshold", this.threshold);
        this.addParameter("floor", this.floor);
        this.addParameter("decay", this.decay);
        this.addParameter("minFreq", this.minFreq);
        this.addParameter("maxFreq", this.maxFreq);
        this.addParameter("gate", this.gate);
        this.addParameter("average", this.average);
        this.addParameter("tap", this.teachTempo);
        this.setDescription("Envelope that fires when a beat is detected");
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.minFreq) {
            if (this.minFreq.getValue() > this.maxFreq.getValue()) {
                this.minFreq.setValue(this.maxFreq.getValue());
            } else {
                this.updateAverageOctave();
            }
        } else if (p == this.maxFreq) {
            if (this.maxFreq.getValue() < this.minFreq.getValue()) {
                this.maxFreq.setValue(this.minFreq.getValue());
            } else {
                this.updateAverageOctave();
            }
        } else if (p == this.teachTempo) {
            this.tapCount = 0;
        }
    }

    private void updateAverageOctave() {
        double averageFreq = (this.minFreq.getValue() + this.maxFreq.getValue()) / 2.0;
        this.averageOctave = Math.log(averageFreq / (double)65.41f) / (double)FourierTransform.LOG_2;
    }

    public BandGate(GraphicMeter meter, float minHz, float maxHz) {
        this("Beat", meter);
        this.setFrequencyRange(minHz, maxHz);
    }

    public BandGate(String label, GraphicMeter meter, int minHz, int maxHz) {
        this(label, meter);
        this.setFrequencyRange(minHz, maxHz);
    }

    @Override
    public double getExponent() {
        throw new UnsupportedOperationException("BandGate does not support exponent");
    }

    public BandGate setFrequencyRange(float minHz, float maxHz) {
        this.minFreq.setValue(minHz);
        this.maxFreq.setValue(maxHz);
        return this;
    }

    public double getBand(int i) {
        return this.impl.getBand(i);
    }

    @Override
    protected double computeValue(double deltaMs) {
        boolean triggered;
        double floorValue;
        float attackGain = (float)Math.exp(-deltaMs / this.attack.getValue());
        float releaseGain = (float)Math.exp(-deltaMs / this.release.getValue());
        double rangeValue = this.range.getValue();
        double gainValue = this.gain.getValue();
        double slopeValue = this.slope.getValue();
        this.impl.compute(this.meter.fft, attackGain, releaseGain, gainValue, rangeValue, slopeValue);
        float newAverage = this.meter.fft.getAverage(this.minFreq.getValuef(), this.maxFreq.getValuef()) / (float)this.meter.fft.getSize();
        float averageGain = newAverage >= this.averageRaw ? attackGain : releaseGain;
        this.averageRaw = newAverage + averageGain * (this.averageRaw - newAverage);
        double averageDb = 20.0 * Math.log(this.averageRaw) / DecibelMeter.LOG_10 + gainValue + slopeValue * this.averageOctave;
        double averageNorm = 1.0 + averageDb / rangeValue;
        this.average.setValue(LXUtils.constrain(averageNorm, 0.0, 1.0));
        double thresholdValue = this.threshold.getValue();
        if (this.waitingForFloor && averageNorm < (floorValue = thresholdValue * this.floor.getValue())) {
            this.waitingForFloor = false;
        }
        boolean bl = triggered = !this.waitingForFloor && thresholdValue > 0.0 && averageNorm >= thresholdValue;
        if (triggered) {
            if (this.teachTempo.isOn()) {
                this.lx.engine.tempo.tap();
                if (++this.tapCount >= 4) {
                    this.teachTempo.setValue(false);
                }
            }
            this.waitingForFloor = true;
            this.envelope = 1.0;
        } else {
            this.envelope = Math.max(0.0, this.envelope - deltaMs / this.decay.getValue());
        }
        this.gate.setValue(triggered);
        return this.envelope;
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("BandGate does not support setNormalized()");
    }

    @Override
    public double getNormalized() {
        return this.envelope;
    }

    @Override
    public float getNormalizedf() {
        return (float)this.getNormalized();
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.gate;
    }
}

