/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.audio.LXAudioBuffer;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

public class DecibelMeter
extends LXModulator
implements LXNormalizedParameter,
LXOscComponent {
    protected static final double LOG_10 = Math.log(10.0);
    protected LXAudioBuffer buffer;
    public final CompoundParameter gain;
    public final CompoundParameter range;
    public final CompoundParameter attack;
    public final CompoundParameter release;
    private static final float PEAK_HOLD = 250.0f;
    protected float attackGain;
    protected float releaseGain;
    private float rmsRaw = 0.0f;
    private float rmsLevel = 0.0f;
    private double dbLevel = -96.0;
    private float rmsPeak = 0.0f;
    private double dbPeak = 0.0;
    private double normalizedPeak = 0.0;
    private long peakMillis = 0L;

    public DecibelMeter(LXAudioBuffer buffer) {
        this("Meter", buffer);
    }

    public DecibelMeter(String label, LXAudioBuffer buffer) {
        this(label, buffer, new Parameters());
        this.addParameter("gain", this.gain);
        this.addParameter("range", this.range);
        this.addParameter("attack", this.attack);
        this.addParameter("release", this.release);
    }

    public DecibelMeter(String label, LXAudioBuffer buffer, Parameters params) {
        this(label, buffer, params.gain, params.range, params.attack, params.release);
    }

    public DecibelMeter(String label, LXAudioBuffer buffer, CompoundParameter gain, CompoundParameter range, CompoundParameter attack, CompoundParameter release) {
        super(label);
        this.buffer = buffer;
        this.gain = gain;
        this.range = range;
        this.attack = attack;
        this.release = release;
    }

    public DecibelMeter setBuffer(LXAudioBuffer buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public double getExponent() {
        throw new UnsupportedOperationException("DecibelMeter does not support exponent");
    }

    public float getRaw() {
        return this.rmsRaw;
    }

    public double getDecibels() {
        return this.dbLevel;
    }

    public float getDecibelsf() {
        return (float)this.getDecibels();
    }

    public double getSquare() {
        double norm = this.getValue();
        return norm * norm;
    }

    public float getSquaref() {
        return (float)this.getSquare();
    }

    @Override
    protected double computeValue(double deltaMs) {
        double releaseValue = this.release.getValue();
        this.attackGain = (float)Math.exp(-deltaMs / this.attack.getValue());
        this.releaseGain = (float)Math.exp(-deltaMs / releaseValue);
        this.rmsRaw = this.buffer.getRms();
        float rmsGain = this.rmsRaw >= this.rmsLevel ? this.attackGain : this.releaseGain;
        this.rmsLevel = this.rmsRaw + rmsGain * (this.rmsLevel - this.rmsRaw);
        if (this.rmsRaw > this.rmsPeak) {
            this.rmsPeak = this.rmsRaw;
            this.peakMillis = 0L;
        } else {
            this.peakMillis = (long)((double)this.peakMillis + deltaMs);
            if ((float)this.peakMillis > 250.0f) {
                double peakReleaseTime = Math.min(deltaMs, (double)((float)this.peakMillis - 250.0f));
                float releaseGain = (float)Math.exp(-peakReleaseTime / releaseValue);
                this.rmsPeak *= releaseGain;
            }
        }
        double range = this.range.getValue();
        double gain = this.gain.getValue();
        this.dbPeak = 20.0 * Math.log(this.rmsPeak) / LOG_10 + gain;
        this.normalizedPeak = LXUtils.constrain(1.0 + this.dbPeak / range, 0.0, 1.0);
        this.dbLevel = 20.0 * Math.log(this.rmsLevel) / LOG_10 + gain;
        return LXUtils.constrain(1.0 + this.dbLevel / range, 0.0, 1.0);
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("Cannot setNormalized on DecibelMeter");
    }

    public double getPeak() {
        return this.normalizedPeak;
    }

    public float getPeakf() {
        return (float)this.getPeak();
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }

    @Override
    public float getNormalizedf() {
        return (float)this.getNormalized();
    }

    private static class Parameters {
        public final CompoundParameter gain = new CompoundParameter("Gain", 0.0, -48.0, 48.0).setDescription("Sets the gain of the meter in dB").setUnits(LXParameter.Units.DECIBELS);
        public final CompoundParameter range = new CompoundParameter("Range", 48.0, 6.0, 96.0).setDescription("Sets the range of the meter in dB").setUnits(LXParameter.Units.DECIBELS);
        public final CompoundParameter attack = new CompoundParameter("Attack", 10.0, 0.0, 100.0).setDescription("Sets the attack time of the meter response").setUnits(LXParameter.Units.MILLISECONDS_RAW);
        public final CompoundParameter release = new CompoundParameter("Release", 100.0, 0.0, 1000.0).setDescription("Sets the release time of the meter response").setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS_RAW);

        private Parameters() {
        }
    }
}

