/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

public class FourierTransform {
    public static final float LOG_2 = (float)Math.log(2.0);
    public static final float BASE_BAND_HZ = 65.41f;
    public static final int DEFAULT_NUM_BANDS = 16;
    private Window window = Window.HAMMING;
    private final int bufferSize;
    private final int sampleRate;
    private final float bandWidthInv;
    private final int logN;
    private final float[] sinN;
    private final float[] cosN;
    private final float[] windowCoefficients;
    private final int[] bitReverseIndex;
    private final float[] real;
    private final float[] imaginary;
    private final float[] amplitude;
    private int numBands = 0;
    private float[] bands;
    private int[] bandOffset;
    private float bandOctaveRatio;

    public FourierTransform(int bufferSize, int sampleRate) {
        if ((bufferSize & bufferSize - 1) != 0) {
            throw new IllegalArgumentException("bufferSize must be a power of two: " + bufferSize);
        }
        this.bufferSize = bufferSize;
        this.sampleRate = sampleRate;
        this.bandWidthInv = (float)this.bufferSize / (float)this.sampleRate;
        this.logN = (int)(Math.log(bufferSize) / Math.log(2.0));
        this.sinN = new float[this.logN];
        this.cosN = new float[this.logN];
        this.computePhaseTables();
        this.windowCoefficients = new float[this.bufferSize];
        this.computeWindowCoefficients();
        this.bitReverseIndex = new int[this.bufferSize];
        this.computeBitReverseIndices();
        this.real = new float[this.bufferSize];
        this.imaginary = new float[this.bufferSize];
        this.amplitude = new float[this.bufferSize / 2 + 1];
        this.setNumBands(16);
    }

    private void computePhaseTables() {
        int i = 0;
        int N = 1;
        while (i < this.logN) {
            this.sinN[i] = (float)Math.sin(-Math.PI / (double)N);
            this.cosN[i] = (float)Math.cos(-Math.PI / (double)N);
            ++i;
            N <<= 1;
        }
    }

    private void computeBitReverseIndices() {
        this.bitReverseIndex[0] = 0;
        int limit = 1;
        int bit = this.bufferSize / 2;
        while (limit < this.bufferSize) {
            for (int i = 0; i < limit; ++i) {
                this.bitReverseIndex[i + limit] = this.bitReverseIndex[i] + bit;
            }
            limit <<= 1;
            bit >>= 1;
        }
    }

    public int getSize() {
        return this.bufferSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public FourierTransform setWindow(Window window) {
        if (this.window != window) {
            this.window = window;
            this.computeWindowCoefficients();
        }
        return this;
    }

    private void computeWindowCoefficients() {
        for (int i = 0; i < this.bufferSize; ++i) {
            this.windowCoefficients[i] = this.window.getCoefficient(i, this.bufferSize);
        }
    }

    public FourierTransform compute(float[] samples) {
        int i;
        if (samples.length != this.bufferSize) {
            throw new IllegalArgumentException("Samples must have same length as FourierTransform size: " + samples.length);
        }
        for (i = 0; i < this.bufferSize; ++i) {
            int bri = this.bitReverseIndex[i];
            this.real[i] = samples[bri] * this.windowCoefficients[bri];
            this.imaginary[i] = 0.0f;
        }
        int l = 0;
        int n = 1;
        while (l < this.logN) {
            float cosN = this.cosN[l];
            float sinN = this.sinN[l];
            float phaseR = 1.0f;
            float phaseI = 0.0f;
            for (int f = 0; f < n; ++f) {
                for (int i2 = f; i2 < this.bufferSize; i2 += 2 * n) {
                    int n2 = i2 + n;
                    float tR = phaseR * this.real[n2] - phaseI * this.imaginary[n2];
                    float tI = phaseR * this.imaginary[n2] + phaseI * this.real[n2];
                    this.real[n2] = this.real[i2] - tR;
                    this.imaginary[n2] = this.imaginary[i2] - tI;
                    int n3 = i2;
                    this.real[n3] = this.real[n3] + tR;
                    int n4 = i2;
                    this.imaginary[n4] = this.imaginary[n4] + tI;
                }
                float tmpR = phaseR;
                phaseR = phaseR * cosN - phaseI * sinN;
                phaseI = tmpR * sinN + phaseI * cosN;
            }
            ++l;
            n <<= 1;
        }
        for (i = 0; i < this.amplitude.length; ++i) {
            this.amplitude[i] = (float)Math.sqrt(this.real[i] * this.real[i] + this.imaginary[i] * this.imaginary[i]);
        }
        if (this.numBands > 0) {
            for (int band = 0; band < this.numBands; ++band) {
                float avg = 0.0f;
                for (int i3 = this.bandOffset[band]; i3 <= this.bandOffset[band + 1]; ++i3) {
                    avg += this.amplitude[i3];
                }
                this.bands[band] = avg / (float)(this.bandOffset[band + 1] - this.bandOffset[band] + 1);
            }
        }
        return this;
    }

    public float get(int i) {
        return this.amplitude[i];
    }

    public FourierTransform setNumBands(int numBands) {
        if (this.numBands != numBands) {
            this.numBands = numBands;
            this.bands = new float[this.numBands];
            this.bandOffset = new int[this.numBands + 1];
            this.bandOffset[0] = 0;
            float nyquist = this.sampleRate / 2;
            float nyquistRatio = nyquist / 65.41f;
            float bandExpRange = (float)Math.log(nyquistRatio) / LOG_2;
            this.bandOctaveRatio = bandExpRange / (float)(this.numBands - 1);
            for (int i = 0; i < this.numBands; ++i) {
                float bandLimitHz = (float)Math.pow(2.0, (float)i * this.bandOctaveRatio) * 65.41f;
                this.bandOffset[i + 1] = Math.round(this.bandWidthInv * bandLimitHz);
            }
        }
        return this;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public float getBandOctaveRatio() {
        return this.bandOctaveRatio;
    }

    public float getBand(int i) {
        return this.bands[i];
    }

    public float getAverage(float minHz, float maxHz) {
        int low = Math.round(minHz * this.bandWidthInv);
        int high = Math.round(maxHz * this.bandWidthInv);
        float avg = 0.0f;
        for (int i = low; i <= high; ++i) {
            avg += this.amplitude[i];
        }
        return avg / (float)(high - low + 1);
    }

    static enum Window {
        RECTANGULAR,
        HAMMING;


        public float getCoefficient(int i, int n) {
            switch (this) {
                case HAMMING: {
                    return 0.54f - 0.46f * (float)Math.cos(Math.PI * 2 * (double)i / (double)(n - 1));
                }
            }
            return 1.0f;
        }
    }
}

