/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.audio.DecibelMeter;
import heronarts.lx.audio.FourierTransform;
import heronarts.lx.audio.LXAudioBuffer;
import heronarts.lx.audio.LXAudioComponent;
import heronarts.lx.audio.LXMeterImpl;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.NormalizedParameter;

public class GraphicMeter
extends DecibelMeter {
    private final LXMeterImpl impl;
    public final CompoundParameter slope = new CompoundParameter("Slope", 4.5, -3.0, 12.0).setDescription("Sets the slope of the meter in dB per octave").setUnits(LXParameter.Units.DECIBELS);
    public final int numBands;
    public final FourierTransform fft;
    private final float[] sampleBuffer;
    public final NormalizedParameter[] bands;

    public GraphicMeter(LXAudioComponent component) {
        this(component.mix);
    }

    public GraphicMeter(LXAudioBuffer buffer) {
        this(buffer, 16);
    }

    public GraphicMeter(String label, LXAudioBuffer buffer) {
        this(label, buffer, 16);
    }

    public GraphicMeter(LXAudioBuffer buffer, int numBands) {
        this("Meter", buffer, numBands);
    }

    public GraphicMeter(String label, LXAudioBuffer buffer, int numBands) {
        super(label, buffer);
        this.addParameter("slope", this.slope);
        this.sampleBuffer = new float[buffer.bufferSize()];
        this.fft = new FourierTransform(buffer.bufferSize(), buffer.sampleRate());
        this.numBands = numBands;
        this.fft.setNumBands(this.numBands);
        this.impl = new LXMeterImpl(this.numBands, this.fft.getBandOctaveRatio());
        this.bands = this.impl.bands;
        int i = 1;
        for (NormalizedParameter band : this.bands) {
            this.addParameter("band-" + i++, band);
        }
    }

    @Override
    protected double computeValue(double deltaMs) {
        double result = super.computeValue(deltaMs);
        this.buffer.getSamples(this.sampleBuffer);
        this.fft.compute(this.sampleBuffer);
        this.impl.compute(this.fft, this.attackGain, this.releaseGain, this.gain.getValue(), this.range.getValue(), this.slope.getValue());
        return result;
    }

    public float[] getSamples() {
        return this.sampleBuffer;
    }

    public float getRaw(int i) {
        return this.impl.rawBands[i];
    }

    public double getDecibels(int i) {
        return -this.range.getValue() * (1.0 - this.getBand(i));
    }

    public float getDecibelsf(int i) {
        return (float)this.getDecibels(i);
    }

    public int getNumBands() {
        return this.bands.length;
    }

    public double getBand(int i) {
        return this.bands[i].getValue();
    }

    public float getBandf(int i) {
        return (float)this.getBand(i);
    }

    public double getSquare(int i) {
        double norm = this.getBand(i);
        return norm * norm;
    }

    public float getSquaref(int i) {
        return (float)this.getSquare(i);
    }

    public double getAverage(int minBand, int avgBands) {
        return this.impl.getAverage(minBand, avgBands);
    }

    public float getAveragef(int minBand, int avgBands) {
        return (float)this.getAverage(minBand, avgBands);
    }
}

