/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXModulatorComponent;
import heronarts.lx.audio.ADM;
import heronarts.lx.audio.DecibelMeter;
import heronarts.lx.audio.Envelop;
import heronarts.lx.audio.GraphicMeter;
import heronarts.lx.audio.LXAudioComponent;
import heronarts.lx.audio.LXAudioInput;
import heronarts.lx.audio.LXAudioOutput;
import heronarts.lx.audio.Reaper;
import heronarts.lx.audio.SoundObject;
import heronarts.lx.audio.SoundStage;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.MutableParameter;

public class LXAudioEngine
extends LXModulatorComponent
implements LXOscComponent {
    public final BooleanParameter enabled = new BooleanParameter("Enabled", false).setDescription("Sets whether the audio engine is active");
    public final BooleanParameter expandedPerformance = new BooleanParameter("Enabled", true).setDescription("Whether the audio pane is expanded in performance mode");
    final MutableParameter numSoundObjects = (MutableParameter)new MutableParameter("Sound Objects", 0.0).setDescription("Number of registered sound objects");
    public final LXAudioInput input;
    public final LXAudioOutput output;
    public final Meter meter;
    public final SoundStage soundStage;
    public final ADM adm;
    public final Envelop envelop;
    public final Reaper reaper;
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.INPUT);
    public final BooleanParameter ioExpanded = new BooleanParameter("I/O Expanded", false).setDescription("Show I/O section in the UI");

    public LXAudioEngine(LX lx) {
        super(lx, "Audio");
        this.addParameter("enabled", this.enabled);
        this.addParameter("mode", this.mode);
        this.addParameter("expandedPerformance", this.expandedPerformance);
        this.addInternalParameter("ioExpanded", this.ioExpanded);
        this.addInternalParameter("numSoundObjects", this.numSoundObjects);
        this.input = new LXAudioInput(lx);
        this.addChild("input", this.input);
        this.output = new LXAudioOutput(lx);
        this.addChild("output", this.output);
        this.soundStage = new SoundStage(lx);
        this.addChild("soundStage", this.soundStage);
        this.adm = new ADM(lx);
        this.addChild("adm", this.adm);
        this.envelop = new Envelop(lx);
        this.addChild("envelop", this.envelop);
        this.reaper = new Reaper(lx);
        this.addChild("reaper", this.reaper);
        this.meter = new Meter();
        this.addModulator("meter", this.meter);
    }

    @Override
    public void loop(double deltaMs) {
        super.loop(deltaMs);
        this.envelop.loop(deltaMs);
        this.reaper.loop(deltaMs);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.enabled) {
            if (this.enabled.isOn()) {
                this.input.open();
                this.input.start();
            } else {
                this.input.stop();
            }
            this.meter.running.setValue(this.enabled.isOn());
        } else if (p == this.mode) {
            switch (this.mode.getEnum()) {
                case INPUT: {
                    this.meter.setBuffer(this.input);
                    break;
                }
                case OUTPUT: {
                    this.meter.setBuffer(this.output);
                }
            }
        }
    }

    public final LXAudioInput getInput() {
        return this.input;
    }

    @Override
    public void dispose() {
        this.input.close();
        this.output.close();
        super.dispose();
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.output.reset();
        this.numSoundObjects.setValue(0.0);
        super.load(lx, obj);
        SoundObject.updateSelectors(lx);
    }

    public static enum Mode {
        INPUT("Input"),
        OUTPUT("Output");

        public final String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public class Meter
    extends GraphicMeter {
        public final DecibelMeter left;
        public final DecibelMeter right;

        private Meter() {
            super("Meter", LXAudioEngine.this.input.mix);
            this.left = new DecibelMeter("Left", LXAudioEngine.this.input.left, this.gain, this.range, this.attack, this.release);
            this.right = new DecibelMeter("Right", LXAudioEngine.this.input.right, this.gain, this.range, this.attack, this.release);
        }

        public Meter setBuffer(LXAudioComponent device) {
            this.setBuffer(device.mix);
            this.left.setBuffer(device.left);
            this.right.setBuffer(device.right);
            return this;
        }

        @Override
        public void onStart() {
            this.left.start();
            this.right.start();
        }

        @Override
        public void onStop() {
            this.left.stop();
            this.right.stop();
        }

        @Override
        public double computeValue(double deltaMs) {
            double value = super.computeValue(deltaMs);
            this.left.loop(deltaMs);
            this.right.loop(deltaMs);
            return value;
        }
    }
}

