/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.LX;
import heronarts.lx.audio.LXAudioComponent;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.ObjectParameter;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class LXAudioInput
extends LXAudioComponent
implements LXOscComponent {
    private AudioFormat format = STEREO;
    public final ObjectParameter<Device> device;
    private InputThread inputThread = null;

    LXAudioInput(LX lx) {
        super(lx, "Input");
        Mixer.Info[] mixers;
        ArrayList<Device> devices = new ArrayList<Device>();
        block0: for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            Line.Info[] targetLines;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            for (Line.Info lineInfo : targetLines = mixer.getTargetLineInfo()) {
                if (!(lineInfo instanceof DataLine.Info)) continue;
                devices.add(new Device(mixerInfo, mixer, (DataLine.Info)lineInfo));
                continue block0;
            }
        }
        if (devices.size() == 0) {
            devices.add(new Device.Unavailable());
        }
        this.device = new ObjectParameter<Device>("Device", devices.toArray(new Device[0]));
        this.addParameter("device", this.device);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.device) {
            this.close();
            if (this.lx.engine.audio.enabled.isOn()) {
                this.open();
            }
        }
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    void open() {
        if (this.inputThread == null) {
            Device device = this.device.getObject();
            if (!device.isAvailable()) {
                LX.error("LXAudioInput device is not available, audio input will not work: " + device);
                return;
            }
            DataLine.Info info = null;
            if (device.mixer.isLineSupported(STEREO_TARGET_LINE)) {
                this.format = STEREO;
                info = STEREO_TARGET_LINE;
            } else if (device.mixer.isLineSupported(MONO_TARGET_LINE)) {
                this.format = MONO;
                info = MONO_TARGET_LINE;
            } else {
                LX.error("Audio device does not support mono/stereo 16-bit input: " + device);
                return;
            }
            TargetDataLine targetLine = null;
            try {
                targetLine = (TargetDataLine)device.mixer.getLine(info);
                targetLine.open(this.format, 2 * (this.format == MONO ? 1024 : 2048));
            }
            catch (Exception x) {
                LX.error(x, "Exception opening audio input line and starting audio input thread: " + device);
                return;
            }
            this.inputThread = new InputThread(device, targetLine, this.format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        if (this.inputThread == null) {
            LX.error("Cannot start LXAudioInput - it is not open: " + this.device.getObject());
            return;
        }
        this.inputThread.stopped = false;
        this.inputThread.line.start();
        InputThread inputThread = this.inputThread;
        synchronized (inputThread) {
            this.inputThread.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.inputThread == null) {
            LX.error("Cannot stop LXAudioInput - it is not open: " + this.device.getObject());
            return;
        }
        this.inputThread.stopped = true;
        this.inputThread.line.stop();
        InputThread inputThread = this.inputThread;
        synchronized (inputThread) {
            this.inputThread.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.inputThread != null) {
            this.inputThread.line.flush();
            this.stop();
            this.inputThread.closed = true;
            this.inputThread.line.close();
            InputThread inputThread = this.inputThread;
            synchronized (inputThread) {
                this.inputThread.notify();
            }
            try {
                this.inputThread.join();
            }
            catch (InterruptedException ix) {
                LX.error(ix, "Interrupted waiting to join audio input thread: " + ix.getLocalizedMessage());
            }
            this.inputThread = null;
        }
    }

    private class InputThread
    extends Thread
    implements LineListener {
        private boolean closed;
        private boolean stopped;
        private final Device device;
        private final TargetDataLine line;
        private final AudioFormat format;
        private final byte[] rawBytes;

        private InputThread(Device device, TargetDataLine line, AudioFormat format) {
            super("LXAudioEngine Input Thread");
            this.closed = false;
            this.stopped = false;
            this.device = device;
            this.line = line;
            this.format = format;
            this.rawBytes = new byte[this.format == LXAudioComponent.MONO ? 1024 : 2048];
            this.line.addLineListener(this);
            this.line.start();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LX.log("Started audio input thread: " + this.device);
            while (!this.closed) {
                while (this.stopped) {
                    if (this.closed) {
                        return;
                    }
                    try {
                        InputThread inputThread = this;
                        synchronized (inputThread) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                this.line.read(this.rawBytes, 0, this.rawBytes.length);
                if (this.format == LXAudioComponent.MONO) {
                    LXAudioInput.this.mix.putSamples(this.rawBytes, 0, 1024, 2);
                    continue;
                }
                LXAudioInput.this.left.putSamples(this.rawBytes, 0, 2048, 4);
                LXAudioInput.this.right.putSamples(this.rawBytes, 2, 2048, 4);
                LXAudioInput.this.mix.computeMix(LXAudioInput.this.left, LXAudioInput.this.right);
            }
            this.line.removeLineListener(this);
            LX.log("Finished audio input thread: " + this.device);
        }

        @Override
        public void update(LineEvent event) {
            LineEvent.Type type = event.getType();
            if (type != LineEvent.Type.OPEN && type != LineEvent.Type.START) {
                if (type == LineEvent.Type.STOP) {
                    this.stopped = true;
                } else if (type == LineEvent.Type.CLOSE) {
                    this.closed = true;
                }
            }
        }
    }

    public static class Device {
        public final Mixer.Info info;
        public final Mixer mixer;
        public final DataLine.Info line;

        Device(Mixer.Info info, Mixer mixer, DataLine.Info dataLine) {
            this.info = info;
            this.mixer = mixer;
            this.line = dataLine;
        }

        public String toString() {
            return this.info.getName();
        }

        public boolean isAvailable() {
            return true;
        }

        public static class Unavailable
        extends Device {
            Unavailable() {
                super(null, null, null);
            }

            @Override
            public String toString() {
                return "No Input";
            }

            @Override
            public boolean isAvailable() {
                return false;
            }
        }
    }
}

