/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.audio.DecibelMeter;
import heronarts.lx.audio.FourierTransform;
import heronarts.lx.parameter.NormalizedParameter;

class LXMeterImpl {
    final int numBands;
    final float bandOctaveRatio;
    final float[] rawBands;
    final float[] rmsBands;
    final double[] dbBands;
    final NormalizedParameter[] bands;

    LXMeterImpl(int numBands, float bandOctaveRatio) {
        this.numBands = numBands;
        this.bandOctaveRatio = bandOctaveRatio;
        this.rawBands = new float[this.numBands];
        this.rmsBands = new float[this.numBands];
        this.dbBands = new double[this.numBands];
        this.bands = new NormalizedParameter[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            this.bands[i] = new NormalizedParameter("Band-" + (i + 1), 0.0);
            this.rawBands[i] = 0.0f;
            this.rmsBands[i] = 0.0f;
            this.dbBands[i] = -96.0;
        }
    }

    void compute(FourierTransform fft, float attackGain, float releaseGain, double gain, double range, double slope) {
        for (int i = 0; i < this.numBands; ++i) {
            float rmsBand = fft.getBand(i) / (float)fft.getSize();
            float rmsGain = rmsBand >= this.rmsBands[i] ? attackGain : releaseGain;
            this.rmsBands[i] = rmsBand + rmsGain * (this.rmsBands[i] - rmsBand);
            this.dbBands[i] = 20.0 * Math.log(this.rmsBands[i]) / DecibelMeter.LOG_10 + gain + (double)i * slope * (double)this.bandOctaveRatio;
            this.bands[i].setValue(1.0 + this.dbBands[i] / range);
        }
    }

    double getBand(int i) {
        return this.bands[i].getValue();
    }

    double getAverage(int minBand, int avgBands) {
        int i;
        double avg = 0.0;
        for (i = 0; i < avgBands && minBand + i < this.numBands; ++i) {
            avg += this.getBand(minBand + i);
        }
        return avg / (double)i;
    }
}

