/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXRunnableComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.NormalizedParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;

public class Reaper
extends LXRunnableComponent {
    public static final int MAX_METERS = 32;
    public final Meter master;
    public final Meter[] meters = new Meter[32];
    public final BoundedParameter meterAttack = new BoundedParameter("Attack", 0.0, 0.0, 50.0).setDescription("Sets the attack time of the meter response").setUnits(LXParameter.Units.MILLISECONDS);
    public final BoundedParameter meterRelease = new BoundedParameter("Release", 0.0, 0.0, 500.0).setDescription("Sets the release time of the meter response").setUnits(LXParameter.Units.MILLISECONDS);
    public final TriggerParameter clearMeters = new TriggerParameter("Clear", () -> {
        for (Meter meter : this.meters) {
            meter.target = 0.0f;
        }
    });
    public final EnumParameter<FoldMode> foldMode = new EnumParameter<FoldMode>("Auto-Fold", FoldMode.ACTIVE).setDescription("Which tracks to fold in the UI");
    public final BooleanParameter metersExpanded = new BooleanParameter("Meters Expanded", false).setDescription("Show Reaper meters in the UI");
    public static final String REAPER_OSC_PATH = "reaper";
    public static final String REAPER_MASTER_PATH = "master";
    public static final String REAPER_TRACK_PATH = "track";
    public static final String REAPER_VU_PATH = "vu";

    public Reaper(LX lx) {
        super(lx, "Reaper");
        this.addParameter("meterAttack", this.meterAttack);
        this.addParameter("meterRelease", this.meterRelease);
        this.addParameter("foldMode", this.foldMode);
        this.addInternalParameter("metersExpanded", this.metersExpanded);
        this.master = new Meter(-1);
        for (int i = 0; i < 32; ++i) {
            this.meters[i] = new Meter(i);
        }
    }

    @Override
    public void onStop() {
        this.master.level.setValue(0.0);
        for (Meter meter : this.meters) {
            meter.level.setValue(0.0);
            meter.active.setValue(false);
        }
    }

    @Override
    public void run(double deltaMs) {
        double meterAttack = this.meterAttack.getValue();
        double meterRelease = this.meterRelease.getValue();
        this.master.run(deltaMs, meterAttack, meterRelease);
        for (Meter meter : this.meters) {
            meter.run(deltaMs, meterAttack, meterRelease);
        }
    }

    public boolean handleReaperOscMessage(OscMessage message, String[] parts, int index) {
        if (REAPER_MASTER_PATH.equals(parts[2])) {
            if (REAPER_VU_PATH.equals(parts[3])) {
                this.master.setTarget(message.getFloat());
            }
        } else if (REAPER_TRACK_PATH.equals(parts[2]) && parts.length == 5 && REAPER_VU_PATH.equals(parts[4])) {
            int meterIndex = Integer.parseInt(parts[3]) - 1;
            if (meterIndex < 0 || meterIndex >= 32) {
                LXOscEngine.error("Bad Reaper track meter index: " + message.getAddressPattern());
            } else {
                this.meters[meterIndex].setTarget(message.getFloat());
            }
        }
        return true;
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (obj.has("_reset_")) {
            this.foldMode.reset();
            this.metersExpanded.setValue(false);
            this.stop();
        }
    }

    public class Meter {
        private static final int MASTER = -1;
        public static final int TIMEOUT = 1000;
        private double timeout = 0.0;
        private float target = 0.0f;
        public final String id;
        public final BooleanParameter active;
        public final NormalizedParameter level;

        private Meter(int channel) {
            String description;
            String path;
            String prefix;
            if (channel == -1) {
                this.id = "M";
                prefix = "Master";
                path = Reaper.REAPER_MASTER_PATH;
                description = "Reaper master level";
            } else {
                this.id = String.valueOf(channel + 1);
                prefix = "Meter-" + this.id;
                path = "meter-" + this.id;
                description = "Reaper track " + this.id;
            }
            this.active = new BooleanParameter(prefix + "-Active", false).setDescription(description + " active");
            this.level = new NormalizedParameter(prefix).setDescription(description);
            Reaper.this.addParameter(path, this.level);
            Reaper.this.addParameter(path + "-active", this.active);
        }

        private void run(double deltaMs, double meterAttack, double meterRelease) {
            double value;
            this.timeout += deltaMs;
            if (this.timeout > 1000.0) {
                this.target = 0.0f;
                this.active.setValue(false);
            }
            if ((value = this.level.getValue()) != (double)this.target) {
                double timeFactor;
                double d = timeFactor = (double)this.target > value ? meterAttack : meterRelease;
                if (timeFactor > 0.0) {
                    double gain = Math.exp(-deltaMs / timeFactor);
                    this.level.setValue(LXUtils.lerp(this.target, value, gain));
                } else {
                    this.level.setValue(this.target);
                }
            }
        }

        private void setTarget(float target) {
            this.active.setValue(true);
            this.target = LXUtils.constrainf(target, 0.0f, 1.0f);
            this.timeout = 0.0;
        }
    }

    public static enum FoldMode {
        ALL("All"),
        ACTIVE("Active");

        private final String label;

        private FoldMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

