/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.audio.SoundObject;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXNormalizationBounds;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.transform.LXMatrix;
import heronarts.lx.transform.LXVector;
import heronarts.lx.utils.LXUtils;

public class SoundStage
extends LXComponent
implements LXOscComponent {
    private final LXMatrix rotationMatrix = new LXMatrix();
    private final LXVector basisX = new LXVector();
    private final LXVector basisY = new LXVector();
    private final LXVector basisZ = new LXVector();
    public final LXVector rotation = new LXVector();
    public final LXVector center = new LXVector();
    public final LXVector size = new LXVector();
    public final EnumParameter<StageMode> mode = new EnumParameter<StageMode>("Stage Mode", StageMode.DEFAULT).setDescription("How to specify sound stage dimensions");
    public final BoundedParameter xAbsolute = new BoundedParameter("X", 0.0, -1000000.0, 1000000.0).setDescription("Absolute X position of the sound stage center");
    public final BoundedParameter yAbsolute = new BoundedParameter("Y", 0.0, -1000000.0, 1000000.0).setDescription("Absolute Y position of the sound stage center");
    public final BoundedParameter zAbsolute = new BoundedParameter("Z", 0.0, -1000000.0, 1000000.0).setDescription("Absolute Z position of the sound stage center");
    public final BoundedParameter widthAbsolute = new BoundedParameter("Width", 100.0, 0.0, 1000000.0).setDescription("Absolute width of the sound stage");
    public final BoundedParameter heightAbsolute = new BoundedParameter("Height", 100.0, 0.0, 1000000.0).setDescription("Absolute height of the sound stage");
    public final BoundedParameter depthAbsolute = new BoundedParameter("Depth", 100.0, 0.0, 1000000.0).setDescription("Absolute depth of the sound stage");
    public final BoundedParameter azimuthAbsolute = new BoundedParameter("Azimuth", 0.0, -180.0, 180.0).setUnits(LXParameter.Units.DEGREES).setDescription("Azimuth of the front of the sound stage");
    public final BoundedParameter elevationAbsolute = new BoundedParameter("Elevation", 0.0, -90.0, 90.0).setUnits(LXParameter.Units.DEGREES).setDescription("Elevation of the front of the sound stage");
    public final BoundedParameter xRelative = new BoundedParameter("X", 0.0, -5.0, 5.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Relative X position of the sound stage center");
    public final BoundedParameter yRelative = new BoundedParameter("Y", 0.0, -5.0, 5.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Relative Y position of the sound stage center");
    public final BoundedParameter zRelative = new BoundedParameter("Z", 0.0, -5.0, 5.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Relative Z position of the sound stage center");
    public final BoundedParameter widthRelative = new BoundedParameter("Width", 1.0, 0.0, 5.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Relative width of the sound stage");
    public final BoundedParameter heightRelative = new BoundedParameter("Height", 1.0, 0.0, 5.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Relative height of the sound stage");
    public final BoundedParameter depthRelative = new BoundedParameter("Depth", 1.0, 0.0, 5.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Relative depth of the sound stage");
    public final BoundedParameter azimuthRelative = new BoundedParameter("Azimuth", 0.0, -180.0, 180.0).setUnits(LXParameter.Units.DEGREES).setDescription("Azimuth of the front of the sound stage");
    public final BoundedParameter elevationRelative = new BoundedParameter("Elevation", 0.0, -90.0, 90.0).setUnits(LXParameter.Units.DEGREES).setDescription("Elevation of the front of the sound stage");
    public final BooleanParameter showSoundStage = new BooleanParameter("Show Sound Stage", false).setDescription("Render sound stage in the UI");
    public final BooleanParameter showSoundObjects = new BooleanParameter("Show Sound Objects", true).setDescription("Render sound objects in the UI");
    public final EnumParameter<MeterMode> soundObjectMeterMode = new EnumParameter<MeterMode>("Meter Mode", MeterMode.NONE).setDescription("How to show sound object meters");
    public final BoundedParameter soundObjectSize = new BoundedParameter("Sound Object Size", 10.0, 1.0, 100000.0).setDescription("Size of sound objects");

    public SoundStage(LX lx) {
        super(lx);
        this.addGeometryParameter("mode", this.mode);
        this.addGeometryParameter("xAbsolute", this.xAbsolute);
        this.addGeometryParameter("yAbsolute", this.yAbsolute);
        this.addGeometryParameter("zAbsolute", this.zAbsolute);
        this.addGeometryParameter("widthAbsolute", this.widthAbsolute);
        this.addGeometryParameter("heightAbsolute", this.heightAbsolute);
        this.addGeometryParameter("depthAbsolute", this.depthAbsolute);
        this.addGeometryParameter("azimuthAbsolute", this.azimuthAbsolute);
        this.addGeometryParameter("elevationAbsolute", this.elevationAbsolute);
        this.addGeometryParameter("xRelative", this.xRelative);
        this.addGeometryParameter("yRelative", this.yRelative);
        this.addGeometryParameter("zRelative", this.zRelative);
        this.addGeometryParameter("widthRelative", this.widthRelative);
        this.addGeometryParameter("heightRelative", this.heightRelative);
        this.addGeometryParameter("depthRelative", this.depthRelative);
        this.addGeometryParameter("azimuthRelative", this.azimuthRelative);
        this.addGeometryParameter("elevationRelative", this.elevationRelative);
        this.addParameter("showSoundStage", this.showSoundStage);
        this.addParameter("showSoundObjects", this.showSoundObjects);
        this.addParameter("soundObjectMeterMode", this.soundObjectMeterMode);
        this.addParameter("soundObjectSize", this.soundObjectSize);
        this.recomputeBounds(null);
        lx.addListener(new LX.Listener(){

            @Override
            public void modelChanged(LX lx, LXModel model) {
                SoundStage.this.recomputeBounds(null);
            }

            @Override
            public void modelGenerationChanged(LX lx, LXModel model) {
                SoundStage.this.recomputeBounds(null);
            }
        });
    }

    private void addGeometryParameter(String path, LXListenableParameter p) {
        this.addParameter(path, p);
        p.addListener(this::recomputeBounds);
    }

    private void setRotation(float azimuth, float elevation) {
        this.rotation.set(elevation, azimuth, 0.0f);
        this.rotationMatrix.identity().rotateX((float)Math.toRadians(elevation)).rotateY((float)(-Math.toRadians(azimuth)));
        this.basisX.set(this.rotationMatrix.m11, this.rotationMatrix.m12, this.rotationMatrix.m13);
        this.basisY.set(this.rotationMatrix.m21, this.rotationMatrix.m22, this.rotationMatrix.m23);
        this.basisZ.set(this.rotationMatrix.m31, this.rotationMatrix.m32, this.rotationMatrix.m33);
    }

    private void recomputeBounds(LXParameter p) {
        LXModel model = this.lx.getModel();
        switch (this.mode.getEnum()) {
            case DEFAULT: {
                this.setRotation(0.0f, 0.0f);
                this.center.set(model.cx, model.cy, model.cz);
                this.size.set(model.xRange, model.yRange, model.zRange);
                break;
            }
            case RELATIVE: {
                this.setRotation(this.azimuthRelative.getValuef(), this.elevationRelative.getValuef());
                this.center.set(model.cx + model.xRange * this.xRelative.getValuef(), model.cy + model.yRange * this.yRelative.getValuef(), model.cz + model.zRange * this.zRelative.getValuef());
                this.size.set(model.xRange * this.widthRelative.getValuef(), model.yRange * this.heightRelative.getValuef(), model.zRange * this.depthRelative.getValuef());
                break;
            }
            case ABSOLUTE: {
                this.setRotation(this.azimuthAbsolute.getValuef(), this.elevationAbsolute.getValuef());
                this.center.set(this.xAbsolute.getValuef(), this.yAbsolute.getValuef(), this.zAbsolute.getValuef());
                this.size.set(this.widthAbsolute.getValuef(), this.heightAbsolute.getValuef(), this.depthAbsolute.getValuef());
            }
        }
    }

    public LXVector getNormalizedObjectPosition(SoundObject object) {
        return this.getNormalizedObjectPosition(object, this.lx.getModel());
    }

    public LXVector getNormalizedObjectPosition(SoundObject object, LXModel reference) {
        return this.getNormalizedObjectPosition(object, ObjectPositionMode.ABSOLUTE, reference);
    }

    public LXVector getNormalizedObjectPosition(SoundObject object, ObjectPositionMode mode, LXModel reference) {
        return this.getNormalizedObjectPosition(object, mode, reference, null);
    }

    public LXVector getNormalizedObjectPosition(SoundObject object, ObjectPositionMode mode, LXModel model, LXVector position) {
        if (position == null) {
            position = new LXVector();
        }
        switch (mode) {
            case ABSOLUTE: {
                position.set(-0.5f, -0.5f, -0.5f).add(object.position);
                break;
            }
            case BOX: {
                position.set(object.normalized);
                float scale = LXUtils.maxf(Math.abs(position.x), Math.abs(position.y), Math.abs(position.z));
                position.mult(0.5f / scale);
                break;
            }
            case RADIAL: {
                position.set(object.normalized).mult(0.5f);
                break;
            }
        }
        float xb = position.x;
        float yb = position.y;
        float zb = position.z;
        position.set(this.center).add(this.basisX, xb * this.size.x).add(this.basisY, yb * this.size.y).add(this.basisZ, zb * this.size.z);
        LXNormalizationBounds bounds = model.getNormalizationBounds();
        position.set(bounds.xRange == 0.0f ? 0.5f : LXUtils.ilerpf(position.x, bounds.xMin, bounds.xMax), bounds.yRange == 0.0f ? 0.5f : LXUtils.ilerpf(position.y, bounds.yMin, bounds.yMax), bounds.zRange == 0.0f ? 0.5f : LXUtils.ilerpf(position.z, bounds.zMin, bounds.zMax));
        return position;
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        if (obj.has("_reset_")) {
            for (LXParameter p : this.getParameters()) {
                p.reset();
            }
        }
        super.load(lx, obj);
    }

    public static enum StageMode {
        DEFAULT("Default"),
        RELATIVE("Relative"),
        ABSOLUTE("Absolute");

        public final String label;

        private StageMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum MeterMode {
        NONE("None"),
        OBJECT_SIZE("Size"),
        METER("Meter");

        public final String label;

        private MeterMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum ObjectPositionMode {
        ABSOLUTE("Abs"),
        RADIAL("Radial"),
        BOX("Box");

        public final String label;

        private ObjectPositionMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

