/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.blend;

import heronarts.lx.LX;
import heronarts.lx.LXBuffer;
import heronarts.lx.LXComponent;
import heronarts.lx.LXModulatorComponent;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;

public abstract class LXBlend
extends LXModulatorComponent {
    private String name = LXComponent.getComponentName(this, "Blend");

    protected LXBlend(LX lx) {
        super(lx);
    }

    public LXBlend setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void blend(int[] dst, int[] src, double alpha, LXBuffer buffer, LXModel model) {
        this.blend(dst, src, alpha, buffer.getArray(), model);
    }

    public abstract void blend(int[] var1, int[] var2, double var3, int[] var5, LXModel var6);

    public void lerp(int[] from, int[] to, double amt, int[] output, LXModel model) {
        double alpha;
        int[] src;
        int[] dst;
        if (amt <= 0.5) {
            dst = from;
            src = to;
            alpha = amt * 2.0;
        } else {
            dst = to;
            src = from;
            alpha = (1.0 - amt) * 2.0;
        }
        this.blend(dst, src, alpha, output, model);
    }

    public void onActive() {
    }

    public void onInactive() {
    }

    public static class FunctionalBlend
    extends LXBlend {
        private final BlendFunction function;

        public FunctionalBlend(LX lx, BlendFunction function) {
            super(lx);
            this.function = function;
        }

        @Override
        public void blend(int[] dst, int[] src, double alpha, int[] output, LXModel model) {
            int alphaMask = (int)(alpha * 256.0);
            for (LXPoint p : model.points) {
                output[p.index] = this.function.apply(dst[p.index], src[p.index], alphaMask);
            }
        }

        public static interface BlendFunction {
            public int apply(int var1, int var2, int var3);
        }
    }
}

