/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.clip.LXAbstractChannelClip;
import heronarts.lx.clip.LXClipLane;
import heronarts.lx.clip.PatternClipEvent;
import heronarts.lx.clip.PatternClipLane;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.pattern.LXPattern;

public class LXChannelClip
extends LXAbstractChannelClip
implements LXChannel.Listener {
    public final LXChannel channel;
    public final PatternClipLane patternLane;

    public LXChannelClip(LX lx, LXChannel channel, int index) {
        super(lx, channel, index, false);
        this.channel = channel;
        this.patternLane = new PatternClipLane(this);
        this.mutableLanes.add(this.patternLane);
        channel.addListener(this);
        for (LXPattern pattern : channel.patterns) {
            this.registerComponent(pattern);
        }
    }

    @Override
    public void dispose() {
        this.channel.removeListener(this);
        for (LXPattern pattern : this.channel.patterns) {
            this.unregisterComponent(pattern);
        }
        super.dispose();
    }

    @Override
    protected void onStartRecording() {
        LXPattern activePattern;
        if (this.channel.compositeMode.getEnum() == LXChannel.CompositeMode.PLAYLIST && (activePattern = this.channel.getActivePattern()) != null) {
            this.patternLane.appendEvent(new PatternClipEvent((LXClipLane)this.patternLane, this.channel, activePattern));
        }
    }

    @Override
    public void indexChanged(LXAbstractChannel channel) {
    }

    @Override
    public void groupChanged(LXChannel channel, LXGroup group) {
    }

    @Override
    public void patternAdded(LXChannel channel, LXPattern pattern) {
        this.registerComponent(pattern);
    }

    @Override
    public void patternRemoved(LXChannel channel, LXPattern pattern) {
        this.unregisterComponent(pattern);
    }

    @Override
    public void patternMoved(LXChannel channel, LXPattern pattern) {
    }

    @Override
    public void patternWillChange(LXChannel channel, LXPattern pattern, LXPattern nextPattern) {
        if (this.isRunning() && this.bus.arm.isOn()) {
            this.patternLane.appendEvent(new PatternClipEvent((LXClipLane)this.patternLane, channel, nextPattern));
        }
    }

    @Override
    public void patternDidChange(LXChannel channel, LXPattern pattern) {
    }

    @Override
    protected void loadLane(LX lx, String laneType, JsonObject laneObj) {
        if (laneType.equals("pattern")) {
            this.patternLane.load(lx, laneObj);
        } else if (laneType.equals("midiNote")) {
            this.midiNoteLane.load(lx, laneObj);
        } else {
            super.loadLane(lx, laneType, laneObj);
        }
    }
}

