/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.clip.LXClip;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.parameter.TriggerParameter;

public class LXClipEngine
extends LXComponent
implements LXOscComponent {
    public static final int MIN_SCENES = 5;
    public static final int MAX_SCENES = 128;
    private final TriggerParameter[] scenes = new TriggerParameter[128];
    public final FocusedClipParameter focusedClip = new FocusedClipParameter();
    public final BooleanParameter clipViewExpanded = new BooleanParameter("Clip View", false).setDescription("Whether the clip grid view is expanded");
    public final DiscreteParameter clipViewGridOffset = new DiscreteParameter("Clip View Grid Offset", 0, 1).setDescription("Offset of the clip grid view");
    public final DiscreteParameter numScenes = new DiscreteParameter("Num Scenes", 5, 129).setDescription("Number of active scenes");
    public final BoundedParameter snapshotTransitionTimeSecs = new BoundedParameter("Snapshot Transition Time", 5.0, 0.1, 180.0).setDescription("Sets the duration of interpolated transitions between clip snapshots").setUnits(LXParameter.Units.SECONDS);
    public final BooleanParameter snapshotTransitionEnabled = new BooleanParameter("Snapshot Transitions", false).setDescription("When enabled, transitions between clip snapshots use interpolation");

    public LXClipEngine(LX lx) {
        super(lx);
        this.addParameter("focusedClip", this.focusedClip);
        this.addParameter("numScenes", this.numScenes);
        this.addParameter("snapshotTransitionEnabled", this.snapshotTransitionEnabled);
        this.addParameter("snapshotTransitionTimeSecs", this.snapshotTransitionTimeSecs);
        this.addParameter("clipViewGridOffset", this.clipViewGridOffset);
        this.addParameter("clipViewExpanded", this.clipViewExpanded);
        for (int i = 0; i < this.scenes.length; ++i) {
            int sceneIndex = i;
            this.scenes[i] = new TriggerParameter("Scene-" + (i + 1), () -> this.launchScene(sceneIndex)).setDescription("Launches scene " + (i + 1));
            this.addParameter("scene-" + (i + 1), this.scenes[i]);
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (this.numScenes == p) {
            this.clipViewGridOffset.setRange(this.numScenes.getValuei() - 5 + 1);
        }
    }

    public LXClip getFocusedClip() {
        return this.focusedClip.getClip();
    }

    public LXClipEngine setFocusedClip(LXClip clip) {
        this.focusedClip.setClip(clip);
        return this;
    }

    public TriggerParameter getScene(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Cannot request scene less than 0: " + index);
        }
        return this.scenes[index];
    }

    public LXClipEngine launchScene(int index) {
        LXClip clip;
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            clip = channel.getClip(index);
            if (clip == null) continue;
            clip.trigger();
        }
        clip = this.lx.engine.mixer.masterBus.getClip(index);
        if (clip != null) {
            clip.trigger();
        }
        return this;
    }

    public LXClipEngine stopClips() {
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            for (LXClip clip : channel.clips) {
                if (clip == null) continue;
                clip.stop();
            }
        }
        for (LXClip clip : this.lx.engine.mixer.masterBus.clips) {
            if (clip == null) continue;
            clip.stop();
        }
        return this;
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (obj.has("_reset_")) {
            this.clipViewGridOffset.reset();
            this.numScenes.reset();
        }
    }

    public class FocusedClipParameter
    extends MutableParameter {
        private LXClip clip;

        private FocusedClipParameter() {
            super("Focused Clip");
            this.clip = null;
            this.setDescription("Parameter which indicate the globally focused clip");
        }

        public FocusedClipParameter setClip(LXClip clip) {
            if (this.clip != clip) {
                this.clip = clip;
                this.bang();
            }
            return this;
        }

        public LXClip getClip() {
            return this.clip;
        }
    }
}

