/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.LXClipLane;
import java.util.Comparator;

public abstract class LXClipEvent
implements Comparator<LXClipEvent>,
LXSerializable {
    protected final LXClipLane lane;
    protected final LXComponent component;
    protected double cursor;
    protected static final String KEY_CURSOR = "cursor";

    LXClipEvent(LXClipLane lane) {
        this(lane, lane.clip.cursor, null);
    }

    LXClipEvent(LXClipLane lane, LXComponent component) {
        this(lane, lane.clip.cursor, component);
    }

    LXClipEvent(LXClipLane lane, double cursor) {
        this(lane, cursor, null);
    }

    LXClipEvent(LXClipLane lane, double cursor, LXComponent component) {
        this.lane = lane;
        this.cursor = cursor;
        this.component = component;
    }

    public double getCursor() {
        return this.cursor;
    }

    LXClipEvent setCursor(double cursor) {
        this.cursor = cursor;
        return this;
    }

    public double getBasis() {
        return this.cursor / this.lane.clip.length.getValue();
    }

    @Override
    public int compare(LXClipEvent arg0, LXClipEvent arg1) {
        if (arg0.cursor < arg1.cursor) {
            return -1;
        }
        if (arg0.cursor > arg1.cursor) {
            return 1;
        }
        return 0;
    }

    public abstract void execute();

    @Override
    public void load(LX lx, JsonObject obj) {
        if (obj.has(KEY_CURSOR)) {
            this.cursor = obj.get(KEY_CURSOR).getAsDouble();
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        obj.addProperty(KEY_CURSOR, (Number)this.cursor);
    }
}

