/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.MidiNoteClipLane;
import heronarts.lx.clip.ParameterClipLane;
import heronarts.lx.clip.PatternClipLane;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.utils.LXUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class LXClipLane
implements LXSerializable {
    public final MutableParameter onChange = new MutableParameter();
    public final LXClip clip;
    protected final List<LXClipEvent> mutableEvents = new CopyOnWriteArrayList<LXClipEvent>();
    public final List<LXClipEvent> events = Collections.unmodifiableList(this.mutableEvents);
    private static final String KEY_EVENTS = "events";
    protected static final String KEY_LANE_TYPE = "laneType";
    protected static final String VALUE_LANE_TYPE_PARAMETER = "parameter";
    protected static final String VALUE_LANE_TYPE_PATTERN = "pattern";
    protected static final String VALUE_LANE_TYPE_MIDI_NOTE = "midiNote";

    protected LXClipLane(LXClip clip) {
        this.clip = clip;
    }

    protected LXClipLane appendEvent(LXClipEvent event) {
        this.mutableEvents.add(event);
        this.onChange.bang();
        return this;
    }

    protected LXClipLane insertEvent(LXClipEvent event) {
        int index;
        for (index = 0; index < this.events.size() && !(event.cursor < this.events.get((int)index).cursor); ++index) {
        }
        this.mutableEvents.add(index, event);
        this.onChange.bang();
        return this;
    }

    public LXClipLane moveEvent(LXClipEvent event, double basis) {
        double newCursor;
        double clipLength = this.clip.getLength();
        double min = 0.0;
        double max = clipLength;
        int index = this.events.indexOf(event);
        if (index > 0) {
            min = this.events.get((int)(index - 1)).cursor;
        }
        if (index < this.events.size() - 1) {
            max = this.events.get((int)(index + 1)).cursor;
        }
        if (event.cursor != (newCursor = LXUtils.constrain(basis * clipLength, min, max))) {
            event.cursor = newCursor;
            this.onChange.bang();
        }
        return this;
    }

    public abstract String getLabel();

    void advanceCursor(double from, double to) {
        for (LXClipEvent event : this.mutableEvents) {
            if (!(from <= event.cursor) || !(event.cursor < to)) continue;
            event.execute();
        }
    }

    public LXClipLane clearSelection(double fromBasis, double toBasis) {
        double from = fromBasis * this.clip.length.getValue();
        double to = toBasis * this.clip.length.getValue();
        int i = 0;
        boolean removed = false;
        while (i < this.mutableEvents.size()) {
            LXClipEvent event = this.mutableEvents.get(i);
            if (from <= event.cursor) {
                if (event.cursor > to) break;
                removed = true;
                this.mutableEvents.remove(i);
                continue;
            }
            ++i;
        }
        if (removed) {
            this.onChange.bang();
        }
        return this;
    }

    public LXClipLane removeEvent(LXClipEvent event) {
        this.mutableEvents.remove(event);
        this.onChange.bang();
        return this;
    }

    void clear() {
        this.mutableEvents.clear();
        this.onChange.bang();
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.mutableEvents.clear();
        if (obj.has(KEY_EVENTS)) {
            JsonArray eventsArr = obj.get(KEY_EVENTS).getAsJsonArray();
            for (JsonElement eventElem : eventsArr) {
                JsonObject eventObj = eventElem.getAsJsonObject();
                LXClipEvent event = this.loadEvent(lx, eventObj);
                if (event == null) continue;
                event.load(lx, eventObj);
                this.mutableEvents.add(event);
            }
        }
        this.onChange.bang();
    }

    protected abstract LXClipEvent loadEvent(LX var1, JsonObject var2);

    @Override
    public void save(LX lx, JsonObject obj) {
        if (this instanceof ParameterClipLane) {
            obj.addProperty(KEY_LANE_TYPE, VALUE_LANE_TYPE_PARAMETER);
        } else if (this instanceof PatternClipLane) {
            obj.addProperty(KEY_LANE_TYPE, VALUE_LANE_TYPE_PATTERN);
        } else if (this instanceof MidiNoteClipLane) {
            obj.addProperty(KEY_LANE_TYPE, VALUE_LANE_TYPE_MIDI_NOTE);
        }
        obj.add(KEY_EVENTS, (JsonElement)LXSerializable.Utils.toArray(lx, this.events));
    }
}

