/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.LXClipLane;
import heronarts.lx.clip.MidiNoteClipEvent;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiNote;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public class MidiNoteClipLane
extends LXClipLane {
    protected MidiNoteClipLane(LXClip clip) {
        super(clip);
    }

    @Override
    public String getLabel() {
        return "MIDI Note";
    }

    @Override
    protected LXClipEvent loadEvent(LX lx, JsonObject eventObj) {
        int channel = eventObj.get("channel").getAsInt();
        int command = eventObj.get("command").getAsInt();
        int data1 = eventObj.get("data1").getAsInt();
        int data2 = eventObj.get("data2").getAsInt();
        try {
            ShortMessage sm = new ShortMessage();
            sm.setMessage(command, channel, data1, data2);
            return new MidiNoteClipEvent((LXClipLane)this, (MidiNote)LXShortMessage.fromShortMessage(sm));
        }
        catch (InvalidMidiDataException imdx) {
            LX.error(imdx, "Invalid MIDI in clip event: " + channel + " " + command + " " + data1 + " " + data2);
            return null;
        }
    }

    protected void appendNote(MidiNote note) {
        super.appendEvent(new MidiNoteClipEvent((LXClipLane)this, note));
    }
}

