/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.LXClipLane;
import heronarts.lx.clip.ParameterClipEvent;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.utils.LXUtils;

public class ParameterClipLane
extends LXClipLane {
    public final LXNormalizedParameter parameter;

    ParameterClipLane(LXClip clip, LXNormalizedParameter parameter) {
        super(clip);
        this.parameter = parameter;
    }

    @Override
    public String getLabel() {
        LXComponent component = this.parameter.getParent();
        if (component != this.clip.bus) {
            return component.getLabel() + " | " + this.parameter.getLabel();
        }
        return this.parameter.getLabel();
    }

    public ParameterClipLane appendEvent(ParameterClipEvent event) {
        super.appendEvent(event);
        return this;
    }

    public ParameterClipLane insertEvent(double basis, double normalized) {
        super.insertEvent(new ParameterClipEvent((LXClipLane)this, this.parameter, normalized).setCursor(basis * this.clip.length.getValue()));
        return this;
    }

    @Override
    void advanceCursor(double from, double to) {
        if (this.events.size() == 0) {
            return;
        }
        LXClipEvent prior = null;
        LXClipEvent next = null;
        for (LXClipEvent event : this.events) {
            prior = next;
            next = event;
            if (!(to < next.cursor)) continue;
            break;
        }
        if (!(from > next.cursor)) {
            if (prior == null) {
                this.parameter.setNormalized(((ParameterClipEvent)next).getNormalized());
            } else if (to > next.cursor) {
                this.parameter.setNormalized(((ParameterClipEvent)next).getNormalized());
            } else {
                this.parameter.setNormalized(LXUtils.lerp(((ParameterClipEvent)prior).getNormalized(), ((ParameterClipEvent)next).getNormalized(), (to - prior.cursor) / (next.cursor - prior.cursor)));
            }
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.addProperty("path", this.parameter.getCanonicalPath(this.clip.bus));
        obj.addProperty("componentId", (Number)this.parameter.getParent().getId());
        obj.addProperty("parameterPath", this.parameter.getPath());
    }

    @Override
    protected LXClipEvent loadEvent(LX lx, JsonObject eventObj) {
        double normalized = eventObj.get("normalized").getAsDouble();
        return new ParameterClipEvent((LXClipLane)this, this.parameter, normalized);
    }
}

