/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.color;

import heronarts.lx.LXModulatorComponent;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.GradientUtils;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXSwatch;
import heronarts.lx.modulator.SawLFO;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

public class LXDynamicColor
extends LXModulatorComponent
implements LXOscComponent {
    private static final int DEFAULT_COLOR = -65536;
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.FIXED).setDescription("The mode of this color");
    public final EnumParameter<GradientUtils.BlendMode> blendMode = new EnumParameter<GradientUtils.BlendMode>("Blend", GradientUtils.BlendMode.RGB).setDescription("The blend mode when in oscillation");
    public final BoundedParameter period = new BoundedParameter("Period", 30.0, 1.0, 3600.0).setUnits(LXParameter.Units.SECONDS).setDescription("The period of oscillation or rotation in this color");
    public final ColorParameter primary = new ColorParameter("Color", -65536).setDescription("The base color setting");
    public final ColorParameter secondary = new ColorParameter("Secondary", -16711936).setDescription("The secondary color setting");
    public final ColorParameter color = this.primary;
    private final SawLFO basis = this.startModulator(new SawLFO(0.0, 1.0, (LXParameter)new FunctionalParameter(){

        @Override
        public double getValue() {
            return LXDynamicColor.this.period.getValue() * 1000.0;
        }
    }));
    private int index = 0;

    public LXDynamicColor(LXSwatch swatch) {
        this(swatch, -65536);
    }

    protected LXDynamicColor(LXSwatch swatch, int initialColor) {
        super(swatch.getLX());
        this.setParent(swatch);
        this.addParameter("mode", this.mode);
        this.addParameter("period", this.period);
        this.addParameter("primary", this.color.setColor(initialColor));
        this.addParameter("secondary", this.secondary);
    }

    public LXSwatch getSwatch() {
        return (LXSwatch)this.getParent();
    }

    @Override
    public String getPath() {
        return "color/" + (this.index + 1);
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public double getBasis() {
        switch (this.mode.getEnum()) {
            case OSCILLATE: {
                return 1.0 - 2.0 * Math.abs(this.basis.getValue() - 0.5);
            }
            case CYCLE: {
                return this.basis.getValue();
            }
        }
        return 0.0;
    }

    void trigger() {
        this.basis.trigger();
    }

    public double getHue() {
        switch (this.mode.getEnum()) {
            case OSCILLATE: {
                GradientUtils.BlendMode blendMode = this.blendMode.getEnum();
                switch (blendMode) {
                    case HSV: 
                    case HSVM: 
                    case HSVCW: 
                    case HSVCCW: {
                        float hue1 = this.primary.hue.getValuef();
                        float hue2 = this.secondary.hue.getValuef();
                        if (this.primary.isBlack()) {
                            return hue2;
                        }
                        if (this.secondary.isBlack()) {
                            return hue1;
                        }
                        return blendMode.hueInterpolation.lerp(hue1, hue2, (float)this.getBasis());
                    }
                }
                int c = this.getColor();
                float b = LXColor.b(c);
                if (b > 0.0f) {
                    return LXColor.h(c);
                }
                if (this.getBasis() > 0.5) {
                    return this.secondary.hue.getValuef();
                }
                return this.primary.hue.getValuef();
            }
            case CYCLE: {
                return this.color.hue.getValue() + this.basis.getValue() * 360.0;
            }
        }
        return this.color.hue.getValue();
    }

    public float getHuef() {
        return (float)this.getHue();
    }

    public float getSaturation() {
        switch (this.mode.getEnum()) {
            case OSCILLATE: {
                switch (this.blendMode.getEnum()) {
                    case HSV: 
                    case HSVM: 
                    case HSVCW: 
                    case HSVCCW: {
                        double sat1 = this.primary.saturation.getValue();
                        double sat2 = this.secondary.saturation.getValue();
                        if (this.primary.isBlack()) {
                            return (float)sat2;
                        }
                        if (this.secondary.isBlack()) {
                            return (float)sat1;
                        }
                        return (float)LXUtils.lerp(sat1, sat2, this.getBasis());
                    }
                }
                int c = this.getColor();
                float b = LXColor.b(c);
                if (b > 0.0f) {
                    return LXColor.s(c);
                }
                if (this.getBasis() > 0.5) {
                    return this.secondary.saturation.getValuef();
                }
                return this.primary.saturation.getValuef();
            }
            case CYCLE: {
                return this.color.saturation.getValuef();
            }
        }
        return this.color.saturation.getValuef();
    }

    public float getBrightness() {
        return LXColor.b(this.getColor());
    }

    public int getColor() {
        switch (this.mode.getEnum()) {
            case OSCILLATE: {
                return this.blendMode.getEnum().function.blend(this.primary, this.secondary, (float)this.getBasis());
            }
            case CYCLE: {
                return LXColor.hsb(this.color.hue.getValue() + this.basis.getValue() * 360.0, this.color.saturation.getValue(), this.color.brightness.getValue());
            }
        }
        return this.color.getColor();
    }

    public static enum Mode {
        FIXED("Fixed"),
        OSCILLATE("Osc"),
        CYCLE("Cycle");

        public final String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

