/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.color;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXLoopTask;
import heronarts.lx.LXSerializable;
import heronarts.lx.color.GradientUtils;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXSwatch;
import heronarts.lx.modulator.LinearEnvelope;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LXPalette
extends LXComponent
implements LXLoopTask,
LXOscComponent {
    private static final int NO_SWATCH_INDEX = -1;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<LXSwatch> mutableSwatches = new ArrayList<LXSwatch>();
    public final List<LXSwatch> swatches = Collections.unmodifiableList(this.mutableSwatches);
    public final LXSwatch swatch;
    public final LXDynamicColor color;
    public final BooleanParameter autoCycleEnabled = new BooleanParameter("Auto-Cycle", false).setDescription("When enabled, the engine will automatically cycle through color swatches");
    public final EnumParameter<AutoCycleMode> autoCycleMode = new EnumParameter<AutoCycleMode>("Auto-Cycle Mode", AutoCycleMode.NEXT).setDescription("Mode of auto cycling");
    public final BoundedParameter autoCycleTimeSecs = new BoundedParameter("Cycle Time", 60.0, 0.1, 14400.0).setDescription("Sets the number of seconds after which the engine cycles to the next snapshot").setUnits(LXParameter.Units.SECONDS);
    private double autoCycleProgress = 0.0;
    public final DiscreteParameter autoCycleCursor = new DiscreteParameter("Auto-Cycle", -1, -1, 0).setDescription("Index for the auto-cycle parameter");
    public final TriggerParameter triggerSwatchCycle = new TriggerParameter("Trigger Cycle", this::onTriggerSwatchCycle).setDescription("Triggers a swatch change");
    public final BoundedParameter transitionTimeSecs = new BoundedParameter("Transition Time", 5.0, 0.1, 180.0).setDescription("Sets the duration of interpolated transitions between color palettes").setUnits(LXParameter.Units.SECONDS);
    public final BooleanParameter transitionEnabled = new BooleanParameter("Transitions", false).setDescription("When enabled, transitions between color palettes use interpolation");
    public final EnumParameter<GradientUtils.BlendMode> transitionMode = new EnumParameter<GradientUtils.BlendMode>("Transition Mode", GradientUtils.BlendMode.RGB).setDescription("Which color blending mode transitions should use.");
    public final BooleanParameter expandedPerformance = new BooleanParameter("Enabled", true).setDescription("Whether the palette pane is expanded in performance mode");
    public final StringParameter label1 = new StringParameter("Label 1", "1").setDescription("Label for Palette Color 1");
    public final StringParameter label2 = new StringParameter("Label 2", "2").setDescription("Label for Palette Color 2");
    public final StringParameter label3 = new StringParameter("Label 3", "3").setDescription("Label for Palette Color 3");
    public final StringParameter label4 = new StringParameter("Label 4", "4").setDescription("Label for Palette Color 4");
    public final StringParameter label5 = new StringParameter("Label 5", "5").setDescription("Label for Palette Color 5");
    public final StringParameter[] labels = new StringParameter[]{this.label1, this.label2, this.label3, this.label4, this.label5};
    private LXSwatch inTransition = null;
    private LXSwatch transitionFrom = null;
    private LXSwatch transitionTo = null;
    private JsonObject transitionTarget = null;
    private LinearEnvelope transition = new LinearEnvelope(0.0, 1.0, (LXParameter)new FunctionalParameter(){

        @Override
        public double getValue() {
            return 1000.0 * LXPalette.this.transitionTimeSecs.getValue();
        }
    });
    private static final List<IndexSelector> selectors = new ArrayList<IndexSelector>();
    private static final String[] selectorOptions = new String[]{"1", "2", "3", "4", "5"};
    private static final String KEY_SWATCHES = "swatches";

    public LXPalette(LX lx) {
        super(lx, "Color Palette");
        this.swatch = new LXSwatch(this, false);
        this.addChild("swatch", this.swatch);
        this.addArray(KEY_SWATCHES, this.swatches);
        this.addParameter("transitionEnabled", this.transitionEnabled);
        this.addParameter("transitionTimeSecs", this.transitionTimeSecs);
        this.addParameter("transitionMode", this.transitionMode);
        this.addParameter("autoCycleEnabled", this.autoCycleEnabled);
        this.addParameter("autoCycleMode", this.autoCycleMode);
        this.addParameter("autoCycleTimeSecs", this.autoCycleTimeSecs);
        this.addParameter("autoCycleCursor", this.autoCycleCursor);
        this.addParameter("triggerSwatchCycle", this.triggerSwatchCycle);
        this.addParameter("expandedPerformance", this.expandedPerformance);
        this.addParameter("label1", this.label1);
        this.addParameter("label2", this.label2);
        this.addParameter("label3", this.label3);
        this.addParameter("label4", this.label4);
        this.addParameter("label5", this.label5);
        this.color = this.swatch.colors.get(0);
    }

    private void updateSelectors() {
        int i = 0;
        for (StringParameter label : this.labels) {
            String option = label.getString();
            LXPalette.selectorOptions[i] = option.isEmpty() ? String.valueOf(i + 1) : option;
            ++i;
        }
        for (IndexSelector selector : selectors) {
            selector.optionsChanged.bang();
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.autoCycleEnabled) {
            this.autoCycleProgress = 0.0;
        } else if (p == this.transitionEnabled) {
            if (!this.transitionEnabled.isOn()) {
                this.finishTransition();
            }
        } else if (p == this.label1 || p == this.label2 || p == this.label3 || p == this.label4 || p == this.label5) {
            this.updateSelectors();
        }
    }

    private void onTriggerSwatchCycle() {
        if (this.transitionTarget != null) {
            this.finishTransition();
        } else {
            this.doSwatchCycle();
        }
    }

    public int getColor() {
        return this.color.getColor();
    }

    public LXDynamicColor getSwatchColor(int index) {
        return this.swatch.getColor(index);
    }

    public float getHuef() {
        return this.color.getHuef();
    }

    public double getHue() {
        return this.color.getHue();
    }

    public float getSaturationf() {
        return (float)this.getSaturation();
    }

    public double getSaturation() {
        return LXColor.s(this.getColor());
    }

    public float getBrightnessf() {
        return (float)this.getBrightness();
    }

    public double getBrightness() {
        return LXColor.b(this.getColor());
    }

    private void _reindexSwatches() {
        int i = 0;
        for (LXSwatch swatch : this.swatches) {
            swatch.setIndex(i++);
        }
    }

    private JsonObject toJsonSwatch(LXSwatch swatch) {
        JsonObject obj = LXSerializable.Utils.toObject(this.lx, swatch, true);
        LXSerializable.Utils.stripParameter(obj, "recall");
        return obj;
    }

    public LXSwatch saveSwatch() {
        LXSwatch saved = new LXSwatch(this, true);
        saved.load(this.lx, this.toJsonSwatch(this.swatch));
        saved.label.setValue("Swatch-" + (this.swatches.size() + 1));
        return this.addSwatch(saved, -1);
    }

    public LXSwatch addSwatch(JsonObject swatchObj, int index) {
        LXSwatch saved = new LXSwatch(this, true);
        saved.load(this.getLX(), swatchObj);
        return this.addSwatch(saved, index);
    }

    private LXSwatch addSwatch(LXSwatch swatch, int index) {
        if (index < 0) {
            this.mutableSwatches.add(swatch);
        } else {
            this.mutableSwatches.add(index, swatch);
        }
        this._reindexSwatches();
        this.autoCycleCursor.setRange(-1, this.swatches.size());
        if (index >= 0 && index <= this.autoCycleCursor.getValuei()) {
            this.autoCycleCursor.increment();
        }
        for (Listener listener : this.listeners) {
            listener.swatchAdded(this, swatch);
        }
        return swatch;
    }

    public LXPalette removeSwatch(LXSwatch swatch) {
        if (!this.swatches.contains(swatch)) {
            throw new IllegalStateException("Cannot remove swatch not in palette: " + swatch);
        }
        int index = this.mutableSwatches.indexOf(swatch);
        this.mutableSwatches.remove(swatch);
        this._reindexSwatches();
        for (Listener listener : this.listeners) {
            listener.swatchRemoved(this, swatch);
        }
        if (index <= this.autoCycleCursor.getValuei()) {
            this.autoCycleCursor.decrement();
        }
        this.autoCycleCursor.setRange(-1, this.swatches.size());
        swatch.dispose();
        return this;
    }

    public boolean setSwatch(LXSwatch swatch) {
        if (this.inTransition == swatch) {
            this.finishTransition();
            return false;
        }
        JsonObject swatchObj = this.toJsonSwatch(swatch);
        this.autoCycleCursor.setValue(swatch.getIndex());
        this.autoCycleProgress = 0.0;
        if (this.transitionEnabled.isOn()) {
            this.inTransition = swatch;
            this.transitionFrom = LXSwatch.staticCopy(this.swatch);
            this.transitionTo = LXSwatch.staticCopy(swatch);
            this.transitionTarget = swatchObj;
            this.transition.trigger();
            for (LXDynamicColor color : this.swatch.colors) {
                int colorNow = color.getColor();
                color.mode.setValue((Object)LXDynamicColor.Mode.FIXED);
                color.primary.setColor(colorNow);
            }
            int nColors = Math.max(this.transitionFrom.colors.size(), this.transitionTo.colors.size());
            while (this.swatch.colors.size() < nColors) {
                this.swatch.addColor();
            }
            while (this.swatch.colors.size() > nColors) {
                this.swatch.removeColor();
            }
        } else {
            this.swatch.load(this.lx, swatchObj);
        }
        return true;
    }

    public double getTransitionProgress() {
        return this.transitionTarget != null ? this.transition.getValue() : 0.0;
    }

    public double getAutoCycleProgress() {
        return this.autoCycleProgress;
    }

    private void finishTransition() {
        if (this.transitionTarget != null) {
            this.swatch.load(this.lx, this.transitionTarget);
            this.inTransition = null;
            this.transitionFrom = null;
            this.transitionTo = null;
            this.transitionTarget = null;
        }
    }

    @Override
    public void loop(double deltaMs) {
        if (this.transitionTarget != null) {
            this.transition.loop(deltaMs);
            if (this.transition.finished()) {
                this.finishTransition();
            } else {
                float lerp = this.transition.getBasisf();
                int i = 0;
                for (LXDynamicColor color : this.swatch.colors) {
                    this._transitionColor(color, i++, lerp);
                }
            }
            this.autoCycleProgress = 0.0;
        } else {
            this.swatch.loop(deltaMs);
            if (this.autoCycleEnabled.isOn()) {
                this.autoCycleProgress += deltaMs / (1000.0 * this.autoCycleTimeSecs.getValue());
                if (this.autoCycleProgress >= 1.0) {
                    this.autoCycleProgress = 0.0;
                    this.doSwatchCycle();
                }
            }
        }
    }

    private void doSwatchCycle() {
        switch (this.autoCycleMode.getEnum()) {
            case NEXT: {
                this.goNextSwatch();
                break;
            }
            case RANDOM: {
                this.goRandomSwatch();
            }
        }
    }

    private void goNextSwatch() {
        if (this.swatches.size() <= 1) {
            return;
        }
        int startIndex = this.autoCycleCursor.getValuei();
        int nextIndex = (startIndex + 1) % this.swatches.size();
        while (nextIndex != startIndex) {
            if (startIndex < 0) {
                startIndex = 0;
            }
            LXSwatch next = this.swatches.get(nextIndex);
            if (next.autoCycleEligible.isOn()) {
                this.setSwatch(next);
                return;
            }
            nextIndex = (nextIndex + 1) % this.swatches.size();
        }
    }

    private void goRandomSwatch() {
        if (this.swatches.size() <= 1) {
            return;
        }
        ArrayList<LXSwatch> eligible = new ArrayList<LXSwatch>();
        int autoIndex = this.autoCycleCursor.getValuei();
        for (int i = 0; i < this.swatches.size(); ++i) {
            if (i == autoIndex) continue;
            LXSwatch test = this.swatches.get(i);
            if (!test.autoCycleEligible.isOn()) continue;
            eligible.add(test);
        }
        int numEligible = eligible.size();
        if (numEligible > 0) {
            LXSwatch random = (LXSwatch)eligible.get(LXUtils.constrain((int)LXUtils.random(0.0, numEligible), 0, numEligible - 1));
            this.setSwatch(random);
        }
    }

    private void _transitionColor(LXDynamicColor color, int i, float lerp) {
        color.primary.setColor(this.transitionMode.getEnum().function.blend(this.transitionFrom.getColor((int)i).primary, this.transitionTo.getColor((int)i).primary, lerp));
    }

    public LXPalette moveSwatch(LXSwatch swatch, int index) {
        if (index < 0 || index >= this.mutableSwatches.size()) {
            throw new IllegalArgumentException("Cannot move swatch to invalid index: " + index);
        }
        LXSwatch autoCycleSwatch = null;
        int auto = this.autoCycleCursor.getValuei();
        if (auto >= 0 && auto < this.swatches.size()) {
            autoCycleSwatch = this.swatches.get(auto);
        }
        this.mutableSwatches.remove(swatch);
        this.mutableSwatches.add(index, swatch);
        this._reindexSwatches();
        for (Listener listener : this.listeners) {
            listener.swatchMoved(this, swatch);
        }
        if (autoCycleSwatch != null) {
            this.autoCycleCursor.setValue(this.swatches.indexOf(autoCycleSwatch));
        }
        return this;
    }

    public LXPalette addListener(Listener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXPalette.Listener: " + listener);
        }
        this.listeners.add(listener);
        return this;
    }

    public LXPalette removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LXPalette.Listener: " + listener);
        }
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        if (path.equals(KEY_SWATCHES) && parts.length > index + 1) {
            path = parts[index + 1];
            for (LXSwatch swatch : this.swatches) {
                if (!path.equals(swatch.getOscLabel())) continue;
                return swatch.handleOscMessage(message, parts, index + 2);
            }
        }
        return super.handleOscMessage(message, parts, index);
    }

    @Override
    public void dispose() {
        for (LXSwatch swatch : this.swatches) {
            swatch.dispose();
        }
        this.mutableSwatches.clear();
        this.swatch.dispose();
        super.dispose();
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_SWATCHES, (JsonElement)LXSerializable.Utils.toArray(lx, this.swatches));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.finishTransition();
        while (!this.swatches.isEmpty()) {
            this.removeSwatch(this.swatches.get(this.swatches.size() - 1));
        }
        if (obj.has(KEY_SWATCHES)) {
            JsonArray swatchArr = obj.get(KEY_SWATCHES).getAsJsonArray();
            for (JsonElement swatchElem : swatchArr) {
                this.addSwatch(swatchElem.getAsJsonObject(), -1);
            }
        }
        super.load(lx, obj);
    }

    public void exportSwatches(File file) {
        JsonObject obj = new JsonObject();
        obj.add(KEY_SWATCHES, (JsonElement)LXSerializable.Utils.toArray(this.lx, this.swatches, true));
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));){
            writer.setIndent("  ");
            new GsonBuilder().create().toJson((JsonElement)obj, writer);
            LX.log("Swatches saved successfully to " + file.toString());
        }
        catch (IOException iox) {
            LX.error(iox, "Could not export color swatches to file: " + file.toString());
        }
    }

    public List<LXSwatch> importSwatches(File file) {
        ArrayList<LXSwatch> imported = new ArrayList<LXSwatch>();
        try (FileReader fr = new FileReader(file);){
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
            if (obj.has(KEY_SWATCHES)) {
                JsonArray swatchArr = obj.get(KEY_SWATCHES).getAsJsonArray();
                for (JsonElement swatchElem : swatchArr) {
                    imported.add(this.addSwatch(swatchElem.getAsJsonObject(), -1));
                }
            }
        }
        catch (IOException iox) {
            LX.error(iox, "Could not import color swatches from file: " + file.toString());
        }
        return imported;
    }

    public static enum AutoCycleMode {
        NEXT,
        RANDOM;


        public String toString() {
            switch (this) {
                case NEXT: {
                    return "Next";
                }
            }
            return "Random";
        }
    }

    public static class IndexSelector
    extends DiscreteParameter {
        public IndexSelector(String name) {
            super(name, 1, 6);
            this.setDescription("Which color index in the palette to use");
            this.setOptions(selectorOptions, false);
            selectors.add(this);
        }

        @Override
        public void dispose() {
            super.dispose();
            selectors.remove(this);
        }
    }

    public static interface Listener {
        public void swatchAdded(LXPalette var1, LXSwatch var2);

        public void swatchRemoved(LXPalette var1, LXSwatch var2);

        public void swatchMoved(LXPalette var1, LXSwatch var2);
    }
}

