/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.command;

import heronarts.lx.LX;
import heronarts.lx.command.LXCommand;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.MutableParameter;
import java.util.Stack;

public class LXCommandEngine {
    private final LX lx;
    public final MutableParameter undoChanged = new MutableParameter("Undo");
    public final MutableParameter redoChanged = new MutableParameter("Redo");
    private final Stack<LXCommand> undoStack = new Stack();
    private final Stack<LXCommand> redoStack = new Stack();
    private long dirtyTimeMs = -1L;
    public final BooleanParameter dirty = new BooleanParameter("Dirty", false).setDescription("Whether the project has unsaved changes");

    public LXCommandEngine(LX lx) {
        this.lx = lx;
    }

    public LXCommandEngine perform(LXCommand command) {
        try {
            command.perform(this.lx);
            if (!command.isIgnored()) {
                if (this.undoStack.isEmpty() || this.undoStack.peek() != command) {
                    this.undoStack.push(command);
                    this.undoChanged.bang();
                }
                this.redoStack.clear();
                this.redoChanged.bang();
            }
        }
        catch (LXCommand.InvalidCommandException icx) {
            this.lx.pushError(icx, "Unexpected error performing action " + command.getName() + "\n" + this.getErrorMessage(icx));
            LX.error(icx, "Unexpected error performing action " + command + " - bad internal state?");
            this.clear();
        }
        catch (Exception x) {
            this.lx.pushError(x, "Unexpected error performing action " + command.getName() + "\n" + this.getErrorMessage(x));
            LX.error(x, "Unexpected error performing action " + command + " - bad internal state?");
            this.clear();
        }
        this.setDirty(true);
        return this;
    }

    private String getErrorMessage(Exception x) {
        String msg = x.getLocalizedMessage();
        if (msg != null) {
            return msg;
        }
        return x.getClass().getSimpleName();
    }

    public boolean isDirty() {
        return this.dirty.isOn();
    }

    public boolean isDirty(long sinceMs) {
        return this.dirtyTimeMs > sinceMs && this.isDirty();
    }

    public LXCommandEngine setDirty(boolean dirty) {
        this.dirty.setValue(dirty);
        this.dirtyTimeMs = this.lx.engine.nowMillis;
        return this;
    }

    public LXCommand getUndoCommand() {
        return this.undoStack.empty() ? null : this.undoStack.peek();
    }

    public LXCommand getRedoCommand() {
        return this.redoStack.empty() ? null : this.redoStack.peek();
    }

    public LXCommandEngine clear() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.undoChanged.bang();
        this.redoChanged.bang();
        return this;
    }

    public LXCommandEngine undo() {
        if (!this.undoStack.empty()) {
            LXCommand command = this.undoStack.pop();
            try {
                command.undo(this.lx);
                this.redoStack.push(command);
                this.undoChanged.bang();
                this.redoChanged.bang();
            }
            catch (LXCommand.InvalidCommandException icx) {
                this.lx.pushError(icx, "Unexpected error on undo of " + command.getName() + "\n" + icx.getMessage());
                LX.error(icx, "Unhandled exception on undo " + command + " - bad internal state?");
                this.clear();
            }
            catch (Exception x) {
                this.lx.pushError(x, "Unexpected error on undo of " + command.getName() + "\n" + x.getLocalizedMessage());
                LX.error(x, "Unhandled exception on undo " + command + " - bad internal state?");
                this.clear();
            }
            this.setDirty(true);
        }
        return this;
    }

    public LXCommandEngine redo() {
        if (!this.redoStack.empty()) {
            LXCommand command = this.redoStack.pop();
            try {
                command.perform(this.lx);
                this.undoStack.push(command);
                this.undoChanged.bang();
                this.redoChanged.bang();
            }
            catch (LXCommand.InvalidCommandException icx) {
                this.lx.pushError(icx, "Unexpected error on redo of " + command.getName() + "\n" + icx.getMessage());
                LX.error(icx, "Unhandled exception on redo " + command + " - bad internal state?");
                this.clear();
            }
            catch (Exception x) {
                this.lx.pushError(x, "Unexpected error on redo of " + command.getName() + "\n" + x.getLocalizedMessage());
                LX.error(x, "Unhandled exception on redo " + command + " - bad internal state?");
                this.clear();
            }
            this.setDirty(true);
        }
        return this;
    }
}

