/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.dmx;

import heronarts.lx.modulator.LXModulator;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.utils.LXUtils;

public abstract class AbstractDmxModulator
extends LXModulator {
    public final DiscreteParameter universe = new DiscreteParameter("Universe", 0, 512).setDescription("DMX universe");
    public final DiscreteParameter channel = new DiscreteParameter("Channel", 0, 512).setDescription("DMX channel");
    private int bytes = 1;

    private static int constrainBytes(int bytes) {
        return LXUtils.constrain(bytes, 1, 512);
    }

    public AbstractDmxModulator(String label) {
        this(label, 1);
    }

    public AbstractDmxModulator(String label, int bytes) {
        super(label);
        this.setBytes(bytes);
        this.addParameter("universe", this.universe);
        this.addParameter("channel", this.channel);
    }

    protected AbstractDmxModulator setBytes(int bytes) {
        if ((bytes = AbstractDmxModulator.constrainBytes(bytes)) != this.bytes) {
            this.bytes = bytes;
            this.updateMaxChannel();
        }
        return this;
    }

    private void updateMaxChannel() {
        this.channel.setRange(0, 512 - (this.bytes - 1));
    }
}

