/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.dmx;

import heronarts.lx.LX;
import heronarts.lx.LXComponentName;
import heronarts.lx.dmx.LXDmxEngine;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.pattern.LXPattern;

@LXComponentName(value="DMX")
public class DmxPattern
extends LXPattern {
    public final DiscreteParameter universe = new DiscreteParameter("Universe", 0, 512).setDescription("Starting universe");
    public final DiscreteParameter channel = new DiscreteParameter("Channel", 0, 510).setDescription("Starting channel");
    public final EnumParameter<LXDmxEngine.ByteOrder> byteOrder = new EnumParameter<LXDmxEngine.ByteOrder>("Byte Order", LXDmxEngine.ByteOrder.RGB).setDescription("DMX input byte order");

    public DmxPattern(LX lx) {
        super(lx);
        this.addParameter("universe", this.universe);
        this.addParameter("channel", this.channel);
        this.addParameter("byteOrder", this.byteOrder);
    }

    @Override
    protected void run(double deltaMs) {
        LXDmxEngine.ByteOrder byteOrder = this.byteOrder.getEnum();
        int universe = this.universe.getValuei();
        int channel = this.channel.getValuei();
        for (LXPoint p : this.model.points) {
            this.colors[p.index] = this.lx.engine.dmx.getColor(universe, channel, byteOrder);
            if ((channel += 3) < 510) continue;
            channel = 0;
            if (++universe >= 512) break;
        }
    }
}

