/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.ModelBuffer;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;

@LXCategory(value="Core")
public class BlurEffect
extends LXEffect {
    public final CompoundParameter level = new CompoundParameter("Level", 0.0, 0.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Level of the blur relative to original signal");
    public final CompoundParameter decay = new CompoundParameter("Decay", 1.0, 0.01, 60.0).setDescription("Decay time for the motion blur to diminish to decay factor").setExponent(3.0).setUnits(LXParameter.Units.SECONDS);
    public final CompoundParameter decayFactor = new CompoundParameter("Factor", 0.5, 0.01, 1.0).setDescription("Decay factor, the level reached in decay time (e.g. half-life if at 50%)").setUnits(LXParameter.Units.PERCENT_NORMALIZED);
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.MIX).setDescription("Which blending mode the blur uses");
    private final ModelBuffer blurBuffer;

    public BlurEffect(LX lx) {
        super(lx);
        this.blurBuffer = new ModelBuffer(lx, -16777216);
        this.addParameter("level", this.level);
        this.addParameter("decay", this.decay);
        this.addParameter("decayFactor", this.decayFactor);
        this.addParameter("mode", this.mode);
    }

    @Override
    protected void onEnable() {
        int[] blurArray = this.blurBuffer.getArray();
        for (int i = 0; i < blurArray.length; ++i) {
            blurArray[i] = -16777216;
        }
    }

    @Override
    public void run(double deltaMs, double amount) {
        int i;
        int blurAlpha = (int)(256.0 * amount * this.level.getValue());
        int[] blurColors = this.blurBuffer.getArray();
        double decayScale = Math.pow(this.decayFactor.getValue(), deltaMs / (1000.0 * this.decay.getValue()));
        int decayColor = LXColor.grayn(decayScale);
        for (LXPoint p : this.model.points) {
            i = p.index;
            blurColors[i] = LXColor.multiply(blurColors[i], decayColor, 256);
            blurColors[i] = LXColor.add(blurColors[i], this.colors[i], 256);
        }
        if (blurAlpha > 0) {
            switch (this.mode.getEnum()) {
                case MIX: {
                    for (LXPoint p : this.model.points) {
                        i = p.index;
                        this.colors[i] = LXColor.lerp(this.colors[i], blurColors[i], blurAlpha);
                    }
                    break;
                }
                case ADD: {
                    for (LXPoint p : this.model.points) {
                        i = p.index;
                        this.colors[i] = LXColor.add(this.colors[i], blurColors[i], blurAlpha);
                    }
                    break;
                }
                case SCREEN: {
                    for (LXPoint p : this.model.points) {
                        i = p.index;
                        this.colors[i] = LXColor.screen(this.colors[i], blurColors[i], blurAlpha);
                    }
                    break;
                }
                case MULTIPLY: {
                    for (LXPoint p : this.model.points) {
                        i = p.index;
                        this.colors[i] = LXColor.multiply(this.colors[i], blurColors[i], blurAlpha);
                    }
                    break;
                }
                case LIGHTEST: {
                    for (LXPoint p : this.model.points) {
                        i = p.index;
                        this.colors[i] = LXColor.lightest(this.colors[i], blurColors[i], blurAlpha);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.blurBuffer.dispose();
        super.dispose();
    }

    public static enum Mode {
        MIX("Mix"),
        ADD("Add"),
        SCREEN("Screen"),
        MULTIPLY("Multiply"),
        LIGHTEST("Lightest");

        public final String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

