/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponentName;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Color")
@LXComponentName(value="Hue + Saturation")
public class HueSaturationEffect
extends LXEffect {
    public final CompoundParameter hue = new CompoundParameter("Hue", 0.0, -360.0, 360.0).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Sets the amount of hue shift to apply");
    public final CompoundParameter saturation = new CompoundParameter("Saturation", 0.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Sets the amount to increase or decrease saturation");
    public final CompoundParameter brightness = new CompoundParameter("Brightness", 0.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Sets the amount to increase or decrease brightness");

    public HueSaturationEffect(LX lx) {
        super(lx);
        this.addParameter("hue", this.hue);
        this.addParameter("saturation", this.saturation);
        this.addParameter("brightness", this.brightness);
    }

    @Override
    protected void run(double deltaMs, double amount) {
        float hue = this.hue.getValuef();
        float saturation = this.saturation.getValuef();
        float brightness = this.brightness.getValuef();
        float amountf = (float)amount;
        if (amount < 1.0) {
            for (LXPoint p : this.model.points) {
                int i = p.index;
                int c = this.colors[i];
                float h = LXColor.h(c);
                float s = LXColor.s(c);
                float b = LXColor.b(c);
                this.colors[i] = LXColor.hsb(LXUtils.lerpf(h, h + hue, amountf), LXUtils.lerpf(s, LXUtils.clampf(s + saturation, 0.0f, 100.0f), amountf), LXUtils.lerpf(b, LXUtils.clampf(b + brightness, 0.0f, 100.0f), amountf));
            }
        } else {
            for (LXPoint p : this.model.points) {
                int i = p.index;
                int c = this.colors[i];
                float h = LXColor.h(c);
                float s = LXColor.s(c);
                float b = LXColor.b(c);
                this.colors[i] = LXColor.hsb(h + hue, LXUtils.clampf(s + saturation, 0.0f, 100.0f), LXUtils.clampf(b + brightness, 0.0f, 100.0f));
            }
        }
    }
}

