/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Color")
public class InvertEffect
extends LXEffect {
    public final CompoundParameter amount = new CompoundParameter("Amount", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of inversion to apply");
    public final CompoundParameter redAmount = new CompoundParameter("Red", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of inversion to apply to the green channel");
    public final CompoundParameter greenAmount = new CompoundParameter("Green", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of inversion to apply to the red channel");
    public final CompoundParameter blueAmount = new CompoundParameter("Blue", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of inversion to apply to the blue channel");
    private final int[] redLUT = new int[256];
    private final int[] greenLUT = new int[256];
    private final int[] blueLUT = new int[256];
    private double pRedAmount = -1.0;
    private double pGreenAmount = -1.0;
    private double pBlueAmount = -1.0;

    public InvertEffect(LX lx) {
        super(lx);
        this.addParameter("amount", this.amount);
        this.addParameter("redAmount", this.redAmount);
        this.addParameter("greenAmount", this.greenAmount);
        this.addParameter("blueAmount", this.blueAmount);
    }

    private void buildLookupTable(int[] table, double amount) {
        for (int i = 0; i < table.length; ++i) {
            table[i] = (int)Math.round(LXUtils.lerp(i, 255 - i, amount));
        }
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        double amount = enabledAmount * this.amount.getValue();
        if (amount == 0.0) {
            return;
        }
        double redAmount = amount * this.redAmount.getValue();
        double greenAmount = amount * this.greenAmount.getValue();
        double blueAmount = amount * this.blueAmount.getValue();
        if (redAmount == 0.0 && greenAmount == 0.0 && blueAmount == 0.0) {
            return;
        }
        if (redAmount != this.pRedAmount) {
            this.pRedAmount = redAmount;
            this.buildLookupTable(this.redLUT, this.pRedAmount);
        }
        if (greenAmount != this.pGreenAmount) {
            this.pGreenAmount = greenAmount;
            this.buildLookupTable(this.greenLUT, this.pGreenAmount);
        }
        if (blueAmount != this.pBlueAmount) {
            this.pBlueAmount = blueAmount;
            this.buildLookupTable(this.blueLUT, this.pBlueAmount);
        }
        for (LXPoint p : this.model.points) {
            int c = this.colors[p.index];
            int a = c & 0xFF000000;
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            r = this.redLUT[r];
            g = this.greenLUT[g];
            b = this.blueLUT[b];
            this.colors[p.index] = a | r << 16 | g << 8 | b;
        }
    }
}

