/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.texture.SparklePattern;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Texture")
public class SparkleEffect
extends LXEffect {
    public final SparklePattern.Engine engine;
    public final CompoundParameter amount;

    public SparkleEffect(LX lx) {
        super(lx);
        this.engine = new SparklePattern.Engine(this.model);
        this.amount = new CompoundParameter("Amount", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of sparkle to apply");
        this.addParameter("amount", this.amount);
        this.addParameters(this.engine.parameters);
    }

    @Override
    protected void onModelChanged(LXModel model) {
        this.engine.setModel(model);
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        this.engine.run(deltaMs, this.model, 0.0, enabledAmount *= this.amount.getValue());
        if (enabledAmount > 0.0) {
            int i = 0;
            for (LXPoint p : this.model.points) {
                this.colors[p.index] = LXColor.multiply(this.colors[p.index], LXColor.gray(LXUtils.clamp(this.engine.outputLevels[i++], 0.0, 100.0)), 256);
            }
        }
    }
}

