/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect.audio;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponentName;
import heronarts.lx.ModelBuffer;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.audio.SoundObjectPattern;

@LXCategory(value="Audio")
@LXComponentName(value="Sound Object")
public class SoundObjectEffect
extends LXEffect {
    public final SoundObjectPattern.Engine engine;
    private final ModelBuffer blendBuffer;
    public final EnumParameter<MaskMode> maskMode = new EnumParameter<MaskMode>("Mode", MaskMode.MULTIPLY).setDescription("How to apply the sound object mask");
    public final CompoundParameter maskDepth = new CompoundParameter("Depth", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Depth of masking effect");
    public final BooleanParameter cueMask = new BooleanParameter("CUE", false).setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Directly render the mask");

    public SoundObjectEffect(LX lx) {
        super(lx);
        this.engine = new SoundObjectPattern.Engine(lx);
        this.blendBuffer = new ModelBuffer(lx);
        this.addParameter("baseSize", this.engine.baseSize);
        this.addParameter("signalToSize", this.engine.signalToSize);
        this.addParameter("fadePercent", this.engine.contrast);
        this.addParameter("baseBrightness", this.engine.baseLevel);
        this.addParameter("modulationInput", this.engine.modulationInput);
        this.addParameter("modulationToSize", this.engine.modulationToSize);
        this.addParameter("modulationToBrt", this.engine.modulationToLevel);
        this.addParameter("signalToBrt", this.engine.signalToLevel);
        this.addParameter("selector", this.engine.selector);
        this.addParameter("positionMode", this.engine.positionMode);
        this.addParameter("shapeMode1", this.engine.shapeMode1);
        this.addParameter("shapeMode2", this.engine.shapeMode2);
        this.addParameter("shapeLerp", this.engine.shapeLerp);
        this.addParameter("scopeAmount", this.engine.scopeAmount);
        this.addParameter("scopeTimeMs", this.engine.scopeTimeMs);
        this.addParameter("maskDepth", this.maskDepth);
        this.addParameter("maskMode", this.maskMode);
        this.addParameter("cueMask", this.cueMask);
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        block4: {
            boolean cueMask = this.cueMask.isOn();
            enabledAmount *= this.maskDepth.getValue();
            if (!cueMask && !(enabledAmount > 0.0)) break block4;
            int[] blend = this.blendBuffer.getArray();
            this.engine.run(this.model, blend, deltaMs);
            if (cueMask) {
                for (LXPoint p : this.model.points) {
                    this.colors[p.index] = blend[p.index];
                }
            } else {
                int alpha = LXColor.blendMask(enabledAmount);
                LXBlend.FunctionalBlend.BlendFunction mask = this.maskMode.getEnum().function;
                for (LXPoint p : this.model.points) {
                    this.colors[p.index] = mask.apply(this.colors[p.index], blend[p.index], alpha);
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.blendBuffer.dispose();
        super.dispose();
    }

    public static enum MaskMode {
        MULTIPLY("Mask", LXColor::multiply),
        SPOTLIGHT("Spotlight", LXColor::spotlight),
        HIGHLIGHT("Highlight", LXColor::highlight),
        ADD("Add", LXColor::add),
        LERP("Lerp", LXColor::lerp);

        public final String label;
        public final LXBlend.FunctionalBlend.BlendFunction function;

        private MaskMode(String label, LXBlend.FunctionalBlend.BlendFunction function) {
            this.label = label;
            this.function = function;
        }

        public String toString() {
            return this.label;
        }
    }
}

