/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect.color;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponentName;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LinkedColorParameter;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;

@LXCategory(value="Color")
@LXComponentName(value="Color Mask")
public class ColorMaskEffect
extends LXEffect {
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.MULTIPLY).setDescription("How to apply the color mask");
    public final LinkedColorParameter color = new LinkedColorParameter("Color", -1).setDescription("Masking color");
    public final CompoundParameter depth = new CompoundParameter("Depth", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of masking to apply");

    public ColorMaskEffect(LX lx) {
        super(lx);
        this.addParameter("depth", this.depth);
        this.addParameter("mode", this.mode);
        this.addParameter("color", this.color);
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        if ((enabledAmount *= this.depth.getValue()) == 0.0) {
            return;
        }
        int color = this.color.calcColor();
        int alpha = LXColor.blendMask(enabledAmount);
        LXBlend.FunctionalBlend.BlendFunction blend = this.mode.getEnum().function;
        for (LXPoint p : this.model.points) {
            this.colors[p.index] = blend.apply(this.colors[p.index], color, alpha);
        }
    }

    public static enum Mode {
        MULTIPLY("Multiply", LXColor::multiply),
        ADD("Add", LXColor::add),
        SUBTRACT("Subtract", LXColor::subtract),
        DIFFERENCE("Difference", LXColor::difference),
        SPOTLIGHT("Spotlight", LXColor::spotlight),
        HIGHLIGHT("Highlight", LXColor::highlight),
        LERP("Lerp", LXColor::lerp);

        public final String label;
        public final LXBlend.FunctionalBlend.BlendFunction function;

        private Mode(String label, LXBlend.FunctionalBlend.BlendFunction function) {
            this.label = label;
            this.function = function;
        }

        public String toString() {
            return this.label;
        }
    }
}

