/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.parameter.BooleanParameter;
import javax.sound.midi.MidiDevice;

public abstract class LXMidiDevice {
    protected final LXMidiEngine engine;
    protected MidiDevice device;
    public final BooleanParameter enabled = new BooleanParameter("Enabled", false).setMappable(false);
    boolean keepAlive = true;
    public final BooleanParameter connected = new BooleanParameter("Connected", true);

    protected LXMidiDevice(LXMidiEngine engine, MidiDevice device) {
        this.engine = engine;
        this.device = device;
        this.enabled.addListener(p -> this.onEnabled(this.enabled.isOn()));
    }

    void setDevice(MidiDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("Cannot set null device on LXMidiDevice");
        }
        if (this.device != device) {
            this.close();
            this.device = device;
            this.enabled.bang();
            this.connected.setValue(true);
        }
    }

    MidiDevice getDevice() {
        return this.device;
    }

    protected abstract void close();

    public final LXMidiDevice open() {
        this.enabled.setValue(true);
        return this;
    }

    public String getName() {
        return LXMidiEngine.getDeviceName(this.device.getDeviceInfo());
    }

    public String getDescription() {
        return this.device.getDeviceInfo().getDescription();
    }

    protected abstract void onEnabled(boolean var1);

    void dispose() {
        this.close();
        try {
            if (this.device.isOpen()) {
                this.device.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

