/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXMappingEngine;
import heronarts.lx.LXSerializable;
import heronarts.lx.Tempo;
import heronarts.lx.command.LXCommand;
import heronarts.lx.midi.LXMidiDevice;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.LXMidiMapping;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiBeat;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.MidiPitchBend;
import heronarts.lx.midi.surface.APC40;
import heronarts.lx.midi.surface.APC40Mk2;
import heronarts.lx.midi.surface.APCmini;
import heronarts.lx.midi.surface.DJM900nxs2;
import heronarts.lx.midi.surface.DJMA9;
import heronarts.lx.midi.surface.DJMV10;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.midi.surface.MidiFighterTwister;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.ObjectParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.ShortMessage;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiNotification;

public class LXMidiEngine
extends LXComponent
implements LXOscComponent {
    private static final String COREMIDI4J_HEADER = "CoreMIDI4J - ";
    private final List<LXMidiListener> listeners = new ArrayList<LXMidiListener>();
    private final List<DeviceListener> deviceListeners = new ArrayList<DeviceListener>();
    private final List<MappingListener> mappingListeners = new ArrayList<MappingListener>();
    private final AtomicBoolean hasInputMessage = new AtomicBoolean(false);
    private final List<LXShortMessage> threadSafeInputQueue = Collections.synchronizedList(new ArrayList());
    private final List<LXShortMessage> engineThreadInputQueue = new ArrayList<LXShortMessage>();
    private final List<LXMidiInput> mutableInputs = new CopyOnWriteArrayList<LXMidiInput>();
    private final List<LXMidiOutput> mutableOutputs = new CopyOnWriteArrayList<LXMidiOutput>();
    private final List<LXMidiSurface> mutableSurfaces = new CopyOnWriteArrayList<LXMidiSurface>();
    public final List<LXMidiInput> inputs = Collections.unmodifiableList(this.mutableInputs);
    public final List<LXMidiOutput> outputs = Collections.unmodifiableList(this.mutableOutputs);
    public final List<LXMidiSurface> surfaces = Collections.unmodifiableList(this.mutableSurfaces);
    private final List<LXMidiMapping> mutableMappings = new ArrayList<LXMidiMapping>();
    public final List<LXMidiMapping> mappings = Collections.unmodifiableList(this.mutableMappings);
    private final Map<MidiDevice.Info, LXMidiInput> midiInfoToInput = new HashMap<MidiDevice.Info, LXMidiInput>();
    private final Map<MidiDevice.Info, LXMidiOutput> midiInfoToOutput = new HashMap<MidiDevice.Info, LXMidiOutput>();
    private final Map<String, Class<? extends LXMidiSurface>> registeredSurfaces = new HashMap<String, Class<? extends LXMidiSurface>>();
    private final InitializationLock initializationLock = new InitializationLock();
    public final BooleanParameter computerKeyboardEnabled = new BooleanParameter("Computer MIDI Keyboard", false).setDescription("Whether the computer keyboard plays notes to MIDI tracks");
    public final DiscreteParameter computerKeyboardOctave = new DiscreteParameter("Computer MIDI Keyboard Octave", 5, 0, 11).setDescription("What octave the MIDI computer keyboard is in");
    public final ObjectParameter<Integer> computerKeyboardVelocity = new ObjectParameter<Integer>("Computer MIDI Keyboard Velocity", new Integer[]{1, 20, 40, 60, 80, 100, 127}, Integer.valueOf(100)).setDescription("What velocity the MIDI computer keyboard uses");
    private final MidiDeviceUpdateThread deviceUpdateThread = new MidiDeviceUpdateThread();
    private static final String PATH_NOTE = "note";
    private static final String PATH_CC = "cc";
    private static final String PATH_PITCHBEND = "pitchbend";
    private static final String KEY_INPUTS = "inputs";
    private static final String KEY_SURFACES = "surfaces";
    private static final String KEY_MAPPINGS = "mapping";
    private final List<JsonObject> rememberMidiInputs = new ArrayList<JsonObject>();
    private final List<JsonObject> rememberMidiSurfaces = new ArrayList<JsonObject>();
    private static final String MIDI_LOG_PREFIX = "[MIDI] ";

    public LXMidiEngine(LX lx) {
        super(lx);
        this.registeredSurfaces.put("Akai APC40", APC40.class);
        this.registeredSurfaces.put("APC40 mkII", APC40Mk2.class);
        this.registeredSurfaces.put("APC MINI", APCmini.class);
        this.registeredSurfaces.put("DJM-900NXS2", DJM900nxs2.class);
        this.registeredSurfaces.put("DJM-A9", DJMA9.class);
        this.registeredSurfaces.put("DJM-V10", DJMV10.class);
        this.registeredSurfaces.put("Midi Fighter Twister", MidiFighterTwister.class);
        this.computerKeyboardEnabled.setMappable(false);
        this.computerKeyboardOctave.setMappable(false);
        this.computerKeyboardVelocity.setMappable(false);
        this.computerKeyboardVelocity.setWrappable(false);
        this.addParameter("computerKeyboardEnabled", this.computerKeyboardEnabled);
        this.addParameter("computerKeyboardOctave", this.computerKeyboardOctave);
        this.addParameter("computerKeyboardVelocity", this.computerKeyboardVelocity);
    }

    public LXMidiEngine registerSurface(final String deviceName, Class<? extends LXMidiSurface> surfaceClass) {
        this.lx.registry.checkRegistration();
        if (this.registeredSurfaces.containsKey(deviceName)) {
            throw new IllegalStateException("Existing midi device name " + deviceName + " cannot be remapped to " + surfaceClass);
        }
        this.registeredSurfaces.put(deviceName, surfaceClass);
        this.whenReady(new Runnable(){

            @Override
            public void run() {
                LXMidiEngine.this.checkForNewSurfaceType(deviceName);
            }
        });
        return this;
    }

    public void initialize() {
        this.deviceUpdateThread.start();
        new Thread("LXMidiEngine Device Initialization"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (MidiDevice.Info deviceInfo : CoreMidiDeviceProvider.getMidiDeviceInfo()) {
                        try {
                            MidiDevice device = MidiSystem.getMidiDevice(deviceInfo);
                            if (device.getMaxTransmitters() != 0) {
                                LXMidiInput input = new LXMidiInput(LXMidiEngine.this, device);
                                LXMidiEngine.this.mutableInputs.add(input);
                                LXMidiEngine.this.midiInfoToInput.put(deviceInfo, input);
                            }
                            if (device.getMaxReceivers() == 0) continue;
                            LXMidiOutput output = new LXMidiOutput(LXMidiEngine.this, device);
                            LXMidiEngine.this.mutableOutputs.add(output);
                            LXMidiEngine.this.midiInfoToOutput.put(deviceInfo, output);
                        }
                        catch (MidiUnavailableException mux) {
                            LXMidiEngine.error(mux, "MidiUnavailable on MIDI device initialization thread: " + mux.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception x) {
                    LXMidiEngine.error(x, "Unexpected MIDI error, MIDI unavailable: " + x.getLocalizedMessage());
                }
                for (LXMidiInput input : LXMidiEngine.this.inputs) {
                    LXMidiEngine.this.instantiateSurface(input, false);
                }
                InitializationLock x = LXMidiEngine.this.initializationLock;
                synchronized (x) {
                    LXMidiEngine.this.initializationLock.ready = true;
                    LXMidiEngine.this.initializationLock.notifyAll();
                }
                ((LXMidiEngine)LXMidiEngine.this).lx.engine.addTask(() -> {
                    for (Runnable runnable : LXMidiEngine.this.initializationLock.whenReady) {
                        runnable.run();
                    }
                });
                boolean listening = false;
                try {
                    if (CoreMidiDeviceProvider.isLibraryLoaded()) {
                        CoreMidiDeviceProvider.addNotificationListener((CoreMidiNotification)new CoreMidiNotification(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void midiSystemUpdated() {
                                MidiDeviceUpdateThread midiDeviceUpdateThread = LXMidiEngine.this.deviceUpdateThread;
                                synchronized (midiDeviceUpdateThread) {
                                    LXMidiEngine.this.deviceUpdateThread.notify();
                                }
                            }
                        });
                        listening = true;
                    }
                }
                catch (CoreMidiException cmx) {
                    LXMidiEngine.error((Exception)((Object)cmx), "Could not initialize CoreMidi notification listener: " + cmx.getMessage());
                }
                if (!listening) {
                    LXMidiEngine.this.deviceUpdateThread.setPolling();
                }
            }
        }.start();
    }

    public void disposeSurfaces() {
        for (LXMidiSurface surface : this.surfaces) {
            surface.dispose();
        }
        this.mutableSurfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Iterator<LXMidiOutput> iterator = this.deviceUpdateThread;
        synchronized (iterator) {
            this.deviceUpdateThread.interrupt();
        }
        for (LXMidiInput input : this.inputs) {
            input.dispose();
        }
        this.mutableInputs.clear();
        for (LXMidiOutput output : this.outputs) {
            output.dispose();
        }
        this.mutableOutputs.clear();
        super.dispose();
    }

    private void updateMidiDevices() {
        try {
            for (LXMidiInput lXMidiInput : this.mutableInputs) {
                lXMidiInput.keepAlive = false;
            }
            for (LXMidiOutput lXMidiOutput : this.mutableOutputs) {
                lXMidiOutput.keepAlive = false;
            }
            ArrayList<MidiDevice> checkForSurface = null;
            for (MidiDevice.Info deviceInfo : CoreMidiDeviceProvider.getMidiDeviceInfo()) {
                MidiDevice device;
                LXMidiOutput existingOutput;
                LXMidiInput existingInput = this.midiInfoToInput.get(deviceInfo);
                if (existingInput != null) {
                    existingInput.keepAlive = true;
                    if (!existingInput.connected.isOn()) {
                        MidiDevice device2 = MidiSystem.getMidiDevice(deviceInfo);
                        this.lx.engine.addTask(() -> existingInput.setDevice(device2));
                    }
                }
                if ((existingOutput = this.midiInfoToOutput.get(deviceInfo)) != null) {
                    existingOutput.keepAlive = true;
                    if (!existingOutput.connected.isOn()) {
                        device = MidiSystem.getMidiDevice(deviceInfo);
                        this.lx.engine.addTask(() -> existingOutput.setDevice(device));
                    }
                }
                if (existingInput != null || existingOutput != null) continue;
                try {
                    device = MidiSystem.getMidiDevice(deviceInfo);
                    String deviceName = LXMidiEngine.getDeviceName(deviceInfo);
                    if (device.getMaxTransmitters() != 0) {
                        LXMidiInput input = this.findInput(deviceName);
                        if (input != null) {
                            input.keepAlive = true;
                            this.lx.engine.addTask(() -> input.setDevice(device));
                        } else {
                            this.lx.engine.addTask(() -> this.addInput(deviceInfo, device));
                            if (checkForSurface == null) {
                                checkForSurface = new ArrayList<MidiDevice>();
                            }
                            checkForSurface.add(device);
                        }
                    }
                    if (device.getMaxReceivers() == 0) continue;
                    LXMidiOutput output = this.findOutput(deviceName);
                    if (output != null) {
                        output.keepAlive = true;
                        this.lx.engine.addTask(() -> output.setDevice(device));
                        continue;
                    }
                    this.lx.engine.addTask(() -> this.addOutput(deviceInfo, device));
                }
                catch (MidiUnavailableException mux) {
                    LXMidiEngine.error(mux, "MIDI unavailable in updateMidiDevices: " + mux.getLocalizedMessage());
                }
            }
            for (LXMidiInput input : this.mutableInputs) {
                if (input.keepAlive) continue;
                input.connected.setValue(false);
            }
            for (LXMidiOutput output : this.mutableOutputs) {
                if (output.keepAlive) continue;
                output.connected.setValue(false);
            }
            if (checkForSurface != null) {
                ArrayList<MidiDevice> arrayList = checkForSurface;
                this.lx.engine.addTask(() -> {
                    for (MidiDevice device : checkForSurface2) {
                        this.checkForNewSurfaceDevice(device);
                    }
                });
            }
        }
        catch (Exception x) {
            LXMidiEngine.error(x, "Unhandled exception in midi system update: " + x.getLocalizedMessage());
        }
    }

    private void addInput(MidiDevice.Info deviceInfo, MidiDevice device) {
        LXMidiInput input = new LXMidiInput(this, device);
        this.mutableInputs.add(input);
        this.midiInfoToInput.put(deviceInfo, input);
        JsonObject unremember = null;
        for (JsonObject remembered : this.rememberMidiInputs) {
            if (!remembered.get("name").getAsString().equals(input.getName())) continue;
            unremember = remembered;
            input.load(this.lx, unremember);
            break;
        }
        if (unremember != null) {
            this.rememberMidiInputs.remove(unremember);
        }
        for (DeviceListener listener : this.deviceListeners) {
            listener.inputAdded(this, input);
        }
    }

    private void addOutput(MidiDevice.Info deviceInfo, MidiDevice device) {
        LXMidiOutput output = new LXMidiOutput(this, device);
        this.mutableOutputs.add(output);
        this.midiInfoToOutput.put(deviceInfo, output);
        for (DeviceListener listener : this.deviceListeners) {
            listener.outputAdded(this, output);
        }
    }

    public static String getDeviceName(MidiDevice.Info deviceInfo) {
        String name = deviceInfo.getName();
        if (name.indexOf(COREMIDI4J_HEADER) == 0) {
            name = name.substring(COREMIDI4J_HEADER.length());
        }
        return name;
    }

    private void checkForNewSurfaceDevice(MidiDevice device) {
        for (LXMidiSurface surface : this.mutableSurfaces) {
            if (surface.input.device != device) continue;
            return;
        }
        this.attemptMidiSurface(this.findInput(device));
    }

    private void checkForNewSurfaceType(String deviceName) {
        LXMidiSurface surface = this.findSurface(deviceName);
        if (surface != null) {
            return;
        }
        for (LXMidiInput input : this.mutableInputs) {
            if (!input.getName().equals(deviceName)) continue;
            this.attemptMidiSurface(input);
        }
    }

    private void attemptMidiSurface(LXMidiInput input) {
        if (input == null) {
            return;
        }
        LXMidiSurface surface = this.instantiateSurface(input, true);
        if (surface == null) {
            return;
        }
        JsonObject unremember = null;
        for (JsonObject remember : this.rememberMidiSurfaces) {
            if (!remember.get("name").getAsString().equals(surface.getName())) continue;
            unremember = remember;
            surface.load(this.lx, remember);
            surface.enabled.setValue(true);
            break;
        }
        if (unremember != null) {
            this.rememberMidiSurfaces.remove(unremember);
        }
    }

    private LXMidiSurface instantiateSurface(LXMidiInput input, boolean notifyListeners) {
        Class<? extends LXMidiSurface> surfaceClass = this.registeredSurfaces.get(input.getName());
        if (surfaceClass == null) {
            return null;
        }
        LXMidiSurface surface = null;
        try {
            surface = surfaceClass.getConstructor(LX.class, LXMidiInput.class, LXMidiOutput.class).newInstance(this.lx, input, this.findOutput(input));
            this.mutableSurfaces.add(surface);
            if (notifyListeners) {
                for (DeviceListener listener : this.deviceListeners) {
                    listener.surfaceAdded(this, surface);
                }
            }
        }
        catch (Exception x) {
            LXMidiEngine.error(x, "Could not instantiate midi surface class: " + surfaceClass);
        }
        return surface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilReady() {
        InitializationLock initializationLock = this.initializationLock;
        synchronized (initializationLock) {
            while (!this.initializationLock.ready) {
                try {
                    this.initializationLock.wait();
                }
                catch (InterruptedException ix) {
                    LXMidiEngine.error(ix, "MIDI initialization lock was interrupted??");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whenReady(Runnable runnable) {
        InitializationLock initializationLock = this.initializationLock;
        synchronized (initializationLock) {
            if (this.initializationLock.ready) {
                runnable.run();
            } else {
                this.initializationLock.whenReady.add(runnable);
            }
        }
    }

    public List<LXMidiInput> getInputs() {
        return this.inputs;
    }

    public List<LXMidiOutput> getOutputs() {
        return this.outputs;
    }

    public LXMidiInput matchInput(String name) {
        return this.matchInput(new String[]{name});
    }

    public LXMidiInput matchInput(String[] names) {
        return this.matchDevice(this.mutableInputs, names);
    }

    public LXMidiOutput matchOutput(String name) {
        return this.matchOutput(new String[]{name});
    }

    public LXMidiOutput matchOutput(String[] names) {
        return this.matchDevice(this.mutableOutputs, names);
    }

    public LXMidiSurface findSurface(LXMidiInput input) {
        for (LXMidiSurface surface : this.mutableSurfaces) {
            if (surface.getInput() != input) continue;
            return surface;
        }
        return null;
    }

    public LXMidiSurface findSurface(String name) {
        return this.findSurface(name, 0);
    }

    public LXMidiSurface findSurface(String name, int index) {
        int i = 0;
        for (LXMidiSurface surface : this.mutableSurfaces) {
            if (!surface.getName().equals(name)) continue;
            if (i >= index) {
                return surface;
            }
            ++i;
        }
        return null;
    }

    private <T extends LXMidiDevice> T matchDevice(List<T> devices, String[] names) {
        for (LXMidiDevice device : devices) {
            String deviceName = device.getName();
            for (String name : names) {
                if (!deviceName.contains(name)) continue;
                return (T)device;
            }
        }
        return null;
    }

    private LXMidiOutput findOutput(LXMidiInput input) {
        int index = 0;
        String inputName = input.getName();
        for (LXMidiInput that : this.mutableInputs) {
            if (that == input) break;
            if (!that.getName().equals(inputName)) continue;
            ++index;
        }
        return this.findDevice(this.mutableOutputs, inputName, index);
    }

    public LXMidiOutput findOutput(String name) {
        return this.findDevice(this.mutableOutputs, name);
    }

    public LXMidiOutput findOutput(MidiDevice device) {
        return this.findDevice(this.mutableOutputs, device);
    }

    public LXMidiInput findInput(String name) {
        return this.findDevice(this.mutableInputs, name);
    }

    public LXMidiInput findInput(MidiDevice device) {
        return this.findDevice(this.mutableInputs, device);
    }

    private <T extends LXMidiDevice> T findDevice(List<T> devices, MidiDevice device) {
        for (LXMidiDevice that : devices) {
            if (that.device != device) continue;
            return (T)that;
        }
        return null;
    }

    private <T extends LXMidiDevice> T findDevice(List<T> devices, String name) {
        return this.findDevice(devices, name, 0);
    }

    private <T extends LXMidiDevice> T findDevice(List<T> devices, String name, int index) {
        int i = 0;
        for (LXMidiDevice device : devices) {
            if (!device.getName().equals(name)) continue;
            if (i >= index) {
                return (T)device;
            }
            ++i;
        }
        return null;
    }

    public LXMidiEngine addListener(LXMidiListener listener) {
        Objects.requireNonNull(listener, "May not add null LXMidiEngine.LXMidiListener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXMidiEngine.Listener: " + listener);
        }
        this.listeners.add(listener);
        return this;
    }

    public LXMidiEngine removeListener(LXMidiListener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-existent LXMidiEngine.Listener: " + listener);
        }
        this.listeners.remove(listener);
        return this;
    }

    public LXMidiEngine addDeviceListener(DeviceListener listener) {
        Objects.requireNonNull(listener, "May not add null LXMidiEngine.DeviceListener");
        if (this.deviceListeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXMidiEngine.DeviceListener: " + listener);
        }
        this.deviceListeners.add(listener);
        return this;
    }

    public LXMidiEngine removeDeviceListener(DeviceListener listener) {
        if (!this.deviceListeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-registered LXMidiEngine.DeviceListener: " + listener);
        }
        this.deviceListeners.remove(listener);
        return this;
    }

    public LXMidiEngine addMappingListener(MappingListener listener) {
        Objects.requireNonNull(listener, "May not add null LXMidiEngine.MappingListener");
        if (this.mappingListeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXMidiEngine.MappingListener: " + listener);
        }
        this.mappingListeners.add(listener);
        return this;
    }

    public LXMidiEngine removeMappingListener(MappingListener listener) {
        if (!this.mappingListeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-registered LXMidiEngine.MappingListener: " + listener);
        }
        this.mappingListeners.remove(listener);
        return this;
    }

    void queueInputMessage(LXShortMessage message) {
        this.threadSafeInputQueue.add(message);
        this.hasInputMessage.set(true);
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        try {
            String path = parts[index];
            if (path.equals(PATH_NOTE)) {
                int pitch = message.getInt();
                int velocity = message.getInt();
                int channel = message.getInt();
                this.dispatch(new MidiNoteOn(channel, pitch, velocity));
                return true;
            }
            if (path.equals(PATH_CC)) {
                int value = message.getInt();
                int cc = message.getInt();
                int channel = message.getInt();
                this.dispatch(new MidiControlChange(channel, cc, value));
                return true;
            }
            if (parts[index].equals(PATH_PITCHBEND)) {
                int msb = message.getInt();
                int channel = message.getInt();
                this.dispatch(new MidiPitchBend(channel, msb));
                return true;
            }
        }
        catch (InvalidMidiDataException imdx) {
            LXMidiEngine.error("Invalid MIDI message via OSC: " + message);
            return false;
        }
        return super.handleOscMessage(message, parts, index);
    }

    private void createMapping(LXShortMessage message) {
        LXNormalizedParameter parameter = this.lx.engine.mapping.getControlTarget();
        if (parameter == null) {
            return;
        }
        if (!LXMidiMapping.isValidMessageType(message)) {
            return;
        }
        for (LXMidiMapping mapping : this.mutableMappings) {
            if (mapping.parameter != parameter || !mapping.matches(message)) continue;
            return;
        }
        this.lx.command.perform(new LXCommand.Midi.AddMapping(message, parameter));
        this.lx.engine.mapping.setControlTarget(null);
    }

    private boolean applyMapping(LXShortMessage message) {
        boolean applied = false;
        for (LXMidiMapping mapping : this.mutableMappings) {
            if (!mapping.matches(message)) continue;
            mapping.apply(this.lx, message);
            applied = true;
        }
        return applied;
    }

    public LXMidiEngine addMapping(LXMidiMapping mapping) {
        this.mutableMappings.add(mapping);
        for (MappingListener mappingListener : this.mappingListeners) {
            mappingListener.mappingAdded(this, mapping);
        }
        return this;
    }

    public LXMidiEngine removeMapping(LXMidiMapping mapping) {
        this.mutableMappings.remove(mapping);
        for (MappingListener mappingListener : this.mappingListeners) {
            mappingListener.mappingRemoved(this, mapping);
        }
        return this;
    }

    private List<LXMidiMapping> findParameterMappings(LXParameter parameter) {
        ArrayList<LXMidiMapping> found = null;
        for (LXMidiMapping mapping : this.mappings) {
            if (parameter != mapping.parameter) continue;
            if (found == null) {
                found = new ArrayList<LXMidiMapping>();
            }
            found.add(mapping);
        }
        return found;
    }

    public List<LXMidiMapping> findMappings(LXComponent component) {
        ArrayList<LXMidiMapping> found = null;
        for (LXMidiMapping mapping : this.mappings) {
            if (!component.contains(mapping.parameter)) continue;
            if (found == null) {
                found = new ArrayList<LXMidiMapping>();
            }
            found.add(mapping);
        }
        return found;
    }

    public LXMidiEngine removeParameterMappings(LXParameter parameter) {
        List<LXMidiMapping> remove = this.findParameterMappings(parameter);
        if (remove != null) {
            for (LXMidiMapping mapping : remove) {
                this.removeMapping(mapping);
            }
        }
        return this;
    }

    public LXMidiEngine removeMappings(LXComponent component) {
        List<LXMidiMapping> remove = this.findMappings(component);
        if (remove != null) {
            for (LXMidiMapping mapping : remove) {
                this.removeMapping(mapping);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        if (this.hasInputMessage.compareAndSet(true, false)) {
            this.engineThreadInputQueue.clear();
            List<LXShortMessage> list = this.threadSafeInputQueue;
            synchronized (list) {
                this.engineThreadInputQueue.addAll(this.threadSafeInputQueue);
                this.threadSafeInputQueue.clear();
            }
            for (LXShortMessage message : this.engineThreadInputQueue) {
                LXMidiInput input = message.getInput();
                input.dispatch(message);
                if (!input.enabled.isOn()) continue;
                this.dispatch(message);
            }
        }
    }

    public void dispatch(LXShortMessage message) {
        LXMidiInput input = message.getInput();
        if (input != null) {
            if (input.controlEnabled.isOn()) {
                if (this.lx.engine.mapping.getMode() == LXMappingEngine.Mode.MIDI) {
                    this.createMapping(message);
                    return;
                }
                if (this.applyMapping(message)) {
                    return;
                }
            }
            if (message instanceof MidiBeat && input.syncEnabled.isOn() && this.lx.engine.tempo.clockSource.getObject() == Tempo.ClockSource.MIDI) {
                MidiBeat beat = (MidiBeat)message;
                if (beat.isStop()) {
                    this.lx.engine.tempo.stop();
                } else {
                    double period = beat.getPeriod();
                    if (period != -1.0) {
                        this.lx.engine.tempo.setPeriod(period);
                    }
                    this.lx.engine.tempo.trigger(beat.getBeat(), beat.nanoTime);
                }
            }
        }
        for (LXMidiListener listener : this.listeners) {
            message.dispatch(listener);
        }
        if (input == null || input.channelEnabled.isOn()) {
            for (LXAbstractChannel channelBus : this.lx.engine.mixer.channels) {
                if (!channelBus.midiFilter.filter(message)) continue;
                channelBus.midiMessage(message);
            }
            this.lx.engine.modulation.midiDispatch(message);
        }
    }

    @Override
    public void save(LX lx, JsonObject object) {
        this.waitUntilReady();
        super.save(lx, object);
        JsonArray inputs = new JsonArray();
        for (LXMidiInput input : this.mutableInputs) {
            if (!input.enabled.isOn()) continue;
            inputs.add((JsonElement)LXSerializable.Utils.toObject(lx, input));
        }
        for (JsonObject remembered : this.rememberMidiInputs) {
            inputs.add((JsonElement)remembered);
        }
        JsonArray surfaces = new JsonArray();
        for (LXMidiSurface surface : this.mutableSurfaces) {
            if (!surface.enabled.isOn()) continue;
            surfaces.add((JsonElement)LXSerializable.Utils.toObject(lx, surface));
        }
        for (JsonObject remembered : this.rememberMidiSurfaces) {
            surfaces.add((JsonElement)remembered);
        }
        object.add(KEY_INPUTS, (JsonElement)inputs);
        object.add(KEY_SURFACES, (JsonElement)surfaces);
        object.add(KEY_MAPPINGS, (JsonElement)LXSerializable.Utils.toArray(lx, this.mutableMappings));
    }

    @Override
    public void load(LX lx, JsonObject object) {
        this.rememberMidiInputs.clear();
        this.rememberMidiSurfaces.clear();
        this.mutableMappings.clear();
        super.load(lx, object);
        if (object.has(KEY_MAPPINGS)) {
            JsonArray mappings = object.getAsJsonArray(KEY_MAPPINGS);
            for (JsonElement element : mappings) {
                try {
                    this.addMapping(LXMidiMapping.create(this.lx, element.getAsJsonObject()));
                }
                catch (Exception x) {
                    LXMidiEngine.error(x, "Could not load MIDI mapping: " + element.toString());
                }
            }
        }
        this.whenReady(() -> {
            JsonArray surfaces;
            JsonArray inputs;
            if (object.has(KEY_INPUTS) && (inputs = object.getAsJsonArray(KEY_INPUTS)).size() > 0) {
                for (JsonElement element : inputs) {
                    JsonObject inputObj = element.getAsJsonObject();
                    String inputName = inputObj.get("name").getAsString();
                    LXMidiInput input = this.findInput(inputName);
                    if (input != null) {
                        input.load(lx, inputObj);
                        continue;
                    }
                    this.rememberMidiInputs.add(inputObj);
                }
            }
            if (object.has(KEY_SURFACES) && (surfaces = object.getAsJsonArray(KEY_SURFACES)).size() > 0) {
                HashMap<String, Integer> surfaceCount = new HashMap<String, Integer>();
                for (JsonElement element : surfaces) {
                    JsonObject surfaceObj = element.getAsJsonObject();
                    String surfaceName = surfaceObj.get("name").getAsString();
                    int count = surfaceCount.containsKey(surfaceName) ? (Integer)surfaceCount.get(surfaceName) : 0;
                    LXMidiSurface surface = this.findSurface(surfaceName, count);
                    surfaceCount.put(surfaceName, count + 1);
                    if (surface != null) {
                        surface.load(lx, surfaceObj);
                        surface.enabled.setValue(true);
                        continue;
                    }
                    this.rememberMidiSurfaces.add(surfaceObj);
                }
            }
        });
    }

    public static final void log(String message) {
        LX.log(MIDI_LOG_PREFIX + message);
    }

    public static final void error(String message) {
        LX.error(MIDI_LOG_PREFIX + message);
    }

    public static final void error(Exception x, String message) {
        LX.error(x, MIDI_LOG_PREFIX + message);
    }

    private class MidiDeviceUpdateThread
    extends Thread {
        private boolean polling;
        private boolean setPolling;

        private MidiDeviceUpdateThread() {
            super("LXMidiEngine Device Update");
            this.polling = false;
            this.setPolling = false;
        }

        private synchronized void setPolling() {
            this.polling = true;
            this.setPolling = true;
            this.notify();
        }

        @Override
        public synchronized void run() {
            while (!this.isInterrupted()) {
                try {
                    this.wait(this.polling ? 5000L : 0L);
                }
                catch (InterruptedException ix) {
                    break;
                }
                if (!this.setPolling) {
                    LXMidiEngine.this.updateMidiDevices();
                }
                this.setPolling = false;
            }
            LXMidiEngine.log("LXMidiEngine Device Update Thread finished.");
        }
    }

    private class InitializationLock {
        private final List<Runnable> whenReady = new ArrayList<Runnable>();
        private boolean ready = false;

        private InitializationLock() {
        }
    }

    public static interface DeviceListener {
        public void inputAdded(LXMidiEngine var1, LXMidiInput var2);

        public void outputAdded(LXMidiEngine var1, LXMidiOutput var2);

        public void surfaceAdded(LXMidiEngine var1, LXMidiSurface var2);
    }

    public static interface MappingListener {
        public void mappingAdded(LXMidiEngine var1, LXMidiMapping var2);

        public void mappingRemoved(LXMidiEngine var1, LXMidiMapping var2);
    }

    public static enum Channel {
        CH_1,
        CH_2,
        CH_3,
        CH_4,
        CH_5,
        CH_6,
        CH_7,
        CH_8,
        CH_9,
        CH_10,
        CH_11,
        CH_12,
        CH_13,
        CH_14,
        CH_15,
        CH_16,
        OMNI;


        public boolean matches(ShortMessage message) {
            switch (this) {
                case OMNI: {
                    return true;
                }
            }
            return message.getChannel() == this.ordinal();
        }

        public int getChannel() {
            switch (this) {
                case OMNI: {
                    return -1;
                }
            }
            return this.ordinal();
        }

        public String toString() {
            switch (this) {
                case OMNI: {
                    return "Omni";
                }
            }
            return "Ch." + (this.ordinal() + 1);
        }
    }
}

